/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.vendor.mysql8;

import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.tx.Template;
import org.bndly.schema.api.tx.TransactionCallback;
import org.bndly.schema.api.tx.TransactionStatus;
import org.bndly.schema.api.tx.TransactionTemplate;
import org.bndly.schema.vendor.def.CountGreaterZeroToBooleanMapper;
import org.bndly.schema.vendor.def.DefaultIndexExistenceAdapter;

public class MySQL8IndexExistenceAdapter
extends DefaultIndexExistenceAdapter {
    public boolean isIndexDefinedOnTableColumn(String dbSchemaName, final String indexName, Table table, TransactionTemplate template) {
        if (dbSchemaName == null) {
            throw new IllegalStateException("the dbSchemaName is required to determine if the index " + indexName + " is defined");
        }
        final String schemaTableName = dbSchemaName + "/" + table.getTableName();
        return (Boolean)template.doInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus transactionStatus, Template template) {
                return (Boolean)template.queryForObject("SELECT COUNT(*) FROM INFORMATION_SCHEMA.INNODB_TABLES t, INFORMATION_SCHEMA.INNODB_INDEXES idx WHERE idx.NAME=? AND idx.TABLE_ID=t.TABLE_ID AND t.NAME=?", new Object[]{indexName, schemaTableName}, (RowMapper)new CountGreaterZeroToBooleanMapper());
            }
        });
    }
}

