/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.impl.AttributeColumnToTableBinding;
import org.bndly.schema.impl.MediatorRegistryImpl;
import org.bndly.schema.impl.RecordImpl;
import org.bndly.schema.model.Attribute;

class AttributeMappingRecordRowMapper
implements RowMapper<Record> {
    private final Map<String, AttributeColumnToTableBinding> attributeMappings;
    private final Map<String, TypeTable> tablesByIdColumnAlias;
    private final MediatorRegistryImpl mediatorRegistry;
    private final Accessor accessor;
    private final RecordContext recordContext;

    public AttributeMappingRecordRowMapper(Map<String, AttributeColumnToTableBinding> attributeMappings, Map<String, TypeTable> tablesByIdColumnAlias, MediatorRegistryImpl mediatorRegistry, Accessor accessor, RecordContext recordContext) {
        this.attributeMappings = attributeMappings;
        this.tablesByIdColumnAlias = tablesByIdColumnAlias;
        this.mediatorRegistry = mediatorRegistry;
        this.accessor = accessor;
        this.recordContext = recordContext;
    }

    public Record mapRow(ResultSet rs, int i) throws SQLException {
        Record r = null;
        if (!this.attributeMappings.isEmpty()) {
            for (Map.Entry<String, TypeTable> entry : this.tablesByIdColumnAlias.entrySet()) {
                String idColumnAlias = entry.getKey();
                TypeTable typeTable = entry.getValue();
                Long id = rs.getLong(idColumnAlias);
                if (rs.wasNull()) continue;
                r = this.recordContext.get(typeTable.getType(), id.longValue());
                for (Map.Entry<String, AttributeColumnToTableBinding> e : this.attributeMappings.entrySet()) {
                    AttributeColumn col;
                    String alias = e.getKey();
                    AttributeColumnToTableBinding attributeColumnToTableBinding = e.getValue();
                    if (attributeColumnToTableBinding.getTable() != typeTable || (col = attributeColumnToTableBinding.getAttributeColumn()) == null) continue;
                    Attribute att = col.getAttribute();
                    AttributeMediator<Attribute> mediator = this.mediatorRegistry.getMediatorForAttribute(att);
                    Object value = mediator.extractFromResultSet(rs, alias, att, this.recordContext);
                    r.setAttributeValue(att.getName(), value);
                }
            }
        }
        if (r == null) {
            throw new IllegalStateException("could not map row to record.");
        }
        if (RecordImpl.class.isInstance(r)) {
            ((RecordImpl)r).setIsDirty(false);
        }
        return r;
    }
}

