/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.bndly.common.crypto.api.Base64Service;
import org.bndly.common.crypto.api.CryptoServiceFactory;
import org.bndly.common.crypto.api.SimpleCryptoService;
import org.bndly.schema.api.CryptoProvider;
import org.bndly.schema.api.MissingCryptoServiceException;
import org.bndly.schema.model.CryptoAttribute;

public class CryptoProviderImpl
implements CryptoProvider {
    private final CryptoServiceFactory cryptoServiceFactory;
    private final Map<String, SimpleCryptoService> simpleCryptoServicesByName;
    private final Base64Service base64Service;

    public CryptoProviderImpl(CryptoServiceFactory cryptoServiceFactory, Map<String, SimpleCryptoService> simpleCryptoServicesByName) {
        if (cryptoServiceFactory == null) {
            throw new IllegalArgumentException("cryptoServiceFactory is not allowed to be null");
        }
        this.cryptoServiceFactory = cryptoServiceFactory;
        if (simpleCryptoServicesByName == null) {
            throw new IllegalArgumentException("simpleCryptoServicesByName is not allowed to be null");
        }
        this.simpleCryptoServicesByName = simpleCryptoServicesByName;
        this.base64Service = cryptoServiceFactory.createBase64Service();
    }

    public SimpleCryptoService getSimpleCryptoService(String name) throws MissingCryptoServiceException {
        SimpleCryptoService service = this.simpleCryptoServicesByName.get(name);
        if (service == null) {
            throw new MissingCryptoServiceException("could not find crypto service " + name);
        }
        return service;
    }

    public InputStream createDecryptingStream(InputStream stream, CryptoAttribute attribute) throws MissingCryptoServiceException {
        SimpleCryptoService service = this.getSimpleCryptoService(attribute.getCryptoReference());
        InputStream decoded = service.decodeStream(stream);
        return decoded;
    }

    public InputStream createEncryptingStream(InputStream inputStream, CryptoAttribute attribute) throws MissingCryptoServiceException {
        SimpleCryptoService service = this.getSimpleCryptoService(attribute.getCryptoReference());
        InputStream encoded = service.encodeStream(inputStream);
        return encoded;
    }

    public String base64Encode(InputStream stream) {
        return this.base64Service.base64Encode(stream);
    }

    public InputStream createBase64DecodingStream(String base64String) {
        byte[] bytes = this.base64Service.base64Decode(base64String);
        return new ByteArrayInputStream(bytes);
    }
}

