/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.Objects;
import org.bndly.schema.api.Record;
import org.bndly.schema.model.Type;

public class IdTypeBinding {
    private final String typeName;
    private final long id;

    public IdTypeBinding(Record r) {
        if (r == null) {
            throw new IllegalArgumentException("can't create " + this.getClass().getSimpleName() + " without a Record parameter");
        }
        if (r.getId() == null) {
            throw new IllegalArgumentException("can't create " + this.getClass().getSimpleName() + " when the record id is null");
        }
        this.typeName = r.getType().getName();
        this.id = r.getId();
    }

    public IdTypeBinding(Type type, long id) {
        this(type.getName(), id);
    }

    public IdTypeBinding(String typeName, long id) {
        this.typeName = typeName;
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + Objects.hashCode(this.typeName);
        hash = 43 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdTypeBinding other = (IdTypeBinding)obj;
        if (!Objects.equals(this.typeName, other.typeName)) {
            return false;
        }
        return this.id == other.id;
    }
}

