/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.bndly.schema.api.AliasBinding;
import org.bndly.schema.api.LoadedAttributes;
import org.bndly.schema.api.MappingBinding;
import org.bndly.schema.api.MappingBindingsProvider;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.JoinTable;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.query.Join;
import org.bndly.schema.api.query.Select;
import org.bndly.schema.api.query.TableExpression;
import org.bndly.schema.api.services.TableRegistry;
import org.bndly.schema.impl.TableHierarchyIterator;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.Type;

public class LoadingIterator
implements MappingBindingsProvider {
    private final LoadedAttributes loadedAttributes;
    private final TableRegistry tableRegistry;
    private final Set<String> requiredAttributes;
    private final Select select;
    private int joinCounter;
    private int attributeCounter;
    private final Stack<TableExpression> joinStack = new Stack();
    private final Stack<AliasedTable> tableStack = new Stack();
    private final Stack<AttributeColumn> columnStack = new Stack();
    private final Stack<AttributeColumn> domainColumnStack = new Stack();
    private final Stack<MappingBinding> mappingBindingStack = new Stack();
    private final Stack<LoadedAttributes.Strategy> loadingStrategyStack = new Stack();
    private final List<MappingBinding> mappingBindingList = new ArrayList<MappingBinding>();
    private MappingBinding rootMappingBinding;

    public LoadingIterator(TableRegistry tableRegistry, Select select, LoadedAttributes loadedAttributes, Set<String> requiredAttributes) {
        this.select = select;
        this.tableRegistry = tableRegistry;
        this.loadedAttributes = loadedAttributes;
        this.requiredAttributes = requiredAttributes;
    }

    public List<MappingBinding> getMappingBindings() {
        return this.mappingBindingList;
    }

    public MappingBinding getRootMappingBinding() {
        return this.rootMappingBinding;
    }

    @Deprecated
    public List<MappingBinding> getMappingBindingList() {
        return this.mappingBindingList;
    }

    @Deprecated
    public final void iterate(Table table) {
        NamedAttributeHolder holder = this.getNamedAttributeHolderOfTable(table);
        this.iterate(holder.getName());
    }

    private NamedAttributeHolder getNamedAttributeHolderOfTable(Table table) {
        Type holder;
        if (TypeTable.class.isInstance(table)) {
            holder = ((TypeTable)TypeTable.class.cast(table)).getType();
        } else if (JoinTable.class.isInstance(table)) {
            holder = ((JoinTable)JoinTable.class.cast(table)).getNamedAttributeHolder();
        } else {
            throw new IllegalStateException("unsupported table: " + table.getClass().getSimpleName());
        }
        return holder;
    }

    public final void iterate(String attributeHolderName) {
        this.iterate(attributeHolderName, false);
    }

    public final void iterate(String attributeHolderName, final boolean skipColumnSelection) {
        TableHierarchyIterator.iterateTypeHierarchyDownAndFollowAttributes(attributeHolderName, this.tableRegistry, new TableHierarchyIterator.NoOpIterationCallback(){
            private AliasedTable rootAliasedTable;

            @Override
            public void onStart(Table table) {
                AliasedTable at = new AliasedTable(table, this.pullTableAlias(), "");
                this.initRootMapping(at);
                this.rootAliasedTable = at;
                LoadingIterator.this.tableStack.push(this.rootAliasedTable);
            }

            @Override
            public void onEnd(Table table) {
                LoadingIterator.this.tableStack.pop();
            }

            @Override
            public void onTypeTable(TypeTable typeTable, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
                this.onTable((Table)typeTable, true, TableHierarchyIterator.buildAttributePath(domainAttributeStack));
            }

            @Override
            public void afterTypeTable(TypeTable typeTable, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
                this.afterTable((Table)typeTable, true);
            }

            @Override
            public void onJoinTable(JoinTable joinTable, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
                this.onTable((Table)joinTable, false, TableHierarchyIterator.buildAttributePath(domainAttributeStack));
            }

            @Override
            public void afterJoinTable(JoinTable joinTable, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
                this.afterTable((Table)joinTable, false);
            }

            @Override
            public void onColumn(AttributeColumn column, Table table, boolean isPrimaryKeyColumn, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
                LoadingIterator.this.columnStack.push(column);
                boolean isTypeTable = TypeTable.class.isInstance(table);
                if (!isPrimaryKeyColumn && isTypeTable) {
                    LoadingIterator.this.domainColumnStack.push(column);
                    LoadedAttributes.Strategy peekLoadingStrategy = LoadingIterator.this.getCurrentLoadingStrategy();
                    LoadedAttributes.Strategy loadingStrategy = peekLoadingStrategy == LoadedAttributes.Strategy.LAZY_LOADED || peekLoadingStrategy == LoadedAttributes.Strategy.NOT_LOADED ? LoadedAttributes.Strategy.NOT_LOADED : LoadingIterator.this.loadedAttributes.isLoaded(column.getAttribute(), TableHierarchyIterator.buildAttributePath(isPrimaryKeyColumn ? attributeStack : domainAttributeStack));
                    LoadingIterator.this.loadingStrategyStack.push(loadingStrategy);
                    if (loadingStrategy == LoadedAttributes.Strategy.LAZY_LOADED || loadingStrategy == LoadedAttributes.Strategy.LOADED) {
                        this.createAliasBindingInCurrentMapping(column);
                    }
                }
            }

            @Override
            public void afterColumn(AttributeColumn column, Table table, boolean isPrimaryKeyColumn, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
                boolean isTypeTable = TypeTable.class.isInstance(table);
                if (!isPrimaryKeyColumn && isTypeTable) {
                    LoadingIterator.this.loadingStrategyStack.pop();
                    LoadingIterator.this.domainColumnStack.pop();
                }
                LoadingIterator.this.columnStack.pop();
            }

            @Override
            public TableHierarchyIterator.IterationCommand onCyclicColumn(AttributeColumn column, Table table, boolean isPrimaryKeyColumn, Attribute[] attributeStack, Attribute[] domainAttributeStack) {
                String attributePath = TableHierarchyIterator.buildAttributePath(domainAttributeStack);
                if (!attributePath.isEmpty()) {
                    String attributePathPrefix = attributePath + ".";
                    String idAttributePath = attributePathPrefix + "id";
                    for (String requiredAttribute : LoadingIterator.this.requiredAttributes) {
                        if (!requiredAttribute.startsWith(attributePathPrefix) || requiredAttribute.equals(idAttributePath)) continue;
                        return TableHierarchyIterator.IterationCommand.CONTINUE;
                    }
                }
                return super.onCyclicColumn(column, table, isPrimaryKeyColumn, attributeStack, domainAttributeStack);
            }

            private void onTable(Table table, boolean isTypeTable, String attributePath) {
                AliasedTable at;
                if (this.rootAliasedTable == LoadingIterator.this.tableStack.peek() && ((AliasedTable)LoadingIterator.this.tableStack.peek()).getTable() == table && attributePath.isEmpty()) {
                    at = this.rootAliasedTable;
                } else {
                    String alias = this.pullTableAlias();
                    at = new AliasedTable(table, alias, attributePath);
                }
                AttributeColumn col = !LoadingIterator.this.columnStack.isEmpty() ? (AttributeColumn)LoadingIterator.this.columnStack.peek() : null;
                LoadedAttributes.Strategy strategy = LoadingIterator.this.getCurrentLoadingStrategy();
                if (col != null && (strategy == LoadedAttributes.Strategy.LOADED || strategy == null)) {
                    this.insertTableJoin(at, col);
                }
                LoadingIterator.this.tableStack.push(at);
                AttributeColumn column = table.getPrimaryKeyColumn();
                if (isTypeTable) {
                    boolean didAppend;
                    AliasBinding pkAlias;
                    if (this.isTopLevelDomainAttributeColumn() && column == LoadingIterator.this.rootMappingBinding.getPrimaryKeyAlias().getAttributeColumn()) {
                        pkAlias = LoadingIterator.this.rootMappingBinding.getPrimaryKeyAlias();
                        didAppend = false;
                    } else {
                        pkAlias = this.createAliasBinding(column);
                        didAppend = true;
                    }
                    MappingBinding binding = at == this.rootAliasedTable ? LoadingIterator.this.rootMappingBinding : new MappingBinding((NamedAttributeHolder)((TypeTable)table).getType(), pkAlias, this.currentTableAlias());
                    if (this.isTopLevelDomainAttributeColumn()) {
                        LoadingIterator.this.mappingBindingList.add(binding);
                    } else if (strategy == LoadedAttributes.Strategy.LOADED) {
                        ((MappingBinding)LoadingIterator.this.mappingBindingStack.peek()).addSubBinding(binding, ((AttributeColumn)LoadingIterator.this.domainColumnStack.peek()).getAttribute());
                    }
                    LoadingIterator.this.mappingBindingStack.push(binding);
                    if (!didAppend) {
                        this.appendCurrentAttributeColumnToSelect(pkAlias, false);
                    }
                }
            }

            private void afterTable(Table table, boolean isTypeTable) {
                LoadedAttributes.Strategy strategy;
                AttributeColumn col;
                AttributeColumn attributeColumn = col = !LoadingIterator.this.columnStack.isEmpty() ? (AttributeColumn)LoadingIterator.this.columnStack.peek() : null;
                if (col != null && ((strategy = LoadingIterator.this.getCurrentLoadingStrategy()) == LoadedAttributes.Strategy.LOADED || strategy == null)) {
                    LoadingIterator.this.joinStack.pop();
                }
                if (isTypeTable) {
                    LoadingIterator.this.mappingBindingStack.pop();
                }
                LoadingIterator.this.tableStack.pop();
            }

            private void initRootMapping(AliasedTable at) {
                if (LoadingIterator.this.rootMappingBinding == null) {
                    String pkAliasName = this.pullColumnAlias();
                    AttributeColumn pkAttributeColumn = at.getTable().getPrimaryKeyColumn();
                    AliasBinding pkAlias = new AliasBinding(pkAliasName, pkAttributeColumn, at.getAlias());
                    NamedAttributeHolder holder = LoadingIterator.this.getNamedAttributeHolderOfTable(at.getTable());
                    LoadingIterator.this.rootMappingBinding = new MappingBinding(holder, pkAlias, at.getAlias());
                    TableExpression t = LoadingIterator.this.select.from().table(at.getTable().getTableName(), at.getAlias());
                    LoadingIterator.this.joinStack.push(t);
                }
            }

            private boolean isTopLevelDomainAttributeColumn() {
                return LoadingIterator.this.domainColumnStack.isEmpty();
            }

            private void insertTableJoin(AliasedTable aliasedTable, AttributeColumn column) {
                TableExpression peek = (TableExpression)LoadingIterator.this.joinStack.peek();
                Join j = peek.join(aliasedTable.getTable().getTableName(), aliasedTable.getAlias()).left();
                String leftField = peek.alias() + "." + column.getColumnName();
                String rightField = aliasedTable.getAlias() + "." + aliasedTable.getTable().getPrimaryKeyColumn().getColumnName();
                j.on().criteria().field(leftField).equal().field(rightField);
                LoadingIterator.this.joinStack.push(j);
            }

            private String pullTableAlias() {
                LoadingIterator.this.joinCounter++;
                String alias = "j" + LoadingIterator.this.joinCounter;
                return alias;
            }

            private String currentTableAlias() {
                return ((AliasedTable)LoadingIterator.this.tableStack.peek()).getAlias();
            }

            private String pullColumnAlias() {
                LoadingIterator.this.attributeCounter++;
                return "c" + LoadingIterator.this.attributeCounter;
            }

            private AliasBinding createAliasBindingInCurrentMapping(AttributeColumn attributeColumn) {
                return this.appendCurrentAttributeColumnToSelect(attributeColumn, true);
            }

            private AliasBinding createAliasBinding(AttributeColumn attributeColumn) {
                return this.appendCurrentAttributeColumnToSelect(attributeColumn, false);
            }

            private AliasBinding appendCurrentAttributeColumnToSelect(AttributeColumn attributeColumn, boolean appendToCurrentMappingBinding) {
                String colAlias = this.pullColumnAlias();
                return this.appendCurrentAttributeColumnToSelect(attributeColumn, colAlias, appendToCurrentMappingBinding);
            }

            private AliasBinding appendCurrentAttributeColumnToSelect(AttributeColumn attributeColumn, String colAlias, boolean appendToCurrentMappingBinding) {
                String tableAlias = ((TableExpression)LoadingIterator.this.joinStack.peek()).alias();
                AliasBinding aliasBinding = new AliasBinding(colAlias, attributeColumn, tableAlias);
                return this.appendCurrentAttributeColumnToSelect(aliasBinding, appendToCurrentMappingBinding);
            }

            private AliasBinding appendCurrentAttributeColumnToSelect(AliasBinding aliasBinding, boolean appendToCurrentMappingBinding) {
                String alias = ((TableExpression)LoadingIterator.this.joinStack.peek()).alias();
                if (!skipColumnSelection) {
                    LoadingIterator.this.select.expression().table(alias).field(aliasBinding.getAttributeColumn().getColumnName()).as(aliasBinding.getAlias());
                }
                if (appendToCurrentMappingBinding) {
                    MappingBinding binding = (MappingBinding)LoadingIterator.this.mappingBindingStack.peek();
                    binding.addAlias(aliasBinding);
                }
                return aliasBinding;
            }
        });
    }

    private LoadedAttributes.Strategy getCurrentLoadingStrategy() {
        return this.loadingStrategyStack.isEmpty() ? null : this.loadingStrategyStack.peek();
    }

    private static class AliasedTable {
        private final Table table;
        private final String alias;
        private final String attributePath;

        public AliasedTable(Table table, String alias, String attributePath) {
            this.table = table;
            this.alias = alias;
            this.attributePath = attributePath;
        }

        public String getAlias() {
            return this.alias;
        }

        public Table getTable() {
            return this.table;
        }

        public String getAttributePath() {
            return this.attributePath;
        }
    }
}

