/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.ArrayList;
import java.util.List;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.impl.RecordContextImpl;
import org.bndly.schema.model.Attribute;

public final class RecordContextEntry {
    private final Record record;
    private final RecordContextImpl recordContext;
    private final List<RecordContext.RecordReference> references = new ArrayList<RecordContext.RecordReference>();

    public RecordContextEntry(Record record, RecordContextImpl recordContext) {
        if (record == null) {
            throw new IllegalArgumentException("record context entry can not be created for null record");
        }
        if (recordContext == null) {
            throw new IllegalArgumentException("record context entry can not be created for null recordContext");
        }
        this.record = record;
        this.recordContext = recordContext;
    }

    public final RecordContextImpl getRecordContext() {
        return this.recordContext;
    }

    public final Record getRecord() {
        return this.record;
    }

    public final List<RecordContext.RecordReference> getReferences() {
        return this.references;
    }

    public final long referenceCount() {
        return this.references.size();
    }

    public static class RecordReferenceImpl
    implements RecordContext.RecordReference {
        private final Record referencedBy;
        private final Attribute referencedAs;

        public RecordReferenceImpl(Record referencedBy, Attribute referencedAs) {
            this.referencedBy = referencedBy;
            this.referencedAs = referencedAs;
        }

        public Attribute getReferencedAs() {
            return this.referencedAs;
        }

        public Record getReferencedBy() {
            return this.referencedBy;
        }
    }
}

