/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordAttributeIterator;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.RecordList;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.RecordContextEntry;
import org.bndly.schema.impl.RecordContextKey;
import org.bndly.schema.impl.RecordImpl;
import org.bndly.schema.impl.VirtualRecordImpl;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.Type;

public class RecordContextImpl
implements RecordContext {
    private final Engine engine;
    private final Map<RecordContextKey, RecordContextEntry> entries = new HashMap<RecordContextKey, RecordContextEntry>();
    private final Map<String, List<RecordContextEntry>> unpersistedEntriesByType = new HashMap<String, List<RecordContextEntry>>();
    private final Map<String, Type> typesByName = new HashMap<String, Type>();

    public RecordContextImpl(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine is not allowed to be null");
        }
        this.engine = engine;
    }

    public Record get(Type type, long id) {
        return this.get(type.getName(), id);
    }

    public Record get(String typeName, long id) {
        RecordContextKey key = new RecordContextKey(typeName, id);
        RecordContextEntry entry = this.entries.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getRecord();
    }

    public Record attach(Record record) {
        RecordContextEntry attached = this.attachForeign(record);
        Record attachedRecord = attached.getRecord();
        return attachedRecord;
    }

    private RecordContextEntry attachForeign(Record record) {
        if (record.getContext() == this) {
            return ((RecordImpl)record).getRecordContextEntry();
        }
        RecordContextEntry entry = this.assertRecordOfEntryMatched(this._attach(record, false));
        this._attachAndCopyValuesOfRecord(record, entry.getRecord());
        return entry;
    }

    public void persisted(Record record) {
        if (record.getContext() != this) {
            throw new IllegalStateException("persisted events should only be triggered for records that live in the handling record context");
        }
        List<RecordContextEntry> l = this.unpersistedEntriesByType.get(record.getType().getName());
        if (l == null) {
            throw new IllegalStateException("persisted events should only be triggered for records that live in the handling record context. there was no list of unpersisted entries of the provided type.");
        }
        RecordContextEntry entry = null;
        Iterator<RecordContextEntry> iterator = l.iterator();
        while (iterator.hasNext()) {
            RecordContextEntry next = iterator.next();
            if (next.getRecord() != record) continue;
            iterator.remove();
            entry = next;
            break;
        }
        if (entry == null) {
            throw new IllegalStateException("record entry is not allowed to be null, when record has been persisted");
        }
        Long id = record.getId();
        if (id == null) {
            throw new IllegalStateException("id is not allowed to be null, once a record has been persisted");
        }
        RecordContextEntry conflictingEntry = this.getEntryOf(record);
        if (conflictingEntry != null) {
            throw new IllegalStateException("there was already an entry in the record context with the id of the persisted record");
        }
        this.entries.put(new RecordContextKey(record), entry);
    }

    private void _attachAndCopyValuesOfRecord(Record sourceRecord, final Record targetRecord) {
        if (sourceRecord == targetRecord) {
            return;
        }
        sourceRecord.iteratePresentValues(new RecordAttributeIterator(){

            public void handleAttribute(Attribute attribute, Record sourceRecord) {
                if (InverseAttribute.class.isInstance(attribute)) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                if (NamedAttributeHolderAttribute.class.isInstance(attribute)) {
                    Object referredRecord = sourceRecord.getAttributeValue(attribute.getName());
                    if (Record.class.isInstance(referredRecord)) {
                        RecordContextEntry copy = RecordContextImpl.this.attachForeign((Record)referredRecord);
                        targetRecord.setAttributeValue(attribute.getName(), (Object)copy.getRecord());
                    }
                } else {
                    Object val = sourceRecord.getAttributeValue(attribute.getName());
                    targetRecord.setAttributeValue(attribute.getName(), val);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RecordContextEntry _attach(Record record, boolean isDirty) {
        RecordContextEntry entry;
        boolean shouldExistInThisContext = !isDirty && record.getContext() == this;
        boolean shouldBeReAttachedToThisContext = !isDirty && record.getContext() != this;
        boolean shouldBeAttachedToThisContext = isDirty;
        Long id = record.getId();
        if (shouldExistInThisContext) {
            if (RecordImpl.class.isInstance(record)) {
                return ((RecordImpl)record).getRecordContextEntry();
            }
            entry = this.getEntryOf(record);
            if (entry == null) {
                throw new IllegalStateException("record seemed to be attached to current record context, but no context entry could be found.");
            }
            if (entry.getRecord() == record) return entry;
            throw new IllegalStateException("record was attached to current record context, but the entry in the record context did lead to another instance.");
        }
        if (shouldBeReAttachedToThisContext) {
            if (id == null) throw new IllegalStateException("can not attach unpersisted record, because there is no identifier to match it with existing unpersisted entries.");
            RecordContextKey key = new RecordContextKey(record);
            entry = this.entries.get(key);
            if (entry != null) return entry;
            RecordImpl r = new RecordImpl(this.engine.getAccessor());
            r.setType(record.getType());
            r.setId(id);
            entry = new RecordContextEntry(r, this);
            r.setRecordContextEntry(entry);
            this.entries.put(key, entry);
            return entry;
        } else {
            if (!shouldBeAttachedToThisContext) throw new IllegalStateException("unknown state for record to attach");
            if (id != null) {
                RecordContextKey key = new RecordContextKey(record);
                entry = this.entries.get(key);
                if (entry != null) throw new IllegalStateException("there was already a record with the provided key in the context.");
                entry = new RecordContextEntry(record, this);
                this.entries.put(key, entry);
                ((RecordImpl)record).setRecordContextEntry(entry);
                return entry;
            } else {
                RecordContextEntry entry2;
                List<RecordContextEntry> l = this.unpersistedEntriesByType.get(record.getType().getName());
                if (l == null) {
                    entry2 = new RecordContextEntry(record, this);
                    ((RecordImpl)record).setRecordContextEntry(entry2);
                    l = new ArrayList<RecordContextEntry>();
                    l.add(entry2);
                    this.unpersistedEntriesByType.put(record.getType().getName(), l);
                    return entry2;
                } else {
                    entry2 = null;
                    for (RecordContextEntry next : l) {
                        if (next.getRecord() != record) continue;
                        entry2 = next;
                        break;
                    }
                    if (entry2 != null) return entry2;
                    entry2 = new RecordContextEntry(record, this);
                    l.add(entry2);
                    ((RecordImpl)record).setRecordContextEntry(entry2);
                }
                return entry2;
            }
        }
    }

    public void detach(Record record) {
        RecordContextKey key = new RecordContextKey(record);
        if (this.entries.containsKey(key)) {
            RecordContextEntry entry = this.entries.get(key);
            if (entry != null) {
                // empty if block
            }
            this.entries.remove(key);
        }
    }

    public RecordImpl create(Type type) {
        return this.create(type.getName());
    }

    public RecordImpl create(String typeName) {
        RecordImpl r = this._lazyRecord(typeName, null);
        return r;
    }

    public Record create(Type type, long id) {
        return this.create(type.getName(), id);
    }

    public Record create(String typeName, long id) {
        RecordContextEntry entry = this.entries.get(new RecordContextKey(typeName, id));
        if (entry == null) {
            RecordImpl r = this._lazyRecord(typeName, id);
            return r;
        }
        return entry.getRecord();
    }

    private Type getTypeByName(String typeName) {
        Type type;
        TypeTable table = this.engine.getTableRegistry().getTypeTableByType(typeName);
        if (table == null) {
            if (this.typesByName.containsKey(typeName)) {
                type = this.typesByName.get(typeName);
            } else {
                Schema s = this.engine.getDeployer().getDeployedSchema();
                List types = s.getTypes();
                for (Type type1 : types) {
                    this.typesByName.put(type1.getName(), type1);
                }
                type = this.typesByName.get(typeName);
                this.typesByName.put(typeName, type);
            }
            if (type == null) {
                throw new IllegalArgumentException("can't create new Record for type " + typeName);
            }
        } else {
            type = table.getType();
        }
        return type;
    }

    private RecordImpl _lazyRecord(String typeName, Long id) {
        Accessor accessor = this.engine.getAccessor();
        Type type = this.getTypeByName(typeName);
        if (type.isAbstract()) {
            if (id != null) {
                Record rec = accessor.readById(typeName, id.longValue(), accessor.buildRecordContext());
                if (rec == null) {
                    throw new SchemaException("a record should have been created for an abstract type name " + typeName + ", but no real record could be found.");
                }
                type = rec.getType();
                id = rec.getId();
            } else {
                throw new SchemaException("a record should have been created for an abstract type name " + typeName + ", but no id was provided to perform a lookup for the real record.");
            }
        }
        RecordImpl r = type.isVirtual() ? new VirtualRecordImpl(accessor) : new RecordImpl(accessor);
        r.setType(type);
        r.setId(id);
        this.assertRecordOfEntryMatched(this._attach(r, true));
        return r;
    }

    private RecordContextEntry assertRecordOfEntryMatched(RecordContextEntry entry) {
        Record rec = entry.getRecord();
        if (!RecordImpl.class.isInstance(rec)) {
            throw new SchemaException("can not assert record of entry is currently correctly attached to the record context");
        }
        RecordContextEntry e = ((RecordImpl)rec).getRecordContextEntry();
        if (e != entry) {
            throw new SchemaException("record of entry has not the entry that was inspected.");
        }
        return entry;
    }

    public String dumpStats() {
        Object value;
        Object key;
        StringBuffer sb = new StringBuffer();
        long unpersistedEntriesSize = this.unpersistedEntriesSize();
        long size = this.size();
        sb.append("total entries: ").append(size).append("\n");
        long persistedEntriesSize = this.persistedEntriesSize();
        sb.append("persisted entries: ").append(persistedEntriesSize).append("\n");
        if (size > 0L) {
            for (Map.Entry<RecordContextKey, RecordContextEntry> entry : this.entries.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                sb.append("\treferences to ").append(((RecordContextEntry)value).getRecord().toString()).append(": ").append(((RecordContextEntry)value).referenceCount()).append("\n");
                List<RecordContext.RecordReference> refs = ((RecordContextEntry)value).getReferences();
                for (RecordContext.RecordReference ref : refs) {
                    sb.append("\t\treferenced as ").append(ref.getReferencedAs().getName()).append(" by ").append(ref.getReferencedBy().toString()).append("\n");
                }
            }
        }
        sb.append("unpersisted entries: ").append(unpersistedEntriesSize).append("\n");
        if (unpersistedEntriesSize > 0L) {
            for (Map.Entry<Object, Object> entry : this.unpersistedEntriesByType.entrySet()) {
                key = (String)entry.getKey();
                value = (List)entry.getValue();
                if (value == null || value.isEmpty()) continue;
                sb.append("\tunpersisted entries of ").append((String)key).append(": ").append(value.size()).append("\n");
                Iterator iterator = value.iterator();
                while (iterator.hasNext()) {
                    RecordContextEntry value1 = (RecordContextEntry)iterator.next();
                    sb.append("\tunpersisted entry ").append(value1.getRecord().toString()).append("\n");
                }
            }
        }
        return sb.toString();
    }

    private RecordContextEntry getEntryOf(Record record) {
        RecordContextEntry entry;
        Long id = record.getId();
        Type type = record.getType();
        String typeName = type.getName();
        if (id == null) {
            List<RecordContextEntry> unpersistedEntriesOfType = this.unpersistedEntriesByType.get(typeName);
            if (unpersistedEntriesOfType == null) {
                entry = null;
            } else {
                for (RecordContextEntry unpersistedEntry : unpersistedEntriesOfType) {
                    if (unpersistedEntry.getRecord() != record) continue;
                    return unpersistedEntry;
                }
                entry = null;
            }
        } else {
            entry = this.entries.get(new RecordContextKey(record));
        }
        return entry;
    }

    public boolean isAttached(Record record) {
        RecordContextEntry entry = this.getEntryOf(record);
        return entry != null;
    }

    public Iterator<RecordContext.RecordReference> listReferencesToRecord(Record record) {
        RecordContextEntry entry = this.getEntryOf(record);
        if (entry == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        List<RecordContext.RecordReference> refs = entry.getReferences();
        return refs.iterator();
    }

    public long unpersistedEntriesSize() {
        long unpersistedEntriesTotal = 0L;
        for (Map.Entry<String, List<RecordContextEntry>> entrySet : this.unpersistedEntriesByType.entrySet()) {
            List<RecordContextEntry> value = entrySet.getValue();
            if (value == null) continue;
            unpersistedEntriesTotal += (long)value.size();
        }
        return unpersistedEntriesTotal;
    }

    public long persistedEntriesSize() {
        return this.entries.size();
    }

    public long size() {
        return this.persistedEntriesSize() + this.unpersistedEntriesSize();
    }

    public Iterator<Record> listPersistedRecordsOfType(String typeName) {
        Type type = this.getTypeByName(typeName);
        return this.listPersistedRecordsOfType(type);
    }

    public Iterator<Record> listPersistedRecordsOfType(Type type) {
        ArrayList<Record> result = null;
        for (RecordContextEntry next : this.entries.values()) {
            if (next.getRecord().getType() != type) continue;
            if (result == null) {
                result = new ArrayList<Record>();
            }
            result.add(next.getRecord());
        }
        return result == null ? Collections.EMPTY_LIST.iterator() : result.iterator();
    }

    public Iterator<Record> listPersistedRecords() {
        Schema ds = this.engine.getDeployer().getDeployedSchema();
        List types = ds.getTypes();
        if (types == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        final Iterator typeIterator = types.iterator();
        return new Iterator<Record>(){
            private Iterator<Record> typeSpecificIterator;

            @Override
            public boolean hasNext() {
                if (this.typeSpecificIterator != null && !this.typeSpecificIterator.hasNext()) {
                    this.typeSpecificIterator = null;
                }
                if (this.typeSpecificIterator == null) {
                    while (typeIterator.hasNext()) {
                        Type next = (Type)typeIterator.next();
                        this.typeSpecificIterator = RecordContextImpl.this.listPersistedRecordsOfType(next);
                        if (!this.typeSpecificIterator.hasNext()) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Record next() {
                return this.typeSpecificIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public RecordList createList(Record owner, String inverseAttributeName) {
        return this.createList(owner, (InverseAttribute)owner.getAttributeDefinition(inverseAttributeName, InverseAttribute.class));
    }

    public RecordList createList(Record owner, InverseAttribute inverseAttribute) {
        return this.createList(null, owner, inverseAttribute);
    }

    public RecordList createList(RecordContext.RecordListInitializer initializer, Record owner, String inverseAttributeName) {
        return this.createList(initializer, owner, (InverseAttribute)owner.getAttributeDefinition(inverseAttributeName, InverseAttribute.class));
    }

    public RecordList createList(final RecordContext.RecordListInitializer initializer, Record owner, InverseAttribute inverseAttribute) {
        RecordList list = new RecordList(owner, inverseAttribute, (RecordList.Listener)new RecordList.NoOpListener(){

            public void onItemRemoved(Record record) {
                RecordContextEntry entry = RecordContextImpl.this.getEntryOf(record);
            }

            public Record beforeItemAdded(Record record) {
                RecordContextEntry entry = RecordContextImpl.this.getEntryOf(record);
                if (entry == null) {
                    Record attachedRecord = RecordContextImpl.this.attach(record);
                    return attachedRecord;
                }
                return entry.getRecord();
            }
        }){

            protected List<Record> initializeOriginal() {
                List l = super.initializeOriginal();
                if (initializer != null) {
                    Iterator iter = initializer.initialize();
                    while (iter.hasNext()) {
                        Record next = (Record)iter.next();
                        l.add(next);
                    }
                }
                return l;
            }
        };
        return list;
    }
}

