/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.bndly.schema.api.mapper.RowMapper;

public class SimpleTypeRowMapper
implements RowMapper<Object> {
    private final Class<?> simpleType;

    public SimpleTypeRowMapper(Class<?> simpleType) {
        this.simpleType = simpleType;
    }

    public Object mapRow(ResultSet rs, int i) throws SQLException {
        int index = 1;
        if (Long.TYPE.equals(this.simpleType) || Long.class.equals(this.simpleType)) {
            return rs.getLong(index);
        }
        if (Integer.TYPE.equals(this.simpleType) || Integer.class.equals(this.simpleType)) {
            return rs.getInt(index);
        }
        if (Short.TYPE.equals(this.simpleType) || Short.class.equals(this.simpleType)) {
            return rs.getShort(index);
        }
        if (Byte.TYPE.equals(this.simpleType) || Byte.class.equals(this.simpleType)) {
            return rs.getByte(index);
        }
        if (Double.TYPE.equals(this.simpleType) || Double.class.equals(this.simpleType)) {
            return rs.getDouble(index);
        }
        if (Float.TYPE.equals(this.simpleType) || Float.class.equals(this.simpleType)) {
            return Float.valueOf(rs.getFloat(index));
        }
        if (Date.class.equals(this.simpleType)) {
            return rs.getDate(index);
        }
        if (String.class.equals(this.simpleType)) {
            return rs.getString(index);
        }
        throw new IllegalStateException("unsupported simple type: " + this.simpleType);
    }
}

