/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bndly.schema.api.db.JoinTable;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.db.UniqueConstraintTable;
import org.bndly.schema.api.services.TableRegistry;
import org.bndly.schema.impl.MediatorRegistryImpl;
import org.bndly.schema.impl.Resetable;
import org.bndly.schema.impl.db.AttributeColumnImpl;
import org.bndly.schema.impl.db.JoinTableImpl;
import org.bndly.schema.impl.db.TypeTableImpl;
import org.bndly.schema.impl.db.UniqueConstraintTableImpl;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.DecimalAttribute;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.Type;
import org.bndly.schema.model.UniqueConstraint;
import org.bndly.schema.vendor.VendorConfiguration;

public class TableRegistryImpl
implements TableRegistry,
Resetable {
    private final Map<String, TypeTable> typeTables = new HashMap<String, TypeTable>();
    private final Map<String, JoinTable> joinTables = new HashMap<String, JoinTable>();
    private final Map<String, UniqueConstraintTable> uniqueConstraintTables = new HashMap<String, UniqueConstraintTable>();
    private final Map<String, Table> tablesByName = new HashMap<String, Table>();
    private MediatorRegistryImpl mediatorRegistry;
    private VendorConfiguration vendorConfiguration;

    public TypeTableImpl createTypeTable(Type type, String tableName) {
        TypeTableImpl tt = new TypeTableImpl(type, tableName);
        tt.setPrimaryKeyColumn(this.createPrimaryKeyColumn(tt));
        this.typeTables.put(type.getName(), tt);
        this.tablesByName.put(tableName, tt);
        return tt;
    }

    public JoinTableImpl createJoinTable(NamedAttributeHolder namedAttributeHolder, String tableName) {
        JoinTableImpl jt = new JoinTableImpl(tableName, namedAttributeHolder);
        jt.setPrimaryKeyColumn(this.createPrimaryKeyColumn(jt));
        this.joinTables.put(namedAttributeHolder.getName(), jt);
        this.tablesByName.put(tableName, jt);
        return jt;
    }

    public UniqueConstraintTableImpl createUniqueConstraintTable(UniqueConstraint uniqueConstraint, String tableName) {
        UniqueConstraintTableImpl uqt = new UniqueConstraintTableImpl(uniqueConstraint, tableName);
        this.uniqueConstraintTables.put(tableName, uqt);
        this.tablesByName.put(tableName, uqt);
        return uqt;
    }

    public JoinTable getJoinTableByNamedAttributeHolder(NamedAttributeHolder namedAttributeHolder) {
        return this.getJoinTableByNamedAttributeHolder(namedAttributeHolder.getName());
    }

    public JoinTable getJoinTableByNamedAttributeHolder(String namedAttributeHolderName) {
        return this.joinTables.get(namedAttributeHolderName);
    }

    public TypeTable getTypeTableByType(Type type) {
        return this.getTypeTableByType(type.getName());
    }

    public TypeTable getTypeTableByType(String typeName) {
        return this.typeTables.get(typeName);
    }

    public UniqueConstraintTable getUniqueConstraintTableByConstraint(UniqueConstraint uniqueConstraint) {
        for (Map.Entry<String, UniqueConstraintTable> entry : this.uniqueConstraintTables.entrySet()) {
            UniqueConstraintTable uniqueConstraintTable = entry.getValue();
            if (uniqueConstraintTable.getUniqueConstraint() != uniqueConstraint) continue;
            return uniqueConstraintTable;
        }
        throw new IllegalStateException("could not find unique constraint table");
    }

    public Collection<JoinTable> getAllJoinTables() {
        return this.joinTables.values();
    }

    public Collection<TypeTable> getAllTypeTables() {
        return this.typeTables.values();
    }

    public Collection<UniqueConstraintTable> getAllUniqueConstraintTables() {
        return this.uniqueConstraintTables.values();
    }

    public Table getTableByName(String tableName) {
        return this.tablesByName.get(tableName);
    }

    private AttributeColumnImpl createPrimaryKeyColumn(Table table) {
        DecimalAttribute att = new DecimalAttribute();
        att.setName("id");
        att.setDecimalPlaces(Integer.valueOf(0));
        att.setIndexed(true);
        String colTypeName = this.mediatorRegistry.getMediatorForAttribute(att).columnType((Attribute)att);
        boolean requiresIndex = att.isIndexed();
        if (att.isIndexed() && this.vendorConfiguration.getIndexExistenceAdapter().isPrimaryKeyIndexedAutomatically()) {
            requiresIndex = false;
        }
        AttributeColumnImpl attCol = new AttributeColumnImpl((Attribute)att, this.vendorConfiguration.getIdentifierAdapter().transformColumnName("ID"), colTypeName, table, requiresIndex, true);
        return attCol;
    }

    @Override
    public void reset() {
        this.typeTables.clear();
        this.joinTables.clear();
        this.uniqueConstraintTables.clear();
        this.tablesByName.clear();
    }

    public void setMediatorRegistry(MediatorRegistryImpl mediatorRegistry) {
        this.mediatorRegistry = mediatorRegistry;
    }

    public void setVendorConfiguration(VendorConfiguration vendorConfiguration) {
        this.vendorConfiguration = vendorConfiguration;
    }
}

