/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bndly.schema.api.PreparedStatementArgumentSetter;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.api.tx.Key;
import org.bndly.schema.api.tx.KeyHolder;
import org.bndly.schema.api.tx.PreparedStatementCallback;
import org.bndly.schema.api.tx.PreparedStatementCreator;
import org.bndly.schema.api.tx.Template;
import org.bndly.schema.impl.ConnectionCallback;
import org.bndly.schema.impl.ObjectHolder;
import org.bndly.schema.impl.SimpleTypeRowMapper;
import org.bndly.schema.vendor.VendorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateImpl
implements Template {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateImpl.class);
    private final VendorConfiguration vendorConfiguration;
    private final Engine engine;
    private final Connection connection;

    public TemplateImpl(VendorConfiguration vendorConfiguration, Engine engine, Connection connection) {
        this.vendorConfiguration = vendorConfiguration;
        this.engine = engine;
        this.connection = connection;
    }

    private <E> E runOnConnection(ConnectionCallback<E> connectionCallback) {
        return connectionCallback.doWithConnection(this.connection);
    }

    public <E> List<E> query(String sql, Object[] arguments, RowMapper<E> mapper) {
        return this.query(sql, this.wrapObjectArrayAsArgumentSetters(arguments), mapper);
    }

    public <E> List<E> query(final String sql, final PreparedStatementArgumentSetter[] arguments, final RowMapper<E> mapper) {
        return (List)this.runOnConnection(new ConnectionCallback<List<E>>(){

            @Override
            public List<E> doWithConnection(Connection connection) {
                PreparedStatement ps = TemplateImpl.this.prepareStatementOnConnection(connection, sql);
                TemplateImpl.this.setParametersInPreparedStatement(ps, arguments);
                boolean hasResultSet = TemplateImpl.this.executePreparedStatement(ps, sql);
                if (hasResultSet) {
                    ResultSet rs = TemplateImpl.this.retrieveResultSet(ps, sql);
                    final ArrayList l = new ArrayList();
                    TemplateImpl.this.iterate(rs, ps, new ResultSetIterator(){

                        @Override
                        public void onRow(ResultSet rs, int rowIndex) throws SQLException {
                            Object row = mapper.mapRow(rs, rowIndex);
                            l.add(row);
                        }
                    }, sql);
                    TemplateImpl.this.releaseResources(new AutoCloseable[]{rs, ps});
                    return l;
                }
                TemplateImpl.this.releaseResources(new AutoCloseable[]{ps});
                return null;
            }
        });
    }

    private PreparedStatement prepareStatementOnConnection(Connection connection, String sql) {
        try {
            PreparedStatement ps = connection.prepareStatement(sql);
            return ps;
        }
        catch (SQLException e) {
            throw this.vendorConfiguration.getErrorCodeMapper().map(e, this.engine);
        }
    }

    public <E> List<E> query(String sql, RowMapper<E> mapper) {
        return this.query(sql, (PreparedStatementArgumentSetter[])null, mapper);
    }

    private void setParametersInPreparedStatement(PreparedStatement ps, PreparedStatementArgumentSetter[] arguments) {
        if (arguments != null) {
            for (int i = 1; i <= arguments.length; ++i) {
                PreparedStatementArgumentSetter argumentSetter = arguments[i - 1];
                try {
                    argumentSetter.set(i, ps);
                    continue;
                }
                catch (SQLException e) {
                    this.silentlyClose(ps);
                    throw this.vendorConfiguration.getErrorCodeMapper().map("could not set parameters in prepared statement", e, this.engine);
                }
            }
        }
    }

    private boolean executePreparedStatement(PreparedStatement ps, String sql) {
        boolean hasResultSet;
        if (sql != null) {
            LOG.debug(sql);
        }
        try {
            hasResultSet = ps.execute();
        }
        catch (SQLException ex) {
            this.silentlyClose(ps);
            throw this.vendorConfiguration.getErrorCodeMapper().map("failed to execute statement: " + sql, ex, this.engine);
        }
        return hasResultSet;
    }

    private ResultSet retrieveResultSet(PreparedStatement ps, String sql) {
        ResultSet rs;
        try {
            rs = ps.getResultSet();
        }
        catch (SQLException ex) {
            this.silentlyClose(ps);
            throw this.vendorConfiguration.getErrorCodeMapper().map("failed to execute statement: " + sql, ex, this.engine);
        }
        return rs;
    }

    private PreparedStatementArgumentSetter[] wrapObjectArrayAsArgumentSetters(Object[] arguments) {
        if (arguments == null) {
            return null;
        }
        PreparedStatementArgumentSetter[] res = new PreparedStatementArgumentSetter[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            final Object argument = arguments[i];
            res[i] = new PreparedStatementArgumentSetter(){

                public void set(int index, PreparedStatement ps) throws SQLException {
                    ps.setObject(index, argument);
                }
            };
        }
        return res;
    }

    public <E> E queryForObject(String sql, Object[] arguments, RowMapper<E> mapper) {
        return this.queryForObject(sql, this.wrapObjectArrayAsArgumentSetters(arguments), mapper);
    }

    public <E> E queryForObject(final String sql, final PreparedStatementArgumentSetter[] arguments, final RowMapper<E> mapper) {
        return this.runOnConnection(new ConnectionCallback<E>(){

            @Override
            public <E> E doWithConnection(Connection connection) {
                PreparedStatement ps;
                try {
                    ps = connection.prepareStatement(sql);
                }
                catch (SQLException e) {
                    throw TemplateImpl.this.vendorConfiguration.getErrorCodeMapper().map("could not create prepared statement", e, TemplateImpl.this.engine);
                }
                TemplateImpl.this.setParametersInPreparedStatement(ps, arguments);
                boolean hasResultSet = TemplateImpl.this.executePreparedStatement(ps, sql);
                if (hasResultSet) {
                    ResultSet rs = TemplateImpl.this.retrieveResultSet(ps, sql);
                    final ObjectHolder holder = new ObjectHolder();
                    TemplateImpl.this.iterate(rs, ps, new ResultSetIterator(){

                        @Override
                        public void onRow(ResultSet rs, int rowIndex) throws SQLException {
                            if (rowIndex == 0) {
                                holder.setObject(mapper.mapRow(rs, rowIndex));
                            }
                        }
                    }, sql);
                    TemplateImpl.this.releaseResources(new AutoCloseable[]{ps, rs});
                    return holder.getObject();
                }
                TemplateImpl.this.releaseResources(new AutoCloseable[]{ps});
                return null;
            }
        });
    }

    public <E> E queryForObject(String sql, Object[] arguments, Class<E> type) {
        return (E)this.queryForObject(sql, arguments, new SimpleTypeRowMapper(type));
    }

    public <E> E queryForObject(String sql, PreparedStatementArgumentSetter[] arguments, Class<E> type) {
        return (E)this.queryForObject(sql, arguments, (RowMapper<E>)new SimpleTypeRowMapper(type));
    }

    public void execute(String sql) {
        this.execute(sql, null);
    }

    private void invokeCallbackOnPreparedStatement(PreparedStatement ps, PreparedStatementCallback callback, String sql) {
        if (callback != null) {
            try {
                callback.setValues(ps);
            }
            catch (Exception ex) {
                this.silentlyClose(ps);
                throw new SchemaException("failed to invoke callback on prepared statement: " + sql, (Throwable)ex);
            }
        }
    }

    public void execute(final String sql, final PreparedStatementCallback callback) {
        this.runOnConnection(new ConnectionCallback<Object>(){

            @Override
            public Object doWithConnection(Connection connection) {
                PreparedStatement ps = TemplateImpl.this.prepareStatementOnConnection(connection, sql);
                TemplateImpl.this.invokeCallbackOnPreparedStatement(ps, callback, sql);
                boolean hasResultSet = TemplateImpl.this.executePreparedStatement(ps, sql);
                if (hasResultSet) {
                    // empty if block
                }
                TemplateImpl.this.releaseResources(new AutoCloseable[]{ps});
                return null;
            }
        });
    }

    private PreparedStatement invokeCallbackOnConnection(PreparedStatementCreator statementCreator, Connection connection) {
        PreparedStatement preparedStatement;
        try {
            preparedStatement = statementCreator.createPreparedStatement(connection);
        }
        catch (SQLException e) {
            throw this.vendorConfiguration.getErrorCodeMapper().map("could not created prepared statement", e, this.engine);
        }
        return preparedStatement;
    }

    private ResultSet retrieveGeneratedKeys(PreparedStatement ps) {
        try {
            ResultSet generatedKeys = ps.getGeneratedKeys();
            return generatedKeys;
        }
        catch (SQLException ex) {
            this.silentlyClose(ps);
            throw this.vendorConfiguration.getErrorCodeMapper().map("failed to retrieve generated keys from statement", ex, this.engine);
        }
    }

    private void pushGeneratedKeyToKeyHolder(PreparedStatement ps, final KeyHolder keyHolder) {
        if (keyHolder != null) {
            ResultSet rs = this.retrieveGeneratedKeys(ps);
            this.iterate(rs, ps, new ResultSetIterator(){
                boolean didSetKey = false;

                @Override
                public void onRow(ResultSet rs, int rowIndex) throws SQLException {
                    if (!this.didSetKey) {
                        this.didSetKey = true;
                        final long id = rs.getLong(1);
                        keyHolder.setKey(new Key(){

                            public long longValue() {
                                return id;
                            }
                        });
                    }
                }
            });
            this.releaseResources(rs);
        }
    }

    public void update(final PreparedStatementCreator statementCreator, final KeyHolder keyHolder) {
        this.runOnConnection(new ConnectionCallback(){

            public Object doWithConnection(Connection connection) {
                PreparedStatement ps = TemplateImpl.this.invokeCallbackOnConnection(statementCreator, connection);
                boolean hasResultSet = TemplateImpl.this.executePreparedStatement(ps, null);
                if (!hasResultSet) {
                    TemplateImpl.this.pushGeneratedKeyToKeyHolder(ps, keyHolder);
                }
                TemplateImpl.this.releaseResources(new AutoCloseable[]{ps});
                return null;
            }
        });
    }

    public void update(PreparedStatementCreator statementCreator) {
        this.update(statementCreator, null);
    }

    private void releaseResources(AutoCloseable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (AutoCloseable autoCloseable : closeables) {
            this.silentlyClose(autoCloseable);
        }
    }

    private void silentlyClose(AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void iterate(ResultSet rs, PreparedStatement ps, ResultSetIterator iter) {
        this.iterate(rs, ps, iter, null);
    }

    private void iterate(ResultSet rs, PreparedStatement ps, ResultSetIterator iter, String sql) {
        boolean hasRows;
        if (rs == null) {
            return;
        }
        int rowIndex = 0;
        do {
            try {
                hasRows = rs.next();
            }
            catch (SQLException ex) {
                this.silentlyClose(rs);
                this.silentlyClose(ps);
                throw this.vendorConfiguration.getErrorCodeMapper().map("failed to iterate result set of statement in row " + rowIndex + " : " + sql, ex, this.engine);
            }
            if (!hasRows) continue;
            try {
                iter.onRow(rs, rowIndex);
            }
            catch (Exception ex) {
                this.silentlyClose(rs);
                this.silentlyClose(ps);
                throw new SchemaException("failed to handle row " + rowIndex + " of result set for statement: " + sql, (Throwable)ex);
            }
            ++rowIndex;
        } while (hasRows);
    }

    private static interface ResultSetIterator {
        public void onRow(ResultSet var1, int var2) throws SQLException;
    }
}

