/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bndly.schema.api.CommitHandler;
import org.bndly.schema.api.ExceptionHandlingTransactionalQuery;
import org.bndly.schema.api.Logic;
import org.bndly.schema.api.ObjectReference;
import org.bndly.schema.api.PreparedStatementArgumentSetter;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RollbackHandler;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.TransactionalQuery;
import org.bndly.schema.api.TransactionalQueryRunner;
import org.bndly.schema.api.exception.ConstraintViolationException;
import org.bndly.schema.api.exception.IntegrityException;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.services.TransactionFactory;
import org.bndly.schema.api.tx.KeyHolder;
import org.bndly.schema.api.tx.PreparedStatementCallback;
import org.bndly.schema.api.tx.PreparedStatementCreator;
import org.bndly.schema.api.tx.Template;
import org.bndly.schema.api.tx.TransactionCallback;
import org.bndly.schema.api.tx.TransactionStatus;
import org.bndly.schema.api.tx.TransactionTemplate;
import org.bndly.schema.impl.AbstractTemplateBasedTransactionalQueryImpl;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.GeneratedKeyHolder;
import org.bndly.schema.impl.ObjectHolder;
import org.bndly.schema.impl.TemplateBasedTransactionalQuery;
import org.bndly.schema.impl.events.PersistenceEventBuilder;
import org.bndly.schema.impl.events.PersistenceEventTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionFactoryImpl
implements TransactionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionFactoryImpl.class);
    private EngineImpl engineImpl;
    private TransactionTemplate transactionTemplate;

    private PreparedStatementCreator buildPreparedStatementCreatorFromQuery(final Query q, final String ... columnsToReturn) {
        return new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(q.getSql(), columnsToReturn);
                for (int i = 0; i < q.getArgumentSetters().length; ++i) {
                    PreparedStatementArgumentSetter preparedStatementArgumentSetter = q.getArgumentSetters()[i];
                    preparedStatementArgumentSetter.set(i + 1, ps);
                }
                return ps;
            }
        };
    }

    public void runInTransaction(Query ... queries) {
        PersistenceEventTransaction tx = this.createTransaction();
        TransactionalQueryRunner runner = tx.getQueryRunner();
        for (Query query : queries) {
            runner.run(query);
        }
        tx.commit();
    }

    public PersistenceEventTransaction createTransaction() {
        LOG.debug("created transaction");
        return new PersistenceEventTransaction(){
            private final PersistenceEventBuilder persistenceEventBuilder;
            private List<Logic> logicElements;
            private List<CommitHandler> afterCommit;
            private List<RollbackHandler> afterRollback;
            private Boolean didRollBack;
            private final TransactionalQueryRunner queryRunner;
            private boolean isCommiting;
            {
                this.persistenceEventBuilder = new PersistenceEventBuilder(TransactionFactoryImpl.this.engineImpl);
                this.logicElements = new ArrayList<Logic>();
                this.afterCommit = new ArrayList<CommitHandler>();
                this.afterRollback = new ArrayList<RollbackHandler>();
                this.queryRunner = new TransactionalQueryRunner(){

                    public ObjectReference<Record> single(final Query q) {
                        final ObjectReference result = new ObjectReference();
                        final RowMapper mapper = (RowMapper)q.getMapper();
                        if (mapper == null) {
                            throw new IllegalStateException("mapper for single record query was not build.");
                        }
                        this.add((Logic)new AbstractTemplateBasedTransactionalQueryImpl("single"){

                            public void execute(Transaction transaction) {
                                result.set((Object)((Record)this.template.queryForObject(q.getSql(), q.getArgumentSetters(), mapper)));
                            }
                        });
                        return result;
                    }

                    public ObjectReference<List<Record>> list(final Query q) {
                        final ObjectReference result = new ObjectReference();
                        final RowMapper mapper = (RowMapper)q.getMapper();
                        if (mapper == null) {
                            throw new IllegalStateException("mapper for single record query was not build.");
                        }
                        this.add((Logic)new AbstractTemplateBasedTransactionalQueryImpl("list"){

                            public void execute(Transaction transaction) {
                                result.set((Object)this.template.query(q.getSql(), q.getArgumentSetters(), mapper));
                            }
                        });
                        return result;
                    }

                    public ObjectReference<Long> number(final Query q, final String primaryKeyFieldName) {
                        if (!q.asUpdate() || primaryKeyFieldName == null) {
                            throw new SchemaException("provided query has to be an update and the primaryKeyFieldName has to be non-null");
                        }
                        final ObjectReference result = new ObjectReference();
                        this.add((Logic)new AbstractTemplateBasedTransactionalQueryImpl("number: " + q.getSql()){

                            public void execute(Transaction transaction) {
                                GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
                                this.template.update(TransactionFactoryImpl.this.buildPreparedStatementCreatorFromQuery(q, new String[]{primaryKeyFieldName}), (KeyHolder)keyHolder);
                                result.set((Object)keyHolder.getKey().longValue());
                            }
                        });
                        return result;
                    }

                    public ObjectReference<Long> number(final Query q) {
                        if (q.asUpdate()) {
                            throw new SchemaException("provided query has to be a non-update (INSERT or UPDATE)");
                        }
                        final ObjectReference result = new ObjectReference();
                        this.add((Logic)new AbstractTemplateBasedTransactionalQueryImpl("number: " + q.getSql()){

                            public void execute(Transaction transaction) {
                                result.set((Object)((Long)this.template.queryForObject(q.getSql(), q.getArgumentSetters(), Long.class)));
                            }
                        });
                        return result;
                    }

                    public void run(final Query q) {
                        this.add((Logic)new AbstractTemplateBasedTransactionalQueryImpl("run"){

                            public void execute(Transaction transaction) {
                                this.template.update(TransactionFactoryImpl.this.buildPreparedStatementCreatorFromQuery(q, new String[0]));
                            }
                        });
                    }

                    public void uploadBlob(final Query q) {
                        this.add((Logic)new AbstractTemplateBasedTransactionalQueryImpl("upload blob"){

                            public void execute(Transaction transaction) {
                                this.template.execute(q.getSql(), new PreparedStatementCallback(){

                                    public void setValues(PreparedStatement ps) throws SQLException {
                                        for (int i = 0; i < q.getArgumentSetters().length; ++i) {
                                            PreparedStatementArgumentSetter preparedStatementArgumentSetter = q.getArgumentSetters()[i];
                                            int index = i + 1;
                                            preparedStatementArgumentSetter.set(index, ps);
                                        }
                                    }
                                });
                            }
                        });
                    }
                };
            }

            @Override
            public PersistenceEventBuilder getPersistenceEventBuilder() {
                return this.persistenceEventBuilder;
            }

            public TransactionalQueryRunner getQueryRunner() {
                return this.queryRunner;
            }

            public void add(Logic logic) {
                if (logic != null) {
                    if (this.isCommiting) {
                        throw new SchemaException("can not add further logic while transaction is already commiting");
                    }
                    this.logicElements.add(logic);
                }
            }

            public void commit() {
                LOG.debug("commiting transaction");
                if (this.persistenceEventBuilder.hasEventsScheduled()) {
                    this.persistenceEventBuilder.attachToTransaction(this);
                }
                this.isCommiting = true;
                if (this.logicElements.isEmpty()) {
                    return;
                }
                final ObjectHolder exceptionHolder = new ObjectHolder();
                final 2 _this = this;
                TransactionFactoryImpl.this.transactionTemplate.doInTransaction((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus status, Template template) {
                        ExceptionHandlingTransactionalQuery ehq = null;
                        TransactionalQuery currentQuery = null;
                        Logic currentLogic = null;
                        try {
                            Iterator iterator = logicElements.iterator();
                            while (iterator.hasNext()) {
                                Logic logic;
                                currentLogic = logic = (Logic)iterator.next();
                                if (TemplateBasedTransactionalQuery.class.isInstance(logic)) {
                                    ((TemplateBasedTransactionalQuery)logic).setTemplate(template);
                                }
                                if (TransactionalQuery.class.isInstance(logic)) {
                                    currentQuery = (TransactionalQuery)logic;
                                }
                                ehq = ExceptionHandlingTransactionalQuery.class.isInstance(logic) ? (ExceptionHandlingTransactionalQuery)logic : null;
                                logic.execute(_this);
                            }
                            currentQuery = null;
                        }
                        catch (RuntimeException e) {
                            Exception re;
                            if (!ConstraintViolationException.class.isInstance(e) && !IntegrityException.class.isInstance(e)) {
                                LOG.error("rolling back transaction: " + e.getMessage(), (Throwable)e);
                            }
                            status.setRollbackOnly();
                            didRollBack = true;
                            if (ehq != null && RuntimeException.class.isInstance(re = ehq.handleException((Exception)e))) {
                                e = (RuntimeException)re;
                            }
                            exceptionHolder.setObject(e);
                            return null;
                        }
                        didRollBack = status.isRollbackOnly();
                        return null;
                    }
                });
                if (this.didRollBack.booleanValue()) {
                    LOG.debug("did rollback transaction");
                    for (RollbackHandler rollbackHandler : this.afterRollback) {
                        rollbackHandler.didRollback((Transaction)_this);
                    }
                    if (exceptionHolder.getObject() != null) {
                        throw (RuntimeException)exceptionHolder.getObject();
                    }
                } else {
                    LOG.debug("did commit transaction");
                    for (CommitHandler commitHandler : this.afterCommit) {
                        commitHandler.didCommit((Transaction)_this);
                    }
                }
            }

            public boolean didRollBack() {
                if (this.didRollBack == null) {
                    throw new IllegalStateException("transaction has not been tried to be commited.");
                }
                return this.didRollBack;
            }

            public void afterCommit(CommitHandler commitHandler) {
                this.afterCommit.add(commitHandler);
            }

            public void afterRollback(RollbackHandler rollbackHandler) {
                this.afterRollback.add(rollbackHandler);
            }
        };
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setEngineImpl(EngineImpl engineImpl) {
        this.engineImpl = engineImpl;
    }
}

