/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bndly.schema.api.VirtualAttributeAdapter;
import org.bndly.schema.api.services.VirtualAttributeAdapterRegistry;
import org.bndly.schema.impl.Resetable;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.NamedAttributeHolder;
import org.bndly.schema.model.Type;

public class VirtualAttributeAdapterRegistryImpl
implements VirtualAttributeAdapterRegistry,
Resetable {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<VirtualAttributeAdapter> adapters = new ArrayList<VirtualAttributeAdapter>();
    private final Map<AdapterCacheKey, VirtualAttributeAdapter> cachedAdapters = new HashMap<AdapterCacheKey, VirtualAttributeAdapter>();

    public void register(VirtualAttributeAdapter adapter) {
        if (adapter != null) {
            this.lock.writeLock().lock();
            try {
                this.adapters.add(adapter);
                this.invalidateAdapterCache();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void unregister(VirtualAttributeAdapter adapter) {
        if (adapter != null) {
            this.lock.writeLock().lock();
            try {
                this.adapters.remove(adapter);
                this.invalidateAdapterCache();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void invalidateAdapterCache() {
        this.cachedAdapters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Attribute> VirtualAttributeAdapter<E> getAdapterForAttributeAndType(E att, Type type) {
        AdapterCacheKey key = new AdapterCacheKey(type.getName(), att.getName());
        this.lock.readLock().lock();
        try {
            if (this.cachedAdapters.containsKey(key)) {
                VirtualAttributeAdapter virtualAttributeAdapter = this.cachedAdapters.get(key);
                return virtualAttributeAdapter;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.cachedAdapters.containsKey(key)) {
                VirtualAttributeAdapter virtualAttributeAdapter = this.cachedAdapters.get(key);
                return virtualAttributeAdapter;
            }
            for (VirtualAttributeAdapter virtualAttributeAdapter : this.adapters) {
                try {
                    if (!virtualAttributeAdapter.supports(att, (NamedAttributeHolder)type)) continue;
                    this.cachedAdapters.put(key, virtualAttributeAdapter);
                    VirtualAttributeAdapter virtualAttributeAdapter2 = virtualAttributeAdapter;
                    return virtualAttributeAdapter2;
                }
                catch (ClassCastException classCastException) {}
            }
            this.cachedAdapters.put(key, null);
            Iterator<VirtualAttributeAdapter> iterator = null;
            return iterator;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void reset() {
        this.lock.writeLock().lock();
        try {
            this.adapters.clear();
            this.cachedAdapters.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static final class AdapterCacheKey {
        private final String typeName;
        private final String attributeName;

        public AdapterCacheKey(String typeName, String attributeName) {
            this.typeName = typeName;
            this.attributeName = attributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode(this.typeName);
            hash = 79 * hash + Objects.hashCode(this.attributeName);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AdapterCacheKey other = (AdapterCacheKey)obj;
            if (!Objects.equals(this.typeName, other.typeName)) {
                return false;
            }
            return Objects.equals(this.attributeName, other.attributeName);
        }
    }
}

