/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.factory;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.bndly.common.datasource.DataSourcePool;
import org.bndly.common.osgi.util.ServiceRegistrationBuilder;
import org.bndly.schema.api.CryptoProvider;
import org.bndly.schema.api.SchemaBeanProvider;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.listener.SchemaDeploymentListener;
import org.bndly.schema.api.mapper.LobHandler;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.api.services.EngineFactory;
import org.bndly.schema.beans.SchemaBeanFactory;
import org.bndly.schema.impl.AccessorImpl;
import org.bndly.schema.impl.ConstraintRegistryImpl;
import org.bndly.schema.impl.DefaultLobHandler;
import org.bndly.schema.impl.DeployerImpl;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.MediatorRegistryImpl;
import org.bndly.schema.impl.QueryContextFactoryImpl;
import org.bndly.schema.impl.SingleConnectionTransactionTemplateImpl;
import org.bndly.schema.impl.TableRegistryImpl;
import org.bndly.schema.impl.TransactionFactoryImpl;
import org.bndly.schema.impl.TransactionTemplateImpl;
import org.bndly.schema.impl.VirtualAttributeAdapterRegistryImpl;
import org.bndly.schema.impl.factory.EngineConfiguration;
import org.bndly.schema.impl.factory.EngineServicesListener;
import org.bndly.schema.impl.factory.ListenerTracker;
import org.bndly.schema.impl.factory.SchemaBeanServicesListener;
import org.bndly.schema.impl.nquery.expression.DelegatingExpressionStatementHandler;
import org.bndly.schema.impl.nquery.expression.EqualExpressionStatementHandler;
import org.bndly.schema.impl.nquery.expression.GreaterEqualExpressionStatementHandler;
import org.bndly.schema.impl.nquery.expression.GreaterExpressionStatementHandler;
import org.bndly.schema.impl.nquery.expression.InRangeExpressionStatementHandler;
import org.bndly.schema.impl.nquery.expression.LowerEqualExpressionStatementHandler;
import org.bndly.schema.impl.nquery.expression.LowerExpressionStatementHandler;
import org.bndly.schema.impl.nquery.expression.TypedExpressionStatementHandler;
import org.bndly.schema.impl.vendor.VendorConfigurations;
import org.bndly.schema.json.RecordJsonConverter;
import org.bndly.schema.json.beans.JSONSchemaBeanFactory;
import org.bndly.schema.model.BinaryAttribute;
import org.bndly.schema.model.BooleanAttribute;
import org.bndly.schema.model.CryptoAttribute;
import org.bndly.schema.model.DateAttribute;
import org.bndly.schema.model.DecimalAttribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.JSONAttribute;
import org.bndly.schema.model.Mixin;
import org.bndly.schema.model.MixinAttribute;
import org.bndly.schema.model.Schema;
import org.bndly.schema.model.SchemaProvider;
import org.bndly.schema.model.StringAttribute;
import org.bndly.schema.model.Type;
import org.bndly.schema.model.TypeAttribute;
import org.bndly.schema.vendor.AttributeMediatorFactory;
import org.bndly.schema.vendor.VendorConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EngineFactory.class}, immediate=true)
public class EngineFactoryImpl
implements EngineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EngineFactoryImpl.class);
    @Reference
    private DataSourcePool dataSourcePool;
    private final List<SchemaDeploymentListener> deploymentListeners = new ArrayList<SchemaDeploymentListener>();
    private final ReadWriteLock deploymentListenersLock = new ReentrantReadWriteLock();
    private final List<EngineServicesListener> engineServiceListeners = new ArrayList<EngineServicesListener>();
    private final ReadWriteLock engineServicesLock = new ReentrantReadWriteLock();
    @Reference
    private RecordJsonConverter recordJsonConverter;
    private final DelegatingExpressionStatementHandler expressionStatementHandler = new DelegatingExpressionStatementHandler();
    private ComponentContext componentContext;
    private final List<Runnable> lazyInits = new ArrayList<Runnable>();
    private final List<ServiceRegistration<VendorConfiguration>> vendorConfigurationRegistrations = new ArrayList<ServiceRegistration<VendorConfiguration>>();

    @Reference(bind="addEngineConfiguration", unbind="removeEngineConfiguration", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, service=EngineConfiguration.class)
    public void addEngineConfiguration(EngineConfiguration engineConfiguration) {
        this.addEngineConfigurationInternal(engineConfiguration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEngineConfigurationInternal(final EngineConfiguration engineConfiguration, boolean allowLazyInit) {
        if (engineConfiguration != null) {
            if (this.componentContext == null) {
                if (allowLazyInit) {
                    LOG.info("deferring engine service listeners setup until activation of engine factory");
                    this.lazyInits.add(new Runnable(){

                        @Override
                        public void run() {
                            EngineFactoryImpl.this.addEngineConfigurationInternal(engineConfiguration, false);
                        }
                    });
                } else {
                    LOG.error("could not set up engine service listener, because component context was null and lazy init is prevented.");
                }
            } else {
                SchemaBeanServicesListener schemaBeanServicesListener = new SchemaBeanServicesListener(this.componentContext.getBundleContext(), engineConfiguration.getSchema()){
                    private SchemaBeanFactory schemaBeanFactory;
                    private ServiceRegistration<SchemaBeanFactory> schemaBeanFactoryReg;

                    @Override
                    protected void onReady(Engine engine, SchemaBeanProvider schemaBeanProvider) {
                        this.schemaBeanFactory = new SchemaBeanFactory(schemaBeanProvider);
                        JSONSchemaBeanFactory jsbf = new JSONSchemaBeanFactory();
                        this.schemaBeanFactory.setJsonSchemaBeanFactory(jsbf);
                        this.schemaBeanFactory.setEngine(engine);
                        this.registerJavaInterfacesToBeanFactories(schemaBeanProvider, this.schemaBeanFactory, jsbf, engine.getDeployer().getDeployedSchema());
                        this.schemaBeanFactoryReg = ServiceRegistrationBuilder.newInstance(SchemaBeanFactory.class, (Object)this.schemaBeanFactory).pid(SchemaBeanFactory.class.getName() + "." + schemaBeanProvider.getSchemaName()).property("schema", (Object)schemaBeanProvider.getSchemaName()).register(this.bundleContext);
                    }

                    @Override
                    protected void onShutdown(Engine engine, SchemaBeanProvider schemaBeanProvider) {
                        this.schemaBeanFactory = null;
                        if (this.schemaBeanFactoryReg != null) {
                            this.schemaBeanFactoryReg.unregister();
                            this.schemaBeanFactoryReg = null;
                        }
                    }

                    private void registerJavaInterfacesToBeanFactories(SchemaBeanProvider schemaBeanProvider, SchemaBeanFactory schemaBeanFactory, JSONSchemaBeanFactory jsonSchemaBeanFactory, Schema schema) {
                        List mixins;
                        String schemaBeanPackage = schemaBeanProvider.getSchemaBeanPackage();
                        List types = schema.getTypes();
                        if (types != null) {
                            for (Type type : types) {
                                String className = schemaBeanPackage + "." + type.getName();
                                try {
                                    Class<?> clazz = schemaBeanProvider.getSchemaBeanClassLoader().loadClass(className);
                                    schemaBeanFactory.registerTypeBinding(type.getName(), clazz);
                                    jsonSchemaBeanFactory.registerTypeBinding(type.getName(), clazz);
                                }
                                catch (ClassNotFoundException ex) {
                                    LOG.warn("could not find class {} to register in schema bean factory");
                                }
                            }
                        }
                        if ((mixins = schema.getMixins()) != null) {
                            for (Mixin mixin : mixins) {
                                String className = schemaBeanPackage + "." + mixin.getName();
                                try {
                                    Class<?> clazz = schemaBeanProvider.getSchemaBeanClassLoader().loadClass(className);
                                    schemaBeanFactory.registerTypeBinding(mixin.getName(), clazz);
                                    jsonSchemaBeanFactory.registerTypeBinding(mixin.getName(), clazz);
                                }
                                catch (ClassNotFoundException ex) {
                                    LOG.warn("could not find class {} to register in schema bean factory");
                                }
                            }
                        }
                    }
                };
                EngineServicesListener engineServicesListener = new EngineServicesListener(this.componentContext.getBundleContext(), engineConfiguration){
                    private Engine engine;
                    private ServiceRegistration<Engine> engineReg;
                    private ListenerTracker listenerTracker;

                    @Override
                    protected void onReady(DataSource dataSource, SchemaProvider schemaProvider) {
                        LOG.info("creating schema engine for schema " + schemaProvider.getSchemaName());
                        this.engine = EngineFactoryImpl.this.createEngine(dataSource, engineConfiguration.getSchema(), engineConfiguration.getVendorConfig(), engineConfiguration.getConnection(), engineConfiguration.isValidateOnly(), engineConfiguration.isValidationErrorIgnored());
                        LOG.info("created schema engine for schema " + schemaProvider.getSchemaName());
                        try {
                            this.listenerTracker = new ListenerTracker(this.bundleContext, this.engine, schemaProvider.getSchemaName());
                            this.listenerTracker.open();
                            this.engine.getDeployer().deploy(schemaProvider.getSchema());
                            LOG.info("deployed schema to engine " + schemaProvider.getSchemaName());
                        }
                        catch (Exception e) {
                            LOG.error("failed to deploy schema to engine " + schemaProvider.getSchemaName(), (Throwable)e);
                            return;
                        }
                        this.engineReg = ServiceRegistrationBuilder.newInstance(Engine.class, (Object)this.engine).pid(Engine.class.getName() + "." + schemaProvider.getSchemaName()).register(this.bundleContext);
                    }

                    @Override
                    protected void onShutdown(DataSource dataSource, SchemaProvider schemaProvider) {
                        LOG.info("shutting down schema engine for schema " + engineConfiguration.getSchema());
                        if (this.listenerTracker != null) {
                            this.listenerTracker.close();
                            this.listenerTracker = null;
                        }
                        this.engine = null;
                        if (this.engineReg != null) {
                            this.engineReg.unregister();
                            this.engineReg = null;
                        }
                    }

                    @Override
                    public synchronized void destroy() {
                        if (this.engineReg != null) {
                            this.engineReg.unregister();
                            this.engineReg = null;
                        }
                        this.engine = null;
                        super.destroy();
                    }

                    @Override
                    protected Engine getEngine() {
                        return this.engine;
                    }
                };
                this.engineServicesLock.writeLock().lock();
                try {
                    schemaBeanServicesListener.init();
                    engineServicesListener.init();
                    this.engineServiceListeners.add(engineServicesListener);
                }
                catch (InvalidSyntaxException e) {
                    LOG.error("could not init engine services listener");
                    engineServicesListener.destroy();
                    schemaBeanServicesListener.destroy();
                }
                finally {
                    this.engineServicesLock.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEngineConfiguration(EngineConfiguration engineConfiguration) {
        if (engineConfiguration != null) {
            this.engineServicesLock.writeLock().lock();
            try {
                Iterator<EngineServicesListener> iterator = this.engineServiceListeners.iterator();
                while (iterator.hasNext()) {
                    EngineServicesListener next = iterator.next();
                    if (next.getEngineConfiguration() != engineConfiguration) continue;
                    next.destroy();
                    iterator.remove();
                }
            }
            finally {
                this.engineServicesLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(bind="registerSchemaDeploymentListener", unbind="unregisterSchemaDeploymentListener", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, service=SchemaDeploymentListener.class)
    public void registerSchemaDeploymentListener(SchemaDeploymentListener listener) {
        if (listener != null) {
            this.deploymentListenersLock.writeLock().lock();
            try {
                this.deploymentListeners.add(0, listener);
                this.engineServicesLock.readLock().lock();
                try {
                    for (EngineServicesListener engineServicesListener : this.engineServiceListeners) {
                        Engine engine = engineServicesListener.getEngine();
                        if (engine == null) continue;
                        listener.schemaDeployed(engine.getDeployer().getDeployedSchema(), engine);
                    }
                }
                finally {
                    this.engineServicesLock.readLock().unlock();
                }
            }
            finally {
                this.deploymentListenersLock.writeLock().unlock();
            }
        }
    }

    public void unregisterSchemaDeploymentListener(SchemaDeploymentListener listener) {
        if (listener != null) {
            this.deploymentListenersLock.writeLock().lock();
            try {
                this.deploymentListeners.remove(listener);
            }
            finally {
                this.deploymentListenersLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.expressionStatementHandler.addExpressionStatementHandler(new EqualExpressionStatementHandler());
        this.expressionStatementHandler.addExpressionStatementHandler(new GreaterEqualExpressionStatementHandler());
        this.expressionStatementHandler.addExpressionStatementHandler(new GreaterExpressionStatementHandler());
        this.expressionStatementHandler.addExpressionStatementHandler(new LowerEqualExpressionStatementHandler());
        this.expressionStatementHandler.addExpressionStatementHandler(new LowerExpressionStatementHandler());
        this.expressionStatementHandler.addExpressionStatementHandler(new InRangeExpressionStatementHandler());
        this.expressionStatementHandler.addExpressionStatementHandler(new TypedExpressionStatementHandler());
        this.registerVendorConfig("h2", VendorConfigurations.H2, componentContext.getBundleContext());
        this.registerVendorConfig("mariadb", VendorConfigurations.MARIADB, componentContext.getBundleContext());
        this.registerVendorConfig("mysql", VendorConfigurations.MYSQL, componentContext.getBundleContext());
        this.registerVendorConfig("mysql8", VendorConfigurations.MYSQL8, componentContext.getBundleContext());
        this.registerVendorConfig("postgres", VendorConfigurations.POSTGRES, componentContext.getBundleContext());
        try {
            for (Runnable lazyInit : this.lazyInits) {
                lazyInit.run();
            }
        }
        catch (Exception ex) {
            LOG.error("failed to activate engine factory: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.lazyInits.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate(ComponentContext componentContext) {
        this.engineServicesLock.writeLock().lock();
        try {
            for (EngineServicesListener engineServicesListener : this.engineServiceListeners) {
                engineServicesListener.destroy();
            }
            this.engineServiceListeners.clear();
        }
        finally {
            this.engineServicesLock.writeLock().unlock();
        }
        this.expressionStatementHandler.clear();
        this.deploymentListenersLock.writeLock().lock();
        try {
            this.deploymentListeners.clear();
        }
        finally {
            this.deploymentListenersLock.writeLock().unlock();
        }
        for (ServiceRegistration serviceRegistration : this.vendorConfigurationRegistrations) {
            serviceRegistration.unregister();
        }
        this.vendorConfigurationRegistrations.clear();
        this.componentContext = null;
    }

    public Engine createEngine(String dataSourceName, String schemaName, VendorConfiguration vendorConfiguration) {
        return this.createEngine(dataSourceName, schemaName, vendorConfiguration, "pooled");
    }

    public Engine createEngine(String dataSourceName, String schemaName, VendorConfiguration vendorConfiguration, String connectionStrategy) {
        return this.createEngine(dataSourceName, schemaName, vendorConfiguration, connectionStrategy, false);
    }

    public Engine createEngine(String dataSourceName, String schemaName, VendorConfiguration vendorConfiguration, String connectionStrategy, boolean validateOnly) {
        DataSource ds = this.dataSourcePool.getDataSource(dataSourceName);
        if (ds == null) {
            throw new IllegalStateException("could not create engine, because no datasource could be found for " + dataSourceName);
        }
        return this.createEngine(ds, schemaName, vendorConfiguration, connectionStrategy, validateOnly, false);
    }

    public Engine createEngine(DataSource dataSource, String schemaName, VendorConfiguration vendorConfiguration, String connectionStrategy, boolean validateOnly, boolean validationErrorIgnored) {
        TransactionTemplateImpl transactionTemplate;
        TransactionTemplateImpl templateImpl;
        if (connectionStrategy == null) {
            connectionStrategy = "single";
        }
        if (vendorConfiguration == null) {
            throw new SchemaException("missing dialect for schema " + schemaName);
        }
        EngineImpl engineImpl = new EngineImpl();
        if ("pooled".equals(connectionStrategy)) {
            templateImpl = new TransactionTemplateImpl(vendorConfiguration, engineImpl);
            templateImpl.setDataSource(dataSource);
            templateImpl.setCloseConnectionAfterUsage(true);
            transactionTemplate = templateImpl;
        } else if ("single".equals(connectionStrategy)) {
            templateImpl = new SingleConnectionTransactionTemplateImpl(vendorConfiguration, engineImpl);
            templateImpl.setDataSource(dataSource);
            transactionTemplate = templateImpl;
        } else {
            LOG.warn("unsupported connection strategy: {}. falling back to single connection.", (Object)connectionStrategy);
            templateImpl = new SingleConnectionTransactionTemplateImpl(vendorConfiguration, engineImpl);
            templateImpl.setDataSource(dataSource);
            transactionTemplate = templateImpl;
        }
        String databaseSchemaName = this.dataSourcePool.getDatabaseSchemaNameForDataSource(dataSource);
        AccessorImpl accessorImpl = new AccessorImpl();
        accessorImpl.setExpressionStatementHandler(this.expressionStatementHandler);
        engineImpl.setAccessor(accessorImpl);
        TransactionFactoryImpl queryRunnerImpl = new TransactionFactoryImpl();
        engineImpl.setQueryRunner(queryRunnerImpl);
        QueryContextFactoryImpl queryContextFactoryImpl = new QueryContextFactoryImpl();
        engineImpl.setQueryContextFactory(queryContextFactoryImpl);
        VirtualAttributeAdapterRegistryImpl virtualAttributeAdapterRegistryImpl = new VirtualAttributeAdapterRegistryImpl();
        engineImpl.setVirtualAttributeAdapterRegistry(virtualAttributeAdapterRegistryImpl);
        ConstraintRegistryImpl constraintRegistryImpl = new ConstraintRegistryImpl();
        engineImpl.setConstraintRegistry(constraintRegistryImpl);
        DeployerImpl deployerImpl = new DeployerImpl(engineImpl);
        if (validateOnly) {
            deployerImpl.setValidateOnly(true);
        }
        if (validationErrorIgnored) {
            deployerImpl.setValidationErrorIgnored(true);
        }
        engineImpl.setDeployer(deployerImpl);
        TableRegistryImpl tableRegistryImpl = new TableRegistryImpl();
        tableRegistryImpl.setVendorConfiguration(vendorConfiguration);
        engineImpl.setTableRegistry(tableRegistryImpl);
        MediatorRegistryImpl mediatorRegistry = new MediatorRegistryImpl();
        engineImpl.setMediatorRegistry(mediatorRegistry);
        engineImpl.setVendorConfiguration(vendorConfiguration);
        DefaultLobHandler lobHandler = new DefaultLobHandler(vendorConfiguration, engineImpl);
        CryptoProvider cryptoProvider = this.createCryptoProvider();
        HashMap mediatorMap = new HashMap();
        AttributeMediatorFactory attributeMediatorFactory = vendorConfiguration.getAttributeMediatorFactory();
        mediatorMap.put(StringAttribute.class, attributeMediatorFactory.createStringAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorMap.put(DecimalAttribute.class, attributeMediatorFactory.createDecimalAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorMap.put(BooleanAttribute.class, attributeMediatorFactory.createBooleanAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorMap.put(DateAttribute.class, attributeMediatorFactory.createDateAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorMap.put(InverseAttribute.class, attributeMediatorFactory.createInverseAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorMap.put(TypeAttribute.class, attributeMediatorFactory.createTypeAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorMap.put(MixinAttribute.class, attributeMediatorFactory.createMixinAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorMap.put(BinaryAttribute.class, attributeMediatorFactory.createBinaryAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorMap.put(JSONAttribute.class, attributeMediatorFactory.createJSONAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorMap.put(CryptoAttribute.class, attributeMediatorFactory.createCryptoAttributeMediator((Accessor)accessorImpl, this.recordJsonConverter, (LobHandler)lobHandler, cryptoProvider));
        mediatorRegistry.setMediators(mediatorMap);
        tableRegistryImpl.setMediatorRegistry(mediatorRegistry);
        deployerImpl.setMediatorRegistry(mediatorRegistry);
        deployerImpl.setConstraintRegistry(constraintRegistryImpl);
        deployerImpl.setListeners(this.deploymentListeners, this.deploymentListenersLock);
        deployerImpl.setTableRegistry(tableRegistryImpl);
        deployerImpl.setDatabaseSchemaName(databaseSchemaName);
        deployerImpl.setTransactionTemplate(transactionTemplate);
        deployerImpl.setVendorConfiguration(vendorConfiguration);
        accessorImpl.setEngine(engineImpl);
        accessorImpl.setMediatorRegistry(mediatorRegistry);
        queryRunnerImpl.setTransactionTemplate(transactionTemplate);
        queryRunnerImpl.setEngineImpl(engineImpl);
        queryContextFactoryImpl.setVendorConfiguration(vendorConfiguration);
        queryContextFactoryImpl.setAccessor(accessorImpl);
        queryContextFactoryImpl.setMediatorRegistry(mediatorRegistry);
        queryContextFactoryImpl.setTableRegistry(tableRegistryImpl);
        return engineImpl;
    }

    private CryptoProvider createCryptoProvider() {
        return new CryptoProvider(){

            public InputStream createDecryptingStream(InputStream stream, CryptoAttribute attribute) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public InputStream createEncryptingStream(InputStream inputStream, CryptoAttribute attribute) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String base64Encode(InputStream stream) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public InputStream createBase64DecodingStream(String base64String) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    private void registerVendorConfig(String dialect, VendorConfiguration config, BundleContext context) {
        this.vendorConfigurationRegistrations.add((ServiceRegistration<VendorConfiguration>)ServiceRegistrationBuilder.newInstance(VendorConfiguration.class, (Object)config).property("name", (Object)dialect).register(context));
    }
}

