/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.factory;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.factory.EngineConfiguration;
import org.bndly.schema.model.SchemaProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EngineServicesListener {
    private static final Logger LOG = LoggerFactory.getLogger(EngineServicesListener.class);
    protected final BundleContext bundleContext;
    private final EngineConfiguration engineConfiguration;
    private final String dataSourceName;
    private final String schemaName;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private ServiceTracker<DataSource, DataSource> dataSourceTracker;
    private ServiceTracker<SchemaProvider, SchemaProvider> schemaProviderTracker;
    private DataSource dataSource;
    private SchemaProvider schemaProvider;
    private boolean ready;
    private boolean shutdown;

    public EngineServicesListener(BundleContext bundleContext, EngineConfiguration engineConfiguration) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext is not allowed to be null");
        }
        this.bundleContext = bundleContext;
        if (engineConfiguration == null) {
            throw new IllegalArgumentException("engineConfiguration is not allowed to be null");
        }
        this.engineConfiguration = engineConfiguration;
        this.dataSourceName = engineConfiguration.getDatasource();
        if (this.dataSourceName == null || this.dataSourceName.isEmpty()) {
            throw new IllegalArgumentException("dataSourceName is not allowed to be null or empty");
        }
        this.schemaName = engineConfiguration.getSchema();
        if (this.schemaName == null || this.schemaName.isEmpty()) {
            throw new IllegalArgumentException("schemaName is not allowed to be null or empty");
        }
    }

    public final EngineConfiguration getEngineConfiguration() {
        return this.engineConfiguration;
    }

    public synchronized void init() throws InvalidSyntaxException {
        String dataSourceFilterString = "(&(objectClass=" + DataSource.class.getName() + ")(" + "service.pid" + "=" + DataSource.class.getName() + "." + this.dataSourceName + "))";
        this.dataSourceTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(dataSourceFilterString), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<DataSource, DataSource>(){

            public DataSource addingService(ServiceReference<DataSource> sr) {
                EngineServicesListener.this.lock.writeLock().lock();
                try {
                    EngineServicesListener.this.dataSource = (DataSource)EngineServicesListener.this.bundleContext.getService(sr);
                    if (EngineServicesListener.this.dataSource != null && EngineServicesListener.this.schemaProvider != null) {
                        EngineServicesListener.this.onReadyInternal(EngineServicesListener.this.dataSource, EngineServicesListener.this.schemaProvider);
                    }
                    DataSource dataSource = EngineServicesListener.this.dataSource;
                    return dataSource;
                }
                finally {
                    EngineServicesListener.this.lock.writeLock().unlock();
                }
            }

            public void modifiedService(ServiceReference<DataSource> sr, DataSource t) {
            }

            public void removedService(ServiceReference<DataSource> sr, DataSource t) {
                EngineServicesListener.this.lock.writeLock().lock();
                try {
                    EngineServicesListener.this.dataSource = null;
                    EngineServicesListener.this.onShutdownInternal(EngineServicesListener.this.dataSource, EngineServicesListener.this.schemaProvider);
                }
                finally {
                    EngineServicesListener.this.lock.writeLock().unlock();
                }
            }
        });
        this.dataSourceTracker.open();
        String schemaProviderFilterString = "(&(objectClass=" + SchemaProvider.class.getName() + ")(" + "service.pid" + "=" + SchemaProvider.class.getName() + "." + this.schemaName + "))";
        this.schemaProviderTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(schemaProviderFilterString), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SchemaProvider, SchemaProvider>(){

            public SchemaProvider addingService(ServiceReference<SchemaProvider> sr) {
                EngineServicesListener.this.lock.writeLock().lock();
                try {
                    EngineServicesListener.this.schemaProvider = (SchemaProvider)EngineServicesListener.this.bundleContext.getService(sr);
                    if (EngineServicesListener.this.dataSource != null && EngineServicesListener.this.schemaProvider != null) {
                        EngineServicesListener.this.onReadyInternal(EngineServicesListener.this.dataSource, EngineServicesListener.this.schemaProvider);
                    }
                    SchemaProvider schemaProvider = EngineServicesListener.this.schemaProvider;
                    return schemaProvider;
                }
                finally {
                    EngineServicesListener.this.lock.writeLock().unlock();
                }
            }

            public void modifiedService(ServiceReference<SchemaProvider> sr, SchemaProvider t) {
            }

            public void removedService(ServiceReference<SchemaProvider> sr, SchemaProvider t) {
                EngineServicesListener.this.lock.writeLock().lock();
                try {
                    EngineServicesListener.this.schemaProvider = null;
                    EngineServicesListener.this.onShutdownInternal(EngineServicesListener.this.dataSource, EngineServicesListener.this.schemaProvider);
                }
                finally {
                    EngineServicesListener.this.lock.writeLock().unlock();
                }
            }
        });
        this.schemaProviderTracker.open();
    }

    public synchronized void destroy() {
        this.lock.writeLock().lock();
        try {
            if (this.dataSourceTracker != null) {
                this.dataSourceTracker.close();
                this.dataSourceTracker = null;
            }
            this.dataSource = null;
            if (this.schemaProviderTracker != null) {
                this.schemaProviderTracker.close();
                this.schemaProviderTracker = null;
            }
            this.schemaProvider = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void onReadyInternal(DataSource dataSource, SchemaProvider schemaProvider) {
        if (!this.ready) {
            this.ready = true;
            this.shutdown = false;
            LOG.info("engine for schema {} should become ready now", (Object)this.schemaName);
            this.onReady(dataSource, schemaProvider);
        }
    }

    private void onShutdownInternal(DataSource dataSource, SchemaProvider schemaProvider) {
        if (!this.shutdown && this.ready) {
            this.shutdown = true;
            this.ready = false;
            LOG.info("engine for schema {} should shut down now", (Object)this.schemaName);
            this.onShutdown(dataSource, schemaProvider);
        }
    }

    protected abstract void onReady(DataSource var1, SchemaProvider var2);

    protected abstract void onShutdown(DataSource var1, SchemaProvider var2);

    protected abstract Engine getEngine();
}

