/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.json;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Stack;
import org.bndly.common.json.model.JSArray;
import org.bndly.common.json.model.JSBoolean;
import org.bndly.common.json.model.JSMember;
import org.bndly.common.json.model.JSNumber;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSString;
import org.bndly.common.json.model.JSValue;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordAttributeIterator;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.RecordList;
import org.bndly.schema.json.RecordJsonConverter;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.BooleanAttribute;
import org.bndly.schema.model.DateAttribute;
import org.bndly.schema.model.DecimalAttribute;
import org.bndly.schema.model.InverseAttribute;
import org.bndly.schema.model.JSONAttribute;
import org.bndly.schema.model.NamedAttributeHolderAttribute;
import org.bndly.schema.model.SimpleAttribute;
import org.bndly.schema.model.StringAttribute;
import org.bndly.schema.vendor.mediator.DecimalAttributeMediator;
import org.osgi.service.component.annotations.Component;

@Component(service={RecordJsonConverter.class}, immediate=true)
public class RecordJsonConverterImpl
implements RecordJsonConverter {
    public Record convertJsonToRecord(JSObject sourceJson, final RecordContext recordContext) {
        Record toMap;
        String typeName = sourceJson.getMemberStringValue("_type");
        if (typeName == null) {
            return null;
        }
        BigDecimal id = sourceJson.getMemberNumberValue("_id");
        if (id != null) {
            Boolean isRef = sourceJson.getMemberBooleanValue("_isReference");
            Record found = recordContext.get(typeName, id.longValue());
            if (found != null) {
                return found;
            }
            toMap = recordContext.create(typeName, id.longValue());
            if (isRef != null && isRef.booleanValue()) {
                toMap.setIsReference(true);
            }
        } else {
            toMap = recordContext.create(typeName);
        }
        for (JSMember next : sourceJson.getMembers()) {
            String attributeName = next.getName().getValue();
            if ("_type".equals(attributeName) || "_id".equals(attributeName) || "_isReference".equals(attributeName)) continue;
            final JSValue jsValue = next.getValue();
            if (!toMap.isAttributeDefined(attributeName)) continue;
            Attribute attribute = toMap.getAttributeDefinition(attributeName);
            if (JSONAttribute.class.isInstance(attribute) || NamedAttributeHolderAttribute.class.isInstance(attribute)) {
                Record rec;
                if (!JSObject.class.isInstance(jsValue) || (rec = this.convertJsonToRecord((JSObject)jsValue, recordContext)) == null) continue;
                toMap.setAttributeValue(attributeName, (Object)rec);
                continue;
            }
            if (SimpleAttribute.class.isInstance(attribute)) {
                if (StringAttribute.class.isInstance(attribute)) {
                    if (!JSString.class.isInstance(jsValue)) continue;
                    toMap.setAttributeValue(attributeName, (Object)((JSString)jsValue).getValue());
                    continue;
                }
                if (DecimalAttribute.class.isInstance(attribute)) {
                    if (!JSNumber.class.isInstance(jsValue)) continue;
                    Class javaNativeType = DecimalAttributeMediator.getJavaNativeType((DecimalAttribute)((DecimalAttribute)attribute));
                    BigDecimal value = ((JSNumber)jsValue).getValue();
                    if (Long.class.equals((Object)javaNativeType)) {
                        toMap.setAttributeValue(attributeName, (Object)value.longValue());
                        continue;
                    }
                    if (Double.class.equals((Object)javaNativeType)) {
                        toMap.setAttributeValue(attributeName, (Object)value.doubleValue());
                        continue;
                    }
                    if (!BigDecimal.class.equals((Object)javaNativeType)) continue;
                    toMap.setAttributeValue(attributeName, (Object)value);
                    continue;
                }
                if (DateAttribute.class.isInstance(attribute)) {
                    if (!JSNumber.class.isInstance(jsValue)) continue;
                    Date date = new Date(((JSNumber)jsValue).getValue().longValue());
                    toMap.setAttributeValue(attributeName, (Object)date);
                    continue;
                }
                if (!BooleanAttribute.class.isInstance(attribute) || !JSBoolean.class.isInstance(jsValue)) continue;
                toMap.setAttributeValue(attributeName, (Object)((JSBoolean)jsValue).isValue());
                continue;
            }
            if (!InverseAttribute.class.isInstance(attribute) || !JSArray.class.isInstance(jsValue)) continue;
            RecordList rl = recordContext.createList(new RecordContext.RecordListInitializer(){

                public Iterator<Record> initialize() {
                    return new Iterator<Record>(){
                        private Iterator<JSValue> iter;
                        private JSObject current;

                        private Iterator<JSValue> getIter() {
                            if (this.iter == null) {
                                this.iter = ((JSArray)jsValue).iterator();
                            }
                            return this.iter;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.getIter().hasNext()) {
                                return false;
                            }
                            JSValue val = null;
                            while (!JSObject.class.isInstance(val) && this.getIter().hasNext()) {
                                val = this.getIter().next();
                            }
                            if (val == null) {
                                return false;
                            }
                            this.current = (JSObject)val;
                            return true;
                        }

                        @Override
                        public Record next() {
                            Record currentConverted = RecordJsonConverterImpl.this.convertJsonToRecord(this.current, recordContext);
                            return currentConverted;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Not supported.");
                        }
                    };
                }
            }, toMap, (InverseAttribute)attribute);
            toMap.setAttributeValue(attributeName, (Object)rl);
        }
        return toMap;
    }

    public JSObject convertRecordToJson(JSObject targetObject, Record sourceRecord) {
        return this.convertRecordToJson(targetObject, sourceRecord, new Stack<Record>());
    }

    private JSObject convertRecordToJson(final JSObject targetObject, Record sourceRecord, final Stack<Record> visitedRecords) {
        if (visitedRecords.contains(sourceRecord)) {
            return null;
        }
        visitedRecords.add(sourceRecord);
        targetObject.createMember("_type").setValue((JSValue)new JSString(sourceRecord.getType().getName()));
        Long id = sourceRecord.getId();
        if (id != null) {
            targetObject.createMember("_id").setValue((JSValue)new JSNumber(id.longValue()));
        }
        if (sourceRecord.isReference()) {
            targetObject.createMember("_isReference").setValue((JSValue)JSBoolean.TRUE);
        }
        sourceRecord.iteratePresentValues(new RecordAttributeIterator(){

            public void handleAttribute(Attribute attribute, Record record) {
                Object attributeValue;
                if (JSONAttribute.class.isInstance(attribute)) {
                    Object attributeValue2 = record.getAttributeValue(attribute.getName());
                    if (attributeValue2 != null) {
                        if (Record.class.isInstance(attributeValue2)) {
                            JSObject nested = new JSObject();
                            if ((nested = RecordJsonConverterImpl.this.convertRecordToJson(nested, (Record)attributeValue2, visitedRecords)) != null) {
                                targetObject.createMember(attribute.getName()).setValue((JSValue)nested);
                            }
                        } else if (JSValue.class.isInstance(attributeValue2)) {
                            targetObject.createMember(attribute.getName()).setValue((JSValue)attributeValue2);
                        }
                    }
                } else if (SimpleAttribute.class.isInstance(attribute)) {
                    Object attributeValue3 = record.getAttributeValue(attribute.getName());
                    if (attributeValue3 != null) {
                        if (String.class.isInstance(attributeValue3)) {
                            targetObject.createMember(attribute.getName()).setValue((JSValue)new JSString((String)attributeValue3));
                        } else if (Long.class.isInstance(attributeValue3)) {
                            targetObject.createMember(attribute.getName()).setValue((JSValue)new JSNumber(((Long)attributeValue3).longValue()));
                        } else if (Double.class.isInstance(attributeValue3)) {
                            targetObject.createMember(attribute.getName()).setValue((JSValue)new JSNumber(((Double)attributeValue3).doubleValue()));
                        } else if (BigDecimal.class.isInstance(attributeValue3)) {
                            targetObject.createMember(attribute.getName()).setValue((JSValue)new JSNumber((BigDecimal)attributeValue3));
                        } else if (Date.class.isInstance(attributeValue3)) {
                            targetObject.createMember(attribute.getName()).setValue((JSValue)new JSNumber(((Date)attributeValue3).getTime()));
                        } else if (Boolean.class.isInstance(attributeValue3)) {
                            targetObject.createMember(attribute.getName()).setValue((JSValue)new JSBoolean(((Boolean)attributeValue3).booleanValue()));
                        }
                    }
                } else if (InverseAttribute.class.isInstance(attribute)) {
                    RecordList attributeValue4 = (RecordList)record.getAttributeValue(attribute.getName(), RecordList.class);
                    if (attributeValue4 != null) {
                        Iterator iter = attributeValue4.iterator();
                        JSArray array = new JSArray();
                        targetObject.createMember(attribute.getName()).setValue((JSValue)array);
                        while (iter.hasNext()) {
                            Record next = (Record)iter.next();
                            JSObject converted = RecordJsonConverterImpl.this.convertRecordToJson(new JSObject(), next, visitedRecords);
                            if (converted == null) continue;
                            array.add((JSValue)converted);
                        }
                    }
                } else if (NamedAttributeHolderAttribute.class.isInstance(attribute) && (attributeValue = record.getAttributeValue(attribute.getName())) != null) {
                    if (Record.class.isInstance(attributeValue)) {
                        JSObject nested = new JSObject();
                        if ((nested = RecordJsonConverterImpl.this.convertRecordToJson(nested, (Record)attributeValue, visitedRecords)) != null) {
                            targetObject.createMember(attribute.getName()).setValue((JSValue)nested);
                        }
                    } else if (Long.class.isInstance(attributeValue)) {
                        targetObject.createMember(attribute.getName()).setValue((JSValue)new JSNumber(((Long)attributeValue).longValue()));
                    }
                }
            }
        });
        visitedRecords.remove(sourceRecord);
        return targetObject;
    }
}

