/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery;

import org.bndly.schema.api.nquery.BooleanOperator;
import org.bndly.schema.api.nquery.BooleanStatement;
import org.bndly.schema.api.nquery.WrapperBooleanStatement;

public final class BooleanStatementIterator {
    private BooleanStatementIterator() {
    }

    public static void iterate(BooleanStatement booleanStatement, Callback callback) {
        while (booleanStatement != null) {
            BooleanOperator operator = booleanStatement.getNextOperator();
            if (operator == null) {
                callback.onLastBooleanStatement(booleanStatement);
            } else {
                callback.onBooleanStatement(booleanStatement, operator);
            }
            if (WrapperBooleanStatement.class.isInstance(booleanStatement)) {
                WrapperBooleanStatement wrapper = (WrapperBooleanStatement)booleanStatement;
                callback.onWrapperOpened(wrapper);
                BooleanStatementIterator.iterate(wrapper.getWrapped(), callback);
                callback.onWrapperClosed(wrapper);
            }
            booleanStatement = booleanStatement.getNext();
        }
    }

    public static class NoOpCallback
    implements Callback {
        @Override
        public void onLastBooleanStatement(BooleanStatement booleanStatement) {
        }

        @Override
        public void onBooleanStatement(BooleanStatement booleanStatement, BooleanOperator operator) {
        }

        @Override
        public void onWrapperOpened(WrapperBooleanStatement wrapper) {
        }

        @Override
        public void onWrapperClosed(WrapperBooleanStatement wrapper) {
        }
    }

    public static interface Callback {
        public void onLastBooleanStatement(BooleanStatement var1);

        public void onBooleanStatement(BooleanStatement var1, BooleanOperator var2);

        public void onWrapperOpened(WrapperBooleanStatement var1);

        public void onWrapperClosed(WrapperBooleanStatement var1);
    }
}

