/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.expression;

import org.bndly.schema.api.nquery.Expression;
import org.bndly.schema.api.nquery.ExpressionStatementHandler;
import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.ParsingState;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.ContextVariable;
import org.bndly.schema.impl.nquery.EntityAttributeReferenceVariable;
import org.bndly.schema.impl.nquery.QueryArgumentContextVariable;
import org.bndly.schema.impl.nquery.states.AcceptStringState;
import org.bndly.schema.impl.nquery.states.ConsumeWhiteSpacesState;
import org.bndly.schema.impl.nquery.states.ReadContextVariableState;

public abstract class AbstractSimpleExpressionStatementHandler
implements ExpressionStatementHandler {
    private final String expressionOperator;

    public AbstractSimpleExpressionStatementHandler(String expressionOperator) {
        if (expressionOperator == null) {
            throw new IllegalArgumentException("expression operator is not allowed to be null");
        }
        this.expressionOperator = expressionOperator;
    }

    public void handleStatement(final String statement, Parser parser, final ExpressionStatementHandler.Context context) throws QueryParsingException {
        parser.push((ParsingState)new ReadContextVariableState(){
            private ContextVariable left;
            private ContextVariable right;
            private Boolean negated;

            @Override
            protected void onContextVariable(ContextVariable contextVariable, Character character, Parser parser) throws QueryParsingException {
                this.left = contextVariable;
                if (character == null) {
                    throw new QueryParsingException("missing operator");
                }
                parser.push((ParsingState)new ConsumeWhiteSpacesState(){

                    @Override
                    protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
                        parser.pop();
                        parser.push((ParsingState)new AcceptStringState(AbstractSimpleExpressionStatementHandler.this.expressionOperator){

                            @Override
                            protected void accepted(Parser parser) throws QueryParsingException {
                                parser.pop();
                                parser.push((ParsingState)new ReadContextVariableState(){

                                    @Override
                                    protected void onContextVariable(ContextVariable contextVariable, Character character, Parser parser) throws QueryParsingException {
                                        right = contextVariable;
                                        if (negated != null && left != null && right != null) {
                                            Expression exp = AbstractSimpleExpressionStatementHandler.this.createExpression(left, right, negated, context, parser, statement);
                                            if (exp == null) {
                                                throw new QueryParsingException("implementation did not create expression object");
                                            }
                                            context.expressionCreated(exp);
                                        }
                                    }
                                });
                            }

                            @Override
                            protected void notAccepted(Character character, Parser parser) throws QueryParsingException {
                                parser.pop();
                                throw new QueryParsingException("could not read expression operator");
                            }
                        });
                        if (Character.toString(character).equals("!")) {
                            negated = true;
                        } else {
                            negated = false;
                            parser.peek().handleChar(character, parser);
                        }
                    }
                }).handleChar(character.charValue(), parser);
            }
        });
        parser.parse(statement);
    }

    protected abstract Expression createExpression(ContextVariable var1, ContextVariable var2, Boolean var3, ExpressionStatementHandler.Context var4, Parser var5, String var6) throws QueryParsingException;

    protected final ContextVariable createContextVariable(String rawString, Parser parser) throws QueryParsingException {
        if ("?".equals(rawString)) {
            return new QueryArgumentContextVariable(parser.getNextQueryArg());
        }
        return new EntityAttributeReferenceVariable(rawString);
    }
}

