/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.expression;

import org.bndly.schema.api.nquery.Expression;
import org.bndly.schema.api.nquery.ExpressionStatementHandler;
import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.ParsingState;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.ContextVariable;
import org.bndly.schema.impl.nquery.EntityAttributeReferenceVariable;
import org.bndly.schema.impl.nquery.InRangeExpressionImpl;
import org.bndly.schema.impl.nquery.QueryArgumentContextVariable;
import org.bndly.schema.impl.nquery.states.ReadAheadState;

public class InRangeExpressionStatementHandler
implements ExpressionStatementHandler {
    public void handleStatement(final String statement, Parser parser, final ExpressionStatementHandler.Context context) throws QueryParsingException {
        parser.push((ParsingState)new ReadAheadState(new String[]{"!", "INRANGE"}){
            private String left;
            private Boolean negated;
            private ContextVariable lower;
            private ContextVariable upper;

            @Override
            protected void onStopWord(String buffered, String stopWord, char character, Parser parser) throws QueryParsingException {
                parser.pop();
                if ("INRANGE".equals(stopWord)) {
                    this.left = buffered;
                    if (this.negated == null) {
                        this.negated = false;
                    }
                    parser.push(this.readRight());
                } else if ("!".equals(stopWord)) {
                    this.negated = true;
                    this.left = buffered;
                    parser.push((ParsingState)new ReadAheadState(new String[]{"INRANGE"}){

                        @Override
                        protected void onStopWord(String buffered, String stopWord, char character, Parser parser) throws QueryParsingException {
                            parser.pop();
                            if (!buffered.trim().equals("")) {
                                throw new QueryParsingException("negation has to be followed by INRANGE");
                            }
                            parser.push(this.readRight());
                        }

                        @Override
                        public void onEnd(Parser parser) throws QueryParsingException {
                            parser.pop();
                            throw new QueryParsingException("INRANGE statement was incomplete");
                        }
                    });
                } else {
                    throw new QueryParsingException("unsupported stop word while parsing INRANGE statement");
                }
            }

            @Override
            public void onEnd(Parser parser) throws QueryParsingException {
                parser.pop();
                throw new QueryParsingException("INRANGE statement was incomplete");
            }

            private ParsingState readRight() {
                return new ParsingState(){
                    boolean expectParam = true;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public void handleChar(char character, Parser parser) throws QueryParsingException {
                        if (Character.isWhitespace(character)) {
                            return;
                        }
                        String cs = Character.toString(character);
                        if (this.expectParam && "?".equals(cs)) {
                            this.expectParam = false;
                            if (lower == null) {
                                lower = new QueryArgumentContextVariable(parser.getNextQueryArg());
                                return;
                            }
                            if (upper == null) {
                                upper = new QueryArgumentContextVariable(parser.getNextQueryArg());
                                return;
                            }
                            parser.pop();
                            throw new QueryParsingException("INRANGE requires two arguments");
                        }
                        if (!this.expectParam && character == ',') {
                            this.expectParam = true;
                            return;
                        }
                        parser.pop();
                        throw new QueryParsingException("parameters of INRANGE have to be separated by a comma");
                    }

                    public void onEnd(Parser parser) throws QueryParsingException {
                        parser.pop();
                        if (left == null || negated == null || lower == null || upper == null) {
                            throw new QueryParsingException("failed to parse INRANGE statement. not all information could be collected");
                        }
                        InRangeExpressionImpl inRangeExpressionImpl = new InRangeExpressionImpl(statement);
                        inRangeExpressionImpl.setNegated(negated);
                        inRangeExpressionImpl.setNextOperator(context.nextOperator());
                        inRangeExpressionImpl.setField(new EntityAttributeReferenceVariable(left.trim()));
                        inRangeExpressionImpl.setLowerBorder(lower);
                        inRangeExpressionImpl.setUpperBorder(upper);
                        context.expressionCreated((Expression)inRangeExpressionImpl);
                    }
                };
            }
        });
        parser.parse(statement);
    }
}

