/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.sqlmapper;

import java.util.Set;
import org.bndly.schema.api.AliasBinding;
import org.bndly.schema.api.MappingBinding;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.impl.nquery.TypedExpression;
import org.bndly.schema.impl.nquery.sqlmapper.AbstractFieldCentricMapper;
import org.bndly.schema.impl.nquery.sqlmapper.BooleanStatementSQLMapper;
import org.bndly.schema.impl.nquery.sqlmapper.InRangeExpressionMapper;
import org.bndly.schema.impl.nquery.sqlmapper.RequiredAttribtuesInspector;
import org.bndly.schema.impl.query.ExpressionProducer;

public class TypedExpressionMapper
extends AbstractFieldCentricMapper<TypedExpression>
implements RequiredAttribtuesInspector<TypedExpression> {
    public TypedExpressionMapper() {
        super(TypedExpression.class);
    }

    @Override
    protected void map(TypedExpression booleanStatement, ExpressionProducer expressionProducer, String prefix, MappingBinding mappingBinding, BooleanStatementSQLMapper.Context context, AliasBinding aliasBinding) {
        Table table = aliasBinding.getAttributeColumn().getTable();
        if (!TypeTable.class.isInstance(table)) {
            throw new IllegalStateException("expected a type table for the id field");
        }
        TypeTable tt = (TypeTable)table;
        if (tt.getType().getName().equals(booleanStatement.getTypeName())) {
            String fieldName = aliasBinding.getTableAlias() + "." + aliasBinding.getAttributeColumn().getColumnName();
            expressionProducer.produce().criteria().field(fieldName).isNotNull();
        }
    }

    @Override
    public void collectRequiredAttributesFromBooleanStatement(Set<String> set, String alias, TypedExpression booleanStatement, RequiredAttribtuesInspector.Context context) {
        InRangeExpressionMapper.addAttributesToSet(booleanStatement.getField(), set, alias);
    }

    @Override
    protected String getAttributePath(TypedExpression booleanStatement) {
        return booleanStatement.getField().getName();
    }
}

