/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.sqlmapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bndly.schema.api.AliasBinding;
import org.bndly.schema.api.MappingBinding;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.services.TableRegistry;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.Type;
import org.bndly.schema.model.TypeAttribute;

public final class Util {
    private Util() {
    }

    public static void addAttributeToSet(Set<String> set, String attributePath) {
        int index = attributePath.indexOf(".");
        while (index > -1) {
            set.add(attributePath.substring(0, index));
            index = attributePath.indexOf(".", index + 1);
        }
        set.add(attributePath);
    }

    public static String stripEntityAliasPrefix(String alias, String name) {
        if (alias == null) {
            return name;
        }
        if (name.startsWith(alias + ".")) {
            return name.substring(alias.length() + 1);
        }
        throw new IllegalStateException("string did not start with expected alias prefix");
    }

    public static List<AliasBinding> resolveAliasBindingsFromMappingBinding(MappingBinding mappingBinding, String attributePath, TableRegistry tableRegistry) {
        int index = attributePath.indexOf(".");
        ArrayList<AliasBinding> result = null;
        if (index > -1) {
            String attName = attributePath.substring(0, index);
            String nestedAttName = attributePath.substring(index + 1);
            Map subs = mappingBinding.getSubBindings();
            if (subs != null) {
                List subLists = (List)subs.get(attributePath.substring(0, index));
                if (subLists != null) {
                    String subPath = attributePath.substring(index + 1);
                    for (MappingBinding sub : subLists) {
                        List<AliasBinding> aliases = Util.resolveAliasBindingsFromMappingBinding(sub, subPath, tableRegistry);
                        if (result == null) {
                            result = new ArrayList();
                        }
                        result.addAll(aliases);
                    }
                }
            } else {
                List aliases = mappingBinding.getAliases();
                if (aliases != null) {
                    for (AliasBinding alias : aliases) {
                        TypeTable table;
                        Type type;
                        List st;
                        Attribute att = alias.getAttribute();
                        if (!attName.equals(att.getName()) || !TypeAttribute.class.isInstance(att) || (st = (type = ((TypeAttribute)att).getType()).getSubTypes()) != null && !st.isEmpty() || !(table = tableRegistry.getTypeTableByType(type)).getPrimaryKeyColumn().getAttribute().getName().equals(nestedAttName)) continue;
                        if (result == null) {
                            result = new ArrayList();
                        }
                        result.add(alias);
                    }
                }
            }
        } else {
            AliasBinding pkAlias;
            List aliases = mappingBinding.getAliases();
            if (aliases != null) {
                for (AliasBinding alias : aliases) {
                    if (!alias.getAttribute().getName().equals(attributePath)) continue;
                    if (result == null) {
                        result = new ArrayList();
                    }
                    result.add(alias);
                }
            }
            if ((pkAlias = mappingBinding.getPrimaryKeyAlias()) != null && pkAlias.getAttribute().getName().equals(attributePath)) {
                if (result == null) {
                    result = new ArrayList<AliasBinding>();
                }
                result.add(pkAlias);
            }
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }
}

