/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.states;

import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.ParsingState;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.CountImpl;
import org.bndly.schema.impl.nquery.IfClauseImpl;
import org.bndly.schema.impl.nquery.states.ConsumeWhiteSpacesState;
import org.bndly.schema.impl.nquery.states.IfClauseState;
import org.bndly.schema.impl.nquery.states.ReservedKeywordState;
import org.bndly.schema.impl.nquery.states.TokenState;

public class CountState
extends ConsumeWhiteSpacesState {
    private final CountImpl countImpl;

    public CountState(CountImpl countImpl) {
        this.countImpl = countImpl;
    }

    @Override
    protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
        parser.pop();
        parser.push((ParsingState)new TokenState(){

            @Override
            protected void onTokenComplete(Character character, Parser parser) throws QueryParsingException {
                CountState.this.countImpl.setAttributeHolderName(this.getToken());
                parser.pop();
                parser.push((ParsingState)new ConsumeWhiteSpacesState(){

                    @Override
                    protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
                        parser.pop();
                        parser.push((ParsingState)new ReservedKeywordState(){

                            @Override
                            protected void onAlias(String alias, Character character, Parser parser) throws QueryParsingException {
                                CountState.this.onParsedAlias(alias, character, parser);
                            }

                            @Override
                            protected void onKeyword(String kw, Character character, Parser parser) throws QueryParsingException {
                                CountState.this.onParsedKeyword(kw, character, parser);
                            }
                        }).handleChar(character, parser);
                    }
                });
                this.doContinue(character, parser);
            }
        }).handleChar(character, parser);
    }

    @Override
    public void onEnd(Parser parser) throws QueryParsingException {
        if (this.countImpl.getAttributeHolderName() == null) {
            throw new QueryParsingException("parsing a PICK failed because not attribute holder was provided");
        }
    }

    private void onParsedKeyword(String kw, Character character, Parser parser) throws QueryParsingException {
        if (!"IF".equals(kw)) {
            if (kw == null) {
                return;
            }
            throw new QueryParsingException("unsupported keyword " + kw);
        }
        IfClauseImpl ifClauseImpl = new IfClauseImpl();
        this.countImpl.setIfClause(ifClauseImpl);
        parser.push((ParsingState)new IfClauseState(ifClauseImpl));
        this.doContinue(character, parser);
    }

    private void onParsedAlias(String alias, Character character, Parser parser) throws QueryParsingException {
        this.countImpl.setAttributeHolderNameAlias(alias);
        parser.pop();
        parser.push((ParsingState)new ConsumeWhiteSpacesState(){

            @Override
            protected void onNonWhiteSpace(char character, Parser parser) throws QueryParsingException {
                parser.pop();
                parser.push((ParsingState)new TokenState(){

                    @Override
                    protected void onTokenComplete(Character character, Parser parser) throws QueryParsingException {
                        String tkn = this.getToken();
                        CountState.this.onParsedKeyword(tkn, character, parser);
                        this.sb = null;
                    }
                });
                this.doContinue(Character.valueOf(character), parser);
            }
        });
        this.doContinue(character, parser);
    }
}

