/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.states;

import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.states.AbstractParsingState;

public abstract class ExpressionState
extends AbstractParsingState {
    private boolean operatorHasBeenRead = false;
    private boolean negate = false;
    private String leftOfOperator;
    private String operator;
    private String rightOfOperator;
    private StringBuffer buf;

    public void handleChar(char character, Parser parser) throws QueryParsingException {
        String cs = Character.toString(character);
        String buffered = this.getBuffered() + cs;
        if ("!".equals(cs)) {
            if (this.operatorHasBeenRead) {
                throw new QueryParsingException("negation after operator is not allowed");
            }
            this.negate = true;
        } else if (buffered.endsWith("=")) {
            this.onOperatorRead("=", buffered);
        } else if (buffered.endsWith("INRANGE")) {
            this.onOperatorRead("INRANGE", buffered);
        } else if ("?".equals(cs)) {
            if (!this.operatorHasBeenRead) {
                throw new QueryParsingException("parameter wild cards are only expected right to the operator");
            }
            this.appendToBuffer(character);
        } else {
            this.appendToBuffer(character);
        }
    }

    private void onOperatorRead(String op, String buffered) throws QueryParsingException {
        if (this.operatorHasBeenRead) {
            throw new QueryParsingException("operator is already parsed");
        }
        this.operatorHasBeenRead = true;
        if (this.buf == null || this.buf.toString().equals("?")) {
            throw new QueryParsingException("equal operator requires an attribute reference left to the equal.");
        }
        this.operator = op;
        this.leftOfOperator = buffered.substring(0, buffered.length() - op.length());
        this.buf = null;
    }

    private String getBuffered() {
        return this.buf == null ? "" : this.buf.toString();
    }

    private void appendToBuffer(char character) {
        if (this.buf == null) {
            this.buf = new StringBuffer();
        }
        this.buf.append(character);
    }

    public void onEnd(Parser parser) throws QueryParsingException {
        if (this.operatorHasBeenRead && this.buf != null) {
            this.rightOfOperator = this.buf.toString();
        }
        parser.pop();
    }

    public boolean isOperatorRead() {
        return this.operatorHasBeenRead;
    }

    public boolean isNegated() {
        return this.negate;
    }

    public String getLeftOfOperator() {
        return this.leftOfOperator;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getRightOfOperator() {
        return this.rightOfOperator;
    }
}

