/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.states;

import java.util.ArrayList;
import java.util.List;
import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.states.AbstractParsingState;

public abstract class ReadAheadState
extends AbstractParsingState {
    private boolean didFire;
    private final StringBuffer buffer = new StringBuffer();
    protected final String[] stopWords;
    private final List<Candidate> remainingStopWords;

    public ReadAheadState(String ... stopWords) {
        this.stopWords = stopWords;
        this.remainingStopWords = new ArrayList<Candidate>(stopWords.length);
        for (String stopWord : stopWords) {
            this.remainingStopWords.add(new Candidate(stopWord));
        }
    }

    protected boolean isAppendableCharacter(char character) throws QueryParsingException {
        return true;
    }

    public void handleChar(char character, Parser parser) throws QueryParsingException {
        if (!this.isAppendableCharacter(character)) {
            return;
        }
        this.buffer.append(character);
        for (Candidate candidate : this.remainingStopWords) {
            if (candidate.didMatch()) {
                candidate.getBufferAfterStopWord().append(character);
                continue;
            }
            candidate.match(character);
        }
        this.fireOnStopWord(Character.valueOf(character), parser);
    }

    public void onEnd(Parser parser) throws QueryParsingException {
        this.fireOnStopWord(null, parser);
    }

    private void fireOnStopWord(Character character, Parser parser) throws QueryParsingException {
        if (this.didFire) {
            return;
        }
        boolean containsPartialMatch = false;
        Candidate bestMatched = null;
        for (Candidate remainingStopWord : this.remainingStopWords) {
            if (remainingStopWord.isPartialMatch()) {
                containsPartialMatch = true;
            }
            if (!remainingStopWord.didMatch()) continue;
            if (bestMatched == null) {
                bestMatched = remainingStopWord;
                continue;
            }
            if (bestMatched.getBufferAfterStopWord().length() <= remainingStopWord.getBufferAfterStopWord().length()) continue;
            bestMatched = remainingStopWord;
        }
        if (!containsPartialMatch && bestMatched != null) {
            int offsetInStringBuffer = bestMatched.getBufferBeforeStopWord().length() - bestMatched.getStopWord().length();
            String buffered = bestMatched.getBufferBeforeStopWord().substring(0, offsetInStringBuffer);
            this.onStopWord(buffered, bestMatched.getStopWord(), character.charValue(), parser);
            this.didFire = true;
            parser.reparse(bestMatched.getBufferAfterStopWord().toString());
        }
    }

    protected final String getBuffered() {
        return this.buffer.toString();
    }

    protected abstract void onStopWord(String var1, String var2, char var3, Parser var4) throws QueryParsingException;

    private class Candidate {
        private final String stopWord;
        private final StringBuffer bufferBeforeStopWord;
        private final StringBuffer bufferAfterStopWord;
        private boolean matched;
        private int index;

        public Candidate(String stopWord) {
            this.stopWord = stopWord;
            this.bufferAfterStopWord = new StringBuffer();
            this.bufferBeforeStopWord = new StringBuffer();
            this.index = 0;
        }

        public void match(char c) {
            if (this.matched) {
                this.bufferAfterStopWord.append(c);
                return;
            }
            this.bufferBeforeStopWord.append(c);
            if (this.stopWord.charAt(this.index) == c) {
                ++this.index;
                if (this.index == this.stopWord.length()) {
                    this.matched = true;
                }
            } else {
                this.index = 0;
            }
        }

        public boolean didMatch() {
            return this.matched;
        }

        public boolean isPartialMatch() {
            return this.index > 0 && !this.matched;
        }

        public String getStopWord() {
            return this.stopWord;
        }

        public StringBuffer getBufferBeforeStopWord() {
            return this.bufferBeforeStopWord;
        }

        public StringBuffer getBufferAfterStopWord() {
            return this.bufferAfterStopWord;
        }
    }
}

