/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.nquery.states;

import org.bndly.schema.api.nquery.Parser;
import org.bndly.schema.api.nquery.ParsingState;
import org.bndly.schema.api.nquery.QueryParsingException;
import org.bndly.schema.impl.nquery.ContextVariable;
import org.bndly.schema.impl.nquery.EntityAttributeReferenceVariable;
import org.bndly.schema.impl.nquery.QueryArgumentContextVariable;

public abstract class ReadContextVariableState
implements ParsingState {
    private static final String ENTITY_ATTRIBUTE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.";
    private StringBuffer sb = null;
    private String raw;

    public void handleChar(char character, Parser parser) throws QueryParsingException {
        if (Character.isWhitespace(character)) {
            if (this.sb == null) {
                return;
            }
            this.finish(parser, Character.valueOf(character));
            return;
        }
        if (Character.toString(character).equals("?")) {
            if (this.sb == null) {
                this.sb = new StringBuffer("?");
                this.finish(parser, Character.valueOf(character));
                return;
            }
            parser.pop();
            throw new QueryParsingException("unsupported character in context variable");
        }
        if (ENTITY_ATTRIBUTE_CHARS.indexOf(character) < 0) {
            if (this.sb == null) {
                parser.pop();
                throw new QueryParsingException("unsupported character in context variable");
            }
            this.finish(parser, Character.valueOf(character));
        }
        if (this.sb == null) {
            this.sb = new StringBuffer();
        }
        this.sb.append(character);
    }

    public void onEnd(Parser parser) throws QueryParsingException {
        this.finish(parser, null);
    }

    private void finish(Parser parser, Character character) throws QueryParsingException {
        ContextVariable contextVariable;
        this.raw = this.sb == null ? null : this.sb.toString();
        parser.pop();
        if ("?".equals(this.raw)) {
            contextVariable = new QueryArgumentContextVariable(parser.getNextQueryArg());
        } else if (this.raw != null) {
            contextVariable = new EntityAttributeReferenceVariable(this.raw);
        } else {
            throw new QueryParsingException("could not create context variable");
        }
        this.onContextVariable(contextVariable, character, parser);
    }

    protected abstract void onContextVariable(ContextVariable var1, Character var2, Parser var3) throws QueryParsingException;
}

