/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import org.bndly.schema.api.CommitHandler;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.RecordImpl;
import org.bndly.schema.impl.persistence.TransactionAppender;

public class MarkAsNotDirty
implements TransactionAppender {
    public static final MarkAsNotDirty INSTANCE = new MarkAsNotDirty();

    @Override
    public void append(Transaction tx, final Record record, EngineImpl engine) {
        tx.afterCommit(new CommitHandler(){

            public void didCommit(Transaction transaction) {
                MarkAsNotDirty.this.markRecordAsNotDirty(record);
            }
        });
    }

    private void markRecordAsNotDirty(Record record) {
        if (RecordImpl.class.isInstance(record)) {
            ((RecordImpl)record).setIsDirty(false);
        }
    }
}

