/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bndly.schema.api.AttributeMediator;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordAttributeIterator;
import org.bndly.schema.api.Transaction;
import org.bndly.schema.api.db.AttributeColumn;
import org.bndly.schema.api.db.TypeTable;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryContext;
import org.bndly.schema.api.query.Update;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.EngineImpl;
import org.bndly.schema.impl.persistence.TransactionAppender;
import org.bndly.schema.model.Attribute;
import org.bndly.schema.model.BinaryAttribute;

public class UploadBlobs
implements TransactionAppender {
    public static UploadBlobs INSTANCE = new UploadBlobs();

    @Override
    public void append(Transaction tx, final Record record, EngineImpl engine) {
        List<Query> blobQueries = this._buildBlobInsertQueries(record, new ValueProvider<Long>(){

            public Long get() {
                return record.getId();
            }
        }, engine);
        for (Query query : blobQueries) {
            tx.getQueryRunner().uploadBlob(query);
        }
    }

    private List<Query> _buildBlobInsertQueries(Record record, final ValueProvider<Long> idReference, final EngineImpl engine) {
        final ArrayList<Query> result = new ArrayList<Query>();
        final TypeTable table = engine.getTableRegistry().getTypeTableByType(record.getType());
        final HashMap<String, AttributeColumn> columnsByAttributeName = new HashMap<String, AttributeColumn>();
        for (AttributeColumn attributeColumn : table.getColumns()) {
            columnsByAttributeName.put(attributeColumn.getAttribute().getName(), attributeColumn);
        }
        record.iteratePresentValues(new RecordAttributeIterator(){

            public void handleAttribute(Attribute attribute, Record record) {
                if (BinaryAttribute.class.isInstance(attribute)) {
                    QueryContext qc = engine.getQueryContextFactory().buildQueryContext();
                    Update update = qc.update();
                    update.table(table.getTableName());
                    AttributeColumn column = (AttributeColumn)columnsByAttributeName.get(attribute.getName());
                    Object rawValue = record.getAttributeValue(attribute.getName());
                    AttributeMediator<Attribute> mediator = engine.getMediatorRegistry().getMediatorForAttribute(attribute);
                    int sqlType = mediator.columnSqlType(attribute);
                    if (rawValue == null) {
                        update.setNull(column.getColumnName(), sqlType);
                    } else {
                        update.set(column.getColumnName(), mediator.createValueProviderFor(record, attribute), sqlType);
                    }
                    update.where().expression().criteria().field(table.getPrimaryKeyColumn().getColumnName()).equal().value(idReference);
                    result.add(qc.build(record.getContext()));
                }
            }
        });
        return result;
    }
}

