/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bndly.schema.api.PreparedStatementArgumentSetter;
import org.bndly.schema.api.ValueUtil;
import org.bndly.schema.api.query.Criteria;
import org.bndly.schema.api.query.PreparedStatementValueProvider;
import org.bndly.schema.api.query.QueryRenderContext;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.QueryContextImpl;
import org.bndly.schema.impl.query.BetweenImpl;
import org.bndly.schema.impl.query.ContextRelatedQueryComponentImpl;
import org.bndly.schema.vendor.VendorConfiguration;

public class CriteriaImpl
extends ContextRelatedQueryComponentImpl
implements Criteria {
    private final List<String> fieldNames = new ArrayList<String>();
    private String operand;
    private Boolean isNull;
    private ValueProvider parameterValue;
    private BetweenImpl between;

    public CriteriaImpl(QueryContextImpl queryContext, VendorConfiguration vendorConfiguration) {
        super(queryContext, vendorConfiguration);
    }

    public Criteria between() {
        this.between = new BetweenImpl();
        return this;
    }

    public Criteria left(ValueProvider reference) {
        this.between.setLeft(reference);
        return this;
    }

    public Criteria right(ValueProvider reference) {
        this.between.setRight(reference);
        return this;
    }

    public Criteria field(String fieldName) {
        this.fieldNames.add(fieldName);
        return this;
    }

    public Criteria equal() {
        this.operand = "=";
        return this;
    }

    public Criteria notEqual() {
        this.operand = "!=";
        return this;
    }

    public Criteria lowerThan() {
        this.operand = "<";
        return this;
    }

    public Criteria equalOrLowerThan() {
        this.operand = "<=";
        return this;
    }

    public Criteria greaterThan() {
        this.operand = ">";
        return this;
    }

    public Criteria equalOrGreaterThan() {
        this.operand = ">=";
        return this;
    }

    public Criteria isNotNull() {
        this.isNull = false;
        return this;
    }

    public Criteria isNull() {
        this.isNull = true;
        return this;
    }

    public Criteria value(ValueProvider reference) {
        this.parameterValue = reference;
        return this;
    }

    private void appendValueProvider(QueryRenderContext ctx, final ValueProvider valueProvider) {
        if (PreparedStatementValueProvider.class.isInstance(valueProvider)) {
            ValueUtil.appendToArgs((QueryRenderContext)ctx, null);
            ctx.getArgumentSetters().add((PreparedStatementValueProvider)valueProvider);
        } else {
            ValueUtil.appendToArgs((QueryRenderContext)ctx, (Object)valueProvider.get());
            ctx.getArgumentSetters().add(new PreparedStatementArgumentSetter(){

                public void set(int index, PreparedStatement ps) throws SQLException {
                    ps.setObject(index, ValueUtil.unwrapValue((Object)valueProvider));
                }
            });
        }
    }

    public void renderQueryFragment(QueryRenderContext ctx) {
        if (!this.fieldNames.isEmpty()) {
            if (this.between != null && this.fieldNames.size() == 1) {
                String fieldName = this.fieldNames.get(0);
                ctx.getSql().append(fieldName);
                ctx.getSql().append(" BETWEEN ");
                ctx.getSql().append("? AND ?");
                this.appendValueProvider(ctx, this.between.getLeft());
                this.appendValueProvider(ctx, this.between.getRight());
                return;
            }
            if (this.fieldNames.size() == 1 && this.isNull != null) {
                ctx.getSql().append(this.fieldNames.get(0));
                if (this.isNull.booleanValue()) {
                    ctx.getSql().append(" IS NULL");
                } else {
                    ctx.getSql().append(" IS NOT NULL");
                }
                return;
            }
            if (this.operand != null) {
                if (this.fieldNames.size() > 1) {
                    String p1 = this.fieldNames.get(0);
                    String p2 = this.fieldNames.get(1);
                    ctx.getSql().append(p1);
                    ctx.getSql().append(this.operand);
                    ctx.getSql().append(p2);
                    return;
                }
                if (this.fieldNames.size() == 1 && this.parameterValue != null) {
                    ctx.getSql().append(this.fieldNames.get(0));
                    ctx.getSql().append(this.operand);
                    ctx.getSql().append('?');
                    this.appendValueProvider(ctx, this.parameterValue);
                    return;
                }
            }
        }
        throw new IllegalStateException("failed rendering criteria.");
    }
}

