/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bndly.schema.api.PreparedStatementArgumentSetter;
import org.bndly.schema.api.ValueUtil;
import org.bndly.schema.api.query.Insert;
import org.bndly.schema.api.query.PreparedStatementValueProvider;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryRenderContext;
import org.bndly.schema.api.query.QueryValueProvider;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.impl.QueryContextImpl;
import org.bndly.schema.impl.query.ContextRelatedQueryComponentImpl;
import org.bndly.schema.impl.query.KeyValue;
import org.bndly.schema.vendor.VendorConfiguration;

public class InsertImpl
extends ContextRelatedQueryComponentImpl
implements Insert {
    private String tableName;
    private final List<KeyValue> values = new ArrayList<KeyValue>();

    public InsertImpl(QueryContextImpl queryContext, VendorConfiguration vendorConfiguration) {
        super(queryContext, vendorConfiguration);
    }

    public Insert into(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Insert value(String columnName, QueryValueProvider value) {
        return this._value(columnName, (ValueProvider)value, null);
    }

    public Insert value(String columnName, ValueProvider value) {
        return this._value(columnName, value, null);
    }

    public Insert value(String columnName, ValueProvider value, int sqlType) {
        return this._value(columnName, value, sqlType);
    }

    private Insert _value(String columnName, ValueProvider value, Integer sqlType) {
        if (value != null) {
            PreparedStatementArgumentSetter argumentSetter = PreparedStatementArgumentSetter.class.isInstance(value) ? (PreparedStatementArgumentSetter)value : this.createFallbackPreparedStatementArgumentSetter(value, sqlType);
            this.values.add(new KeyValue(columnName, value, sqlType, argumentSetter));
        }
        return this;
    }

    public void renderQueryFragment(QueryRenderContext ctx) {
        ctx.getSql().append("INSERT INTO ");
        ctx.getSql().append(this.tableName);
        if (this.values.isEmpty()) {
            ctx.getSql().append(this.getVendorConfiguration().getQueryRenderingAdapter().createEmptyRowInsertForTable(this.tableName));
        } else {
            StringBuilder k = new StringBuilder("(");
            StringBuilder v = new StringBuilder("(");
            boolean first = true;
            for (KeyValue kv : this.values) {
                if (!first) {
                    k.append(',');
                    v.append(',');
                }
                first = false;
                k.append(kv.getKey());
                ValueProvider valueProvider = kv.getValue();
                if (QueryValueProvider.class.isInstance(valueProvider)) {
                    QueryValueProvider qvp = (QueryValueProvider)valueProvider;
                    Query nestedQuery = qvp.get();
                    v.append('(');
                    v.append(nestedQuery.getSql());
                    v.append(')');
                    ctx.getArgs().addAll(Arrays.asList(nestedQuery.getArgs()));
                    ctx.getArgumentSetters().addAll(Arrays.asList(nestedQuery.getArgumentSetters()));
                    continue;
                }
                if (PreparedStatementValueProvider.class.isInstance(valueProvider)) {
                    PreparedStatementValueProvider psvp = (PreparedStatementValueProvider)valueProvider;
                    v.append('?');
                    ValueUtil.appendToArgs((QueryRenderContext)ctx, null);
                    ctx.getArgumentSetters().add(psvp);
                    continue;
                }
                Object value = valueProvider.get();
                v.append('?');
                ValueUtil.appendToArgs((QueryRenderContext)ctx, (Object)value);
                ctx.getArgumentSetters().add(kv.getArgumentSetter());
            }
            k.append(')');
            v.append(')');
            ctx.getSql().append((CharSequence)k);
            ctx.getSql().append(" VALUES ");
            ctx.getSql().append((CharSequence)v);
        }
    }
}

