/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.query;

import java.util.ArrayList;
import java.util.List;
import org.bndly.schema.api.query.OrderBy;
import org.bndly.schema.api.query.QueryRenderContext;
import org.bndly.schema.impl.QueryContextImpl;
import org.bndly.schema.impl.query.ContextRelatedQueryComponentImpl;
import org.bndly.schema.vendor.VendorConfiguration;

public class OrderByImpl
extends ContextRelatedQueryComponentImpl
implements OrderBy {
    private final List<String> aliases = new ArrayList<String>();
    private String direction;

    public OrderByImpl(QueryContextImpl queryContext, VendorConfiguration vendorConfiguration) {
        super(queryContext, vendorConfiguration);
    }

    public OrderBy columnAlias(String alias) {
        if (alias == null) {
            return this;
        }
        this.aliases.add(alias);
        return this;
    }

    public OrderBy direction(String direction) {
        this.direction = direction;
        return this;
    }

    public void renderQueryFragment(QueryRenderContext context) {
        if (this.aliases.isEmpty()) {
            return;
        }
        StringBuilder sb = context.getSql();
        sb.append(" ORDER BY ");
        if (this.aliases.size() == 1) {
            sb.append(this.aliases.get(0));
        } else {
            this.appendIFNULL(sb, 0);
        }
        if (this.direction != null) {
            sb.append(" ");
            sb.append(this.direction);
        }
    }

    private void appendIFNULL(StringBuilder sb, int start) {
        sb.append("IFNULL(");
        String leftAlias = this.aliases.get(start);
        sb.append(leftAlias);
        sb.append(",");
        if (start + 1 == this.aliases.size() - 1) {
            String rightAlias = this.aliases.get(start + 1);
            sb.append(rightAlias);
        } else {
            this.appendIFNULL(sb, start + 1);
        }
        sb.append(")");
    }
}

