/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.query;

import org.bndly.schema.api.query.QueryRenderContext;
import org.bndly.schema.api.query.SelectExpression;
import org.bndly.schema.impl.QueryContextImpl;
import org.bndly.schema.impl.query.ContextRelatedQueryComponentImpl;
import org.bndly.schema.vendor.VendorConfiguration;

public class SelectExpressionImpl
extends ContextRelatedQueryComponentImpl
implements SelectExpression {
    private String fieldName;
    private String alias;
    private String tableAlias;
    private String countedFieldOrAlias;

    public SelectExpressionImpl(QueryContextImpl queryContext, VendorConfiguration vendorConfiguration) {
        super(queryContext, vendorConfiguration);
    }

    public SelectExpression table(String tableAlias) {
        this.tableAlias = tableAlias;
        return this;
    }

    public SelectExpression field(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public SelectExpression as(String alias) {
        this.alias = alias;
        return this;
    }

    public SelectExpression count(String countedFieldOrAlias) {
        this.countedFieldOrAlias = countedFieldOrAlias;
        return this;
    }

    public SelectExpression count() {
        return this.count("*");
    }

    public void renderQueryFragment(QueryRenderContext ctx) {
        if (this.countedFieldOrAlias != null) {
            ctx.getSql().append("COUNT(");
            ctx.getSql().append(this.countedFieldOrAlias);
            ctx.getSql().append(')');
        } else {
            if (this.tableAlias != null) {
                ctx.getSql().append(this.tableAlias);
                ctx.getSql().append('.');
            }
            ctx.getSql().append(this.fieldName);
        }
        if (this.alias != null) {
            ctx.getSql().append(" AS ");
            ctx.getSql().append(this.alias);
        }
        if (this.tableAlias != null && this.alias != null) {
            this.getQueryContext().registerSelectAlias(this.tableAlias, this.fieldName, this.alias);
        }
    }
}

