/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bndly.schema.api.PreparedStatementArgumentSetter;
import org.bndly.schema.api.query.From;
import org.bndly.schema.api.query.OrderBy;
import org.bndly.schema.api.query.QueryRenderContext;
import org.bndly.schema.api.query.Select;
import org.bndly.schema.api.query.SelectExpression;
import org.bndly.schema.api.query.Where;
import org.bndly.schema.impl.QueryContextImpl;
import org.bndly.schema.impl.query.ContextRelatedQueryComponentImpl;
import org.bndly.schema.impl.query.FromImpl;
import org.bndly.schema.impl.query.OrderByImpl;
import org.bndly.schema.impl.query.SelectExpressionImpl;
import org.bndly.schema.impl.query.WhereImpl;
import org.bndly.schema.vendor.VendorConfiguration;

public class SelectImpl
extends ContextRelatedQueryComponentImpl
implements Select {
    private boolean selectAll = true;
    private From from;
    private Where where;
    private OrderBy orderBy;
    private final List<SelectExpression> selectExpressions = new ArrayList<SelectExpression>();
    private Long limit;
    private Long offset;

    public SelectImpl(QueryContextImpl queryContext, VendorConfiguration vendorConfiguration) {
        super(queryContext, vendorConfiguration);
    }

    public void renderQueryFragment(QueryRenderContext ctx) {
        ctx.getSql().append("SELECT");
        if (this.selectAll) {
            ctx.getSql().append(" * ");
        } else {
            boolean first = true;
            for (SelectExpression selectExpression : this.selectExpressions) {
                if (!first) {
                    ctx.getSql().append(',');
                }
                first = false;
                ctx.getSql().append(' ');
                selectExpression.renderQueryFragment(ctx);
            }
        }
        this.from.renderQueryFragment(ctx);
        if (this.where != null) {
            this.where.renderQueryFragment(ctx);
        }
        if (this.orderBy != null) {
            this.orderBy.renderQueryFragment(ctx);
        }
        if (this.limit != null) {
            ctx.getSql().append(" LIMIT ?");
            ctx.getArgs().add(this.limit);
            ctx.getArgumentSetters().add(new PreparedStatementArgumentSetter(){

                public void set(int index, PreparedStatement ps) throws SQLException {
                    ps.setLong(index, SelectImpl.this.limit);
                }
            });
            if (this.offset != null) {
                ctx.getSql().append(" OFFSET ?");
                ctx.getArgs().add(this.offset);
                ctx.getArgumentSetters().add(new PreparedStatementArgumentSetter(){

                    public void set(int index, PreparedStatement ps) throws SQLException {
                        ps.setLong(index, SelectImpl.this.offset);
                    }
                });
            }
        }
    }

    public SelectExpression expression() {
        this.selectAll = false;
        SelectExpressionImpl expr = new SelectExpressionImpl(this.getQueryContext(), this.getVendorConfiguration());
        this.selectExpressions.add(expr);
        return expr;
    }

    public Select all() {
        this.selectAll = true;
        this.selectExpressions.clear();
        return this;
    }

    public Select count() {
        this.selectAll = false;
        this.selectExpressions.clear();
        this.expression().count();
        return this;
    }

    public From from() {
        this.from = new FromImpl(this.getQueryContext(), this.getVendorConfiguration());
        return this.from;
    }

    public Where where() {
        this.where = new WhereImpl(this.getQueryContext(), this.getVendorConfiguration());
        return this.where;
    }

    public OrderBy orderBy() {
        this.orderBy = new OrderByImpl(this.getQueryContext(), this.getVendorConfiguration());
        return this.orderBy;
    }

    public Select offset(Long offset) {
        this.offset = offset;
        return this;
    }

    public Select limit(Long limit) {
        this.limit = limit;
        return this;
    }
}

