/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bndly.schema.api.PreparedStatementArgumentSetter;
import org.bndly.schema.api.ValueUtil;
import org.bndly.schema.api.query.PreparedStatementValueProvider;
import org.bndly.schema.api.query.Query;
import org.bndly.schema.api.query.QueryRenderContext;
import org.bndly.schema.api.query.QueryValueProvider;
import org.bndly.schema.api.query.Update;
import org.bndly.schema.api.query.ValueProvider;
import org.bndly.schema.api.query.Where;
import org.bndly.schema.impl.QueryContextImpl;
import org.bndly.schema.impl.query.ContextRelatedQueryComponentImpl;
import org.bndly.schema.impl.query.KeyValue;
import org.bndly.schema.impl.query.WhereImpl;
import org.bndly.schema.vendor.VendorConfiguration;

public class UpdateImpl
extends ContextRelatedQueryComponentImpl
implements Update {
    private String tableName;
    private final List<KeyValue> values = new ArrayList<KeyValue>();
    private Where where;

    public UpdateImpl(QueryContextImpl queryContext, VendorConfiguration vendorConfiguration) {
        super(queryContext, vendorConfiguration);
    }

    public Update table(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Update set(String columnName, ValueProvider value) {
        return this._set(columnName, value, null, false);
    }

    public Update set(String columnName, ValueProvider value, int sqlType) {
        return this._set(columnName, value, sqlType, false);
    }

    public Update setNull(String columnName, int sqlType) {
        return this._set(columnName, ValueProvider.NULL, sqlType, true);
    }

    private Update _set(String columnName, ValueProvider value, Integer sqlType, boolean allowNull) {
        if (value != null || allowNull) {
            PreparedStatementArgumentSetter argumentSetter = PreparedStatementArgumentSetter.class.isInstance(value) ? (PreparedStatementArgumentSetter)value : this.createFallbackPreparedStatementArgumentSetter(value, sqlType);
            this.values.add(new KeyValue(columnName, value, sqlType, argumentSetter));
        }
        return this;
    }

    public Where where() {
        this.where = new WhereImpl(this.getQueryContext(), this.getVendorConfiguration());
        return this.where;
    }

    public void renderQueryFragment(QueryRenderContext ctx) {
        ctx.getSql().append("UPDATE ");
        ctx.getSql().append(this.tableName);
        ctx.getSql().append(" SET ");
        boolean first = true;
        for (KeyValue kv : this.values) {
            if (!first) {
                ctx.getSql().append(',');
            }
            first = false;
            ctx.getSql().append(kv.getKey());
            ctx.getSql().append('=');
            ValueProvider valueProvider = kv.getValue();
            if (QueryValueProvider.class.isInstance(valueProvider)) {
                QueryValueProvider qvp = (QueryValueProvider)valueProvider;
                Query nestedQuery = qvp.get();
                ctx.getSql().append('(').append(nestedQuery.getSql()).append(')');
                ctx.getArgs().addAll(Arrays.asList(nestedQuery.getArgs()));
                ctx.getArgumentSetters().addAll(Arrays.asList(nestedQuery.getArgumentSetters()));
                continue;
            }
            if (PreparedStatementValueProvider.class.isInstance(valueProvider)) {
                PreparedStatementValueProvider psvp = (PreparedStatementValueProvider)valueProvider;
                ctx.getSql().append('?');
                ValueUtil.appendToArgs((QueryRenderContext)ctx, null);
                ctx.getArgumentSetters().add(psvp);
                continue;
            }
            Object value = valueProvider.get();
            ctx.getSql().append('?');
            ValueUtil.appendToArgs((QueryRenderContext)ctx, (Object)value);
            ctx.getArgumentSetters().add(kv.getArgumentSetter());
        }
        if (this.where != null) {
            this.where.renderQueryFragment(ctx);
        }
    }
}

