/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import org.bndly.schema.api.repository.RepositoryException;

public final class IndexManager {
    private Long nextChildIndex;
    private final IndexContext indexContext;

    public IndexManager(IndexContext indexContext) {
        if (indexContext == null) {
            throw new IllegalArgumentException("indexContext is not allowed to be null");
        }
        this.indexContext = indexContext;
    }

    public long pullNextChildIndex() throws RepositoryException {
        if (this.nextChildIndex == null) {
            if (this.indexContext.isTransient()) {
                this.nextChildIndex = 1L;
                return 0L;
            }
            this.nextChildIndex = this.indexContext.countChildren() + 1L;
            return this.nextChildIndex - 1L;
        }
        long index = this.nextChildIndex;
        Long l = this.nextChildIndex;
        Long l2 = this.nextChildIndex = Long.valueOf(this.nextChildIndex + 1L);
        return index;
    }

    public static interface IndexContext {
        public boolean isTransient();

        public long countChildren() throws RepositoryException;
    }
}

