/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.util.Iterator;
import java.util.List;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.repository.ModificationNotAllowedException;
import org.bndly.schema.api.repository.Node;
import org.bndly.schema.api.repository.NodeNotFoundException;
import org.bndly.schema.api.repository.Path;
import org.bndly.schema.api.repository.PathBuilder;
import org.bndly.schema.api.repository.Property;
import org.bndly.schema.api.repository.PropertyNotFoundException;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositoryListener;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.repository.AbstractRepositoryItem;
import org.bndly.schema.impl.repository.IndexManager;
import org.bndly.schema.impl.repository.PropertyImpl;
import org.bndly.schema.impl.repository.RepositorySessionImpl;
import org.bndly.schema.impl.repository.SortedKeyedIndex;

public class NodeImpl
extends AbstractRepositoryItem
implements Node,
IndexManager.IndexContext {
    private final NodeImpl parent;
    private final String nodeName;
    private final String type;
    private final Path path;
    private final IndexManager nodeIndexManager;
    private final IndexManager propertyIndexManager;
    private final SortedKeyedIndex<String, NodeImpl> children;
    private final SortedKeyedIndex<String, PropertyImpl> properties;
    private long index;

    public static NodeImpl createRootNode(RecordContext ctx, RepositorySessionImpl repository, Engine engine) {
        return new NodeImpl("cy:root", PathBuilder.newInstance().build(), ctx, repository, engine);
    }

    private NodeImpl(String type, Path path, RecordContext ctx, RepositorySessionImpl repository, Engine engine) {
        super(repository, engine, ctx);
        this.parent = null;
        this.path = path;
        List elementNames = path.getElementNames();
        String string = this.nodeName = elementNames.isEmpty() ? "" : (String)elementNames.get(elementNames.size() - 1);
        if (type == null) {
            throw new IllegalArgumentException("type is not allowed to be null");
        }
        this.type = type;
        this.nodeIndexManager = new IndexManager(this);
        this.propertyIndexManager = new IndexManager(this.createPropertyIndexManagingItem());
        this.index = 0L;
        this.children = this.createChildrenIndex();
        this.properties = this.createPropertiesIndex();
    }

    public NodeImpl(NodeImpl parent, String type, Path path, RecordContext ctx, RepositorySessionImpl repository, Record record, Engine engine) {
        super(repository, record, engine, ctx);
        this.parent = parent;
        List elementNames = path.getElementNames();
        this.nodeName = elementNames.isEmpty() ? "" : (String)elementNames.get(elementNames.size() - 1);
        this.path = path;
        if (type == null) {
            throw new IllegalArgumentException("type is not allowed to be null");
        }
        this.type = type;
        this.nodeIndexManager = new IndexManager(this);
        this.propertyIndexManager = new IndexManager(this.createPropertyIndexManagingItem());
        this.index = (Long)record.getAttributeValue("parentIndex", Long.class);
        this.children = this.createChildrenIndex();
        this.properties = this.createPropertiesIndex();
    }

    private SortedKeyedIndex<String, NodeImpl> createChildrenIndex() {
        final NodeImpl that = this;
        return new SortedKeyedIndex<String, NodeImpl>(){

            @Override
            protected boolean isTransient() {
                return that.isTransient();
            }

            @Override
            protected boolean isRemovalOfItemScheduled(NodeImpl item) {
                return item.isRemovalScheduled();
            }

            @Override
            protected Iterator<Record> performItemsQuery() {
                return NodeImpl.this.getAccessor().query("PICK Node n IF n.parent.id=? ORDERBY n.parentIndex", NodeImpl.this.getRecordContext(), null, new Object[]{NodeImpl.this.getRecord() == null ? null : NodeImpl.this.getRecord().getId()});
            }

            @Override
            protected Iterator<Record> performItemQueryByKey(String key) {
                return NodeImpl.this.getAccessor().query("PICK Node n IF n.name=? AND n.parent.id=? LIMIT ?", NodeImpl.this.getRecordContext(), null, new Object[]{key, NodeImpl.this.getRecord() == null ? null : NodeImpl.this.getRecord().getId(), 1});
            }

            @Override
            protected NodeImpl wrapItemRecord(Record record) {
                String name = (String)record.getAttributeValue("name", String.class);
                Path childPath = PathBuilder.newInstance((Path)NodeImpl.this.path).element(name).build();
                NodeImpl current = NodeImpl.this.createNodeInstance(that, childPath, record);
                return current;
            }

            @Override
            protected String getKeyOfItem(NodeImpl item) {
                return item.getName();
            }

            @Override
            protected NodeImpl setIndexOfItem(NodeImpl item, long index) throws RepositoryException {
                item.setIndex(index);
                return item;
            }

            @Override
            protected void throwItemNotFoundException(String keyOfItem) throws RepositoryException {
                throw new NodeNotFoundException("could not find node at " + NodeImpl.this.path.toString() + "/" + keyOfItem);
            }

            @Override
            protected void testMovePreconditions(NodeImpl item, long index) throws RepositoryException {
                if (NodeImpl.this.isReadOnly()) {
                    throw new ModificationNotAllowedException("nodex can not be moved in read only sessions");
                }
                if (item.getParent() != that) {
                    throw new RepositoryException("provided node is not owned by this node");
                }
            }

            @Override
            protected Long countItemsInPersistenceLayer() {
                return NodeImpl.this.getAccessor().count("COUNT Node n IF n.parent.id=?", new Object[]{NodeImpl.this.getRecord() == null ? null : NodeImpl.this.getRecord().getId()});
            }
        };
    }

    private SortedKeyedIndex<String, PropertyImpl> createPropertiesIndex() {
        final NodeImpl that = this;
        return new SortedKeyedIndex<String, PropertyImpl>(){

            @Override
            protected boolean isTransient() {
                return that.isTransient();
            }

            @Override
            protected boolean isRemovalOfItemScheduled(PropertyImpl item) {
                return item.isRemovalScheduled();
            }

            @Override
            protected Iterator<Record> performItemsQuery() {
                return NodeImpl.this.getAccessor().query("PICK Property p IF p.node.id=? ORDERBY p.parentIndex", NodeImpl.this.getRecordContext(), null, new Object[]{NodeImpl.this.getRecord() == null ? null : NodeImpl.this.getRecord().getId()});
            }

            @Override
            protected Iterator<Record> performItemQueryByKey(String key) {
                return NodeImpl.this.getAccessor().query("PICK Property p IF p.node.id=? AND p.name=? LIMIT ?", NodeImpl.this.getRecordContext(), null, new Object[]{NodeImpl.this.getRecord() == null ? null : NodeImpl.this.getRecord().getId(), key, 1});
            }

            @Override
            protected PropertyImpl wrapItemRecord(Record record) {
                return NodeImpl.this.createPropertyInstance(record);
            }

            @Override
            protected String getKeyOfItem(PropertyImpl item) {
                return item.getName();
            }

            @Override
            protected PropertyImpl setIndexOfItem(PropertyImpl item, long index) throws RepositoryException {
                item.setIndex(index);
                return item;
            }

            @Override
            protected void testMovePreconditions(PropertyImpl item, long index) throws RepositoryException {
                if (NodeImpl.this.isReadOnly()) {
                    throw new ModificationNotAllowedException("properties can not be moved in read only sessions");
                }
                if (item.getNode() != that) {
                    throw new RepositoryException("provided property is not owned by this node");
                }
            }

            @Override
            protected void throwItemNotFoundException(String keyOfItem) throws RepositoryException {
                throw new PropertyNotFoundException("could not find property " + keyOfItem + " at node " + NodeImpl.this.getPath().toString());
            }

            @Override
            protected Long countItemsInPersistenceLayer() {
                return NodeImpl.this.getAccessor().count("COUNT Property p IF p.node.id=?", new Object[]{NodeImpl.this.getRecord() == null ? null : NodeImpl.this.getRecord().getId()});
            }
        };
    }

    private IndexManager.IndexContext createPropertyIndexManagingItem() {
        final NodeImpl that = this;
        return new IndexManager.IndexContext(){

            @Override
            public boolean isTransient() {
                return that.isTransient();
            }

            @Override
            public long countChildren() throws RepositoryException {
                return NodeImpl.this.getPropertyCount();
            }
        };
    }

    public NodeImpl getParent() throws RepositoryException {
        return this.parent;
    }

    public String getName() {
        return this.nodeName;
    }

    public String getType() {
        return this.type;
    }

    public Path getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeImpl createChild(String name, String type) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("nodes can not be created in read only sessions");
        }
        name = PathBuilder.filterUnallowedIndentifierChars((String)name);
        this.children.testKeyUniqueness(name);
        Record childNodeRecord = this.getRecordContext().create("Node");
        if (this.getRecord() != null) {
            childNodeRecord.setAttributeValue("parent", (Object)this.getRecord());
        }
        childNodeRecord.setAttributeValue("name", (Object)name);
        childNodeRecord.setAttributeValue("nodeType", (Object)type);
        childNodeRecord.setAttributeValue("parentIndex", (Object)this.nodeIndexManager.pullNextChildIndex());
        Path childPath = PathBuilder.newInstance((Path)this.getPath()).element(name).build();
        NodeImpl childNode = this.createNodeInstance(this, childPath, childNodeRecord);
        this.children.retain(childNode);
        childNode.createPersist(this);
        this.getRepositoryListenersLock().readLock().lock();
        try {
            for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                repositoryListener.onNodeCreated((Node)childNode);
            }
        }
        finally {
            this.getRepositoryListenersLock().readLock().unlock();
        }
        return childNode;
    }

    @Override
    public long countChildren() throws RepositoryException {
        return this.children.countItemsInPersistenceLayer();
    }

    private NodeImpl createNodeInstance(NodeImpl parent, Path path, Record nodeRecord) {
        String type = (String)nodeRecord.getAttributeValue("nodeType", String.class);
        return new NodeImpl(parent, type, path, this.getRecordContext(), super.getRepositorySession(), nodeRecord, this.getEngine());
    }

    public Iterator<Node> getChildren() throws RepositoryException {
        return this.children.getItems();
    }

    public Node getChild(String name) throws RepositoryException {
        return this.children.getItem(name);
    }

    public Iterator<Property> getProperties() throws RepositoryException {
        return this.properties.getItems();
    }

    public Property getProperty(String name) throws RepositoryException {
        return this.properties.getItem(name);
    }

    public boolean isHavingProperty(String name) throws RepositoryException {
        try {
            Property prop = this.getProperty(name);
            return prop != null;
        }
        catch (PropertyNotFoundException e) {
            return false;
        }
    }

    public Property createProperty(String name, Property.Type type) throws RepositoryException {
        return this.createPropertyInternal(name, type, false);
    }

    public Property createMultiProperty(String name, Property.Type type) throws RepositoryException {
        return this.createPropertyInternal(name, type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Property createPropertyInternal(String name, Property.Type type, boolean multiValue) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("properties can not be created in read only sessions");
        }
        name = PathBuilder.filterUnallowedIndentifierChars((String)name);
        this.properties.testNewItemInMemoryUniqueness(name);
        if (type == null) {
            throw new RepositoryException("type is not allowed to be null");
        }
        Record propertyRecord = this.getRecordContext().create("Property");
        propertyRecord.setAttributeValue("type", (Object)type.toString());
        propertyRecord.setAttributeValue("name", (Object)name);
        propertyRecord.setAttributeValue("parentIndex", (Object)this.propertyIndexManager.pullNextChildIndex());
        propertyRecord.setAttributeValue("isMultiValued", (Object)multiValue);
        propertyRecord.setAttributeValue("node", (Object)this.getRecord());
        PropertyImpl property = this.createPropertyInstance(propertyRecord);
        this.properties.retain(property);
        property.createPersist(this);
        this.getRepositoryListenersLock().readLock().lock();
        try {
            for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                repositoryListener.onPropertyCreated((Property)property);
            }
        }
        finally {
            this.getRepositoryListenersLock().readLock().unlock();
        }
        return property;
    }

    private PropertyImpl createPropertyInstance(Record propertyRecord) {
        String name = (String)propertyRecord.getAttributeValue("name", String.class);
        Property.Type propertyType = Property.Type.valueOf((String)((String)propertyRecord.getAttributeValue("type", String.class)));
        Boolean tmp = (Boolean)propertyRecord.getAttributeValue("isMultiValued", Boolean.class);
        boolean multiValued = tmp == null ? false : tmp;
        return new PropertyImpl(propertyType, name, this, multiValued, super.getRepositorySession(), propertyRecord, this.getEngine(), this.getRecordContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("nodes can not be removed in read only sessions");
        }
        Record rec = this.getRecord();
        if (rec == null) {
            throw new RepositoryException("root node can not be removed");
        }
        this.createRemovable(this.parent);
        this.getRepositoryListenersLock().readLock().lock();
        try {
            for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                repositoryListener.onNodeRemoved((Node)this);
            }
        }
        finally {
            this.getRepositoryListenersLock().readLock().unlock();
        }
    }

    @Override
    protected void afterRemove() {
        if (this.parent == null) {
            return;
        }
        this.parent.children.drop(this);
    }

    public void dropProperty(PropertyImpl property) {
        this.properties.drop(property);
    }

    public long getPropertyCount() {
        return this.properties.getItemCount();
    }

    public void moveNodeToIndex(NodeImpl node, long index) throws RepositoryException {
        this.children.moveItemToIndex(node, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToIndex(long index) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("nodes can not be moved in read only sessions");
        }
        if (this.getRecord() == null) {
            throw new ModificationNotAllowedException("root node can not be moved");
        }
        this.getParent().moveNodeToIndex(this, index);
        this.getRepositoryListenersLock().readLock().lock();
        try {
            for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                repositoryListener.onNodeMoved((Node)this, index);
            }
        }
        finally {
            this.getRepositoryListenersLock().readLock().unlock();
        }
    }

    public void movePropertyToIndex(PropertyImpl property, long index) throws RepositoryException {
        this.properties.moveItemToIndex(property, index);
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("properties can not be moved in read only sessions");
        }
        if (this.getRecord() == null) {
            throw new ModificationNotAllowedException("the root node has no index");
        }
        if (index != this.index) {
            this.index = index;
            this.getRecord().setAttributeValue("parentIndex", (Object)index);
            if (!this.isTransient()) {
                this.createPersist(this.getParent());
            }
        }
    }
}

