/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bndly.common.data.io.IOUtils;
import org.bndly.schema.api.repository.PackageExporter;
import org.bndly.schema.api.repository.PackageImporter;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositoryExporter;
import org.bndly.schema.api.repository.RepositoryImporter;
import org.bndly.schema.api.repository.RepositorySession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={PackageImporter.class, PackageExporter.class})
@Designate(ocd=Configuration.class)
public class PackageImporterImpl
implements PackageImporter,
PackageExporter {
    @Reference
    private RepositoryImporter repositoryImporter;
    @Reference
    private RepositoryExporter repositoryExporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importRepositoryData(InputStream packageData, RepositorySession repositorySession) throws RepositoryException, IOException {
        String uuid = UUID.randomUUID().toString();
        Path tempDirectory = Files.createTempDirectory(uuid, new FileAttribute[0]);
        byte[] buffer = new byte[1024];
        try {
            try (ZipInputStream zipInputStream = new ZipInputStream(packageData);){
                ZipEntry currentEntry;
                while ((currentEntry = zipInputStream.getNextEntry()) != null) {
                    String entryName = currentEntry.getName();
                    boolean isDirectory = currentEntry.isDirectory();
                    Path entryPath = tempDirectory.resolve(entryName);
                    if (isDirectory) {
                        Files.createDirectory(entryPath, new FileAttribute[0]);
                        continue;
                    }
                    Files.createFile(entryPath, new FileAttribute[0]);
                    long entrySize = currentEntry.getSize();
                    OutputStream os = Files.newOutputStream(entryPath, StandardOpenOption.WRITE);
                    try {
                        if (entrySize > -1L) {
                            IOUtils.copy((InputStream)zipInputStream, (OutputStream)os, (long)entrySize, (byte[])buffer);
                        } else {
                            IOUtils.copy((InputStream)zipInputStream, (OutputStream)os, (byte[])buffer);
                        }
                        os.flush();
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
            }
            this.repositoryImporter.importRepositoryData(tempDirectory.resolve("root.json"), repositorySession);
            return;
        }
        finally {
            this.deleteDirectory(tempDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportRepositoryData(OutputStream target, RepositorySession repositorySession) throws RepositoryException, IOException {
        String uuid = UUID.randomUUID().toString();
        final byte[] buffer = new byte[1024];
        final Path tempDirectory = Files.createTempDirectory(uuid, new FileAttribute[0]);
        try {
            this.repositoryExporter.exportRepositoryData(tempDirectory, repositorySession);
            try (final ZipOutputStream zos = new ZipOutputStream(target);){
                Files.walkFileTree(tempDirectory, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path rel = tempDirectory.relativize(dir);
                        if (rel.toString().isEmpty()) {
                            return FileVisitResult.CONTINUE;
                        }
                        ZipEntry e = new ZipEntry(rel.toString() + "/");
                        zos.putNextEntry(e);
                        zos.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path rel = tempDirectory.relativize(file);
                        ZipEntry e = new ZipEntry(rel.toString());
                        long size = file.toFile().length();
                        if (size > 0L) {
                            e.setSize(size);
                        }
                        zos.putNextEntry(e);
                        try (InputStream is = Files.newInputStream(file, StandardOpenOption.READ);){
                            if (size > 0L) {
                                IOUtils.copy((InputStream)is, (OutputStream)zos, (long)size, (byte[])buffer);
                            } else {
                                IOUtils.copy((InputStream)is, (OutputStream)zos, (byte[])buffer);
                            }
                        }
                        zos.closeEntry();
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        Files.deleteIfExists(file);
                        return FileVisitResult.TERMINATE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
                zos.finish();
            }
        }
        finally {
            this.deleteDirectory(tempDirectory);
        }
    }

    private void deleteDirectory(Path toDelete) throws IOException {
        Files.walkFileTree(toDelete, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        Files.deleteIfExists(toDelete);
    }

    public void setRepositoryImporter(RepositoryImporter repositoryImporter) {
        this.repositoryImporter = repositoryImporter;
    }

    public void setRepositoryExporter(RepositoryExporter repositoryExporter) {
        this.repositoryExporter = repositoryExporter;
    }

    @ObjectClassDefinition(name="Package Importer", description="This importer imports node packages into a repository")
    public static @interface Configuration {
    }
}

