/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.repository.ModificationNotAllowedException;
import org.bndly.schema.api.repository.Property;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositoryListener;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.repository.AbstractRepositoryItem;
import org.bndly.schema.impl.repository.IndexManager;
import org.bndly.schema.impl.repository.NodeImpl;
import org.bndly.schema.impl.repository.RepositorySessionImpl;
import org.bndly.schema.impl.repository.Value;

public class PropertyImpl
extends AbstractRepositoryItem
implements Property,
IndexManager.IndexContext {
    private final Property.Type type;
    private final String name;
    private final NodeImpl owner;
    private final boolean multiValued;
    private final IndexManager valueIndexManager;
    private long index;
    private boolean didLoadValues;
    private List<Value> values;
    private Value value;

    public PropertyImpl(Property.Type type, String name, NodeImpl owner, boolean multiValued, RepositorySessionImpl repository, Record record, Engine engine, RecordContext ctx) {
        super(repository, record, engine, ctx);
        if (type == null) {
            throw new IllegalArgumentException("type is not allowed to be null");
        }
        this.type = type;
        if (name == null) {
            throw new IllegalArgumentException("name is not allowed to be null");
        }
        this.name = name;
        if (owner == null) {
            throw new IllegalArgumentException("owner is not allowed to be null");
        }
        this.owner = owner;
        this.multiValued = multiValued;
        this.valueIndexManager = new IndexManager(this);
        this.index = (Long)record.getAttributeValue("parentIndex", Long.class);
    }

    public Property.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public NodeImpl getNode() {
        return this.owner;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public String getString() {
        this.loadValues();
        if (this.getType() != Property.Type.STRING) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            return (String)this.values.get(0).getValue();
        }
        if (this.value == null) {
            return null;
        }
        return (String)this.value.getValue();
    }

    public String[] getStrings() {
        this.loadValues();
        if (this.getType() != Property.Type.STRING) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            String[] strings = new String[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                Value get = this.values.get(i);
                strings[i] = (String)get.getValue();
            }
            return strings;
        }
        if (this.value == null) {
            return null;
        }
        return new String[]{(String)this.value.getValue()};
    }

    public Date getDate() {
        this.loadValues();
        if (this.getType() != Property.Type.DATE) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            return (Date)this.values.get(0).getValue();
        }
        if (this.value == null) {
            return null;
        }
        return (Date)this.value.getValue();
    }

    public Date[] getDates() {
        this.loadValues();
        if (this.getType() != Property.Type.DATE) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            Date[] strings = new Date[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                Value get = this.values.get(i);
                strings[i] = (Date)get.getValue();
            }
            return strings;
        }
        if (this.value == null) {
            return null;
        }
        return new Date[]{(Date)this.value.getValue()};
    }

    public BigDecimal getDecimal() {
        this.loadValues();
        if (this.getType() != Property.Type.DECIMAL) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            return (BigDecimal)this.values.get(0).getValue();
        }
        if (this.value == null) {
            return null;
        }
        return (BigDecimal)this.value.getValue();
    }

    public BigDecimal[] getDecimals() {
        this.loadValues();
        if (this.getType() != Property.Type.DECIMAL) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            BigDecimal[] strings = new BigDecimal[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                Value get = this.values.get(i);
                strings[i] = (BigDecimal)get.getValue();
            }
            return strings;
        }
        if (this.value == null) {
            return null;
        }
        return new BigDecimal[]{(BigDecimal)this.value.getValue()};
    }

    public Long getLong() {
        this.loadValues();
        if (this.getType() != Property.Type.LONG) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            return (Long)this.values.get(0).getValue();
        }
        if (this.value == null) {
            return null;
        }
        return (Long)this.value.getValue();
    }

    public Long[] getLongs() {
        this.loadValues();
        if (this.getType() != Property.Type.LONG) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            Long[] longs = new Long[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                Value get = this.values.get(i);
                longs[i] = (Long)get.getValue();
            }
            return longs;
        }
        if (this.value == null) {
            return null;
        }
        return new Long[]{(Long)this.value.getValue()};
    }

    public Double getDouble() {
        this.loadValues();
        if (this.getType() != Property.Type.DOUBLE) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            return (Double)this.values.get(0).getValue();
        }
        if (this.value == null) {
            return null;
        }
        return (Double)this.value.getValue();
    }

    public Double[] getDoubles() {
        this.loadValues();
        if (this.getType() != Property.Type.DOUBLE) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            Double[] doubles = new Double[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                Value get = this.values.get(i);
                doubles[i] = (Double)get.getValue();
            }
            return doubles;
        }
        if (this.value == null) {
            return null;
        }
        return new Double[]{(Double)this.value.getValue()};
    }

    public Boolean getBoolean() {
        this.loadValues();
        if (this.getType() != Property.Type.BOOLEAN) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            return (Boolean)this.values.get(0).getValue();
        }
        if (this.value == null) {
            return null;
        }
        return (Boolean)this.value.getValue();
    }

    public Boolean[] getBooleans() {
        this.loadValues();
        if (this.getType() != Property.Type.BOOLEAN) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            Boolean[] strings = new Boolean[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                Value get = this.values.get(i);
                strings[i] = (Boolean)get.getValue();
            }
            return strings;
        }
        if (this.value == null) {
            return null;
        }
        return new Boolean[]{(Boolean)this.value.getValue()};
    }

    public InputStream getBinary() {
        this.loadValues();
        if (this.getType() != Property.Type.BINARY) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            return (InputStream)this.values.get(0).getValue();
        }
        if (this.value == null) {
            return null;
        }
        return (InputStream)this.value.getValue();
    }

    public InputStream[] getBinaries() {
        this.loadValues();
        if (this.getType() != Property.Type.BINARY) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            InputStream[] strings = new InputStream[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                Value get = this.values.get(i);
                strings[i] = (InputStream)get.getValue();
            }
            return strings;
        }
        if (this.value == null) {
            return null;
        }
        return new InputStream[]{(InputStream)this.value.getValue()};
    }

    public Record getEntity() {
        this.loadValues();
        if (this.getType() != Property.Type.ENTITY) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            return (Record)this.values.get(0).getValue();
        }
        if (this.value == null) {
            return null;
        }
        return (Record)this.value.getValue();
    }

    public Record[] getEntities() {
        this.loadValues();
        if (this.getType() != Property.Type.ENTITY) {
            return null;
        }
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            Record[] strings = new Record[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                Value get = this.values.get(i);
                strings[i] = (Record)get.getValue();
            }
            return strings;
        }
        if (this.value == null) {
            return null;
        }
        return new Record[]{(Record)this.value.getValue()};
    }

    private void loadValues() {
        if (this.didLoadValues) {
            return;
        }
        if (this.getRecord().getId() == null) {
            return;
        }
        Iterator valuesIter = this.isMultiValued() ? this.getAccessor().query("PICK Value v IF v.property.id=? ORDERBY v.parentIndex", new Object[]{this.getRecord().getId()}) : this.getAccessor().query("PICK Value v IF v.property.id=? LIMIT ?", new Object[]{this.getRecord().getId(), 1});
        this.didLoadValues = true;
        if (this.isMultiValued()) {
            this.values = new ArrayList<Value>();
            while (valuesIter.hasNext()) {
                Record valueRecord = (Record)valuesIter.next();
                this.values.add(new Value(this, super.getRepositorySession(), valueRecord, this.getEngine(), this.getRecordContext()));
            }
        } else if (valuesIter.hasNext()) {
            Record valueRecord = (Record)valuesIter.next();
            this.value = new Value(this, super.getRepositorySession(), valueRecord, this.getEngine(), this.getRecordContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object rawValue) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("values can not be set in read only sessions");
        }
        this.loadValues();
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                Record valueRecord = this.getRecordContext().create("Value");
                valueRecord.setAttributeValue("property", (Object)this.getRecord());
                valueRecord.setAttributeValue("parentIndex", (Object)0L);
                this.value = new Value(this, super.getRepositorySession(), valueRecord, this.getEngine(), this.getRecordContext());
                this.value.setValue(rawValue);
                this.value.createPersist(this);
                this.getRepositoryListenersLock().readLock().lock();
                try {
                    for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                        repositoryListener.onPropertyChanged((Property)this);
                    }
                }
                finally {
                    this.getRepositoryListenersLock().readLock().unlock();
                }
            } else {
                Value tmpValue = this.values.get(0);
                tmpValue.setValue(rawValue);
                tmpValue.createPersist(this);
                Iterator<Value> iter = this.values.iterator();
                while (iter.hasNext()) {
                    Value next = iter.next();
                    if (next == tmpValue) continue;
                    next.createRemovable(this);
                    iter.remove();
                }
                this.getRepositoryListenersLock().readLock().lock();
                try {
                    for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                        repositoryListener.onPropertyChanged((Property)this);
                    }
                }
                finally {
                    this.getRepositoryListenersLock().readLock().unlock();
                }
            }
        } else {
            if (this.value == null) {
                Record valueRecord = this.getRecordContext().create("Value");
                valueRecord.setAttributeValue("property", (Object)this.getRecord());
                valueRecord.setAttributeValue("parentIndex", (Object)0L);
                this.value = new Value(this, super.getRepositorySession(), valueRecord, this.getEngine(), this.getRecordContext());
            }
            this.value.setValue(rawValue);
            this.value.createPersist(this);
            this.getRepositoryListenersLock().readLock().lock();
            try {
                for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                    repositoryListener.onPropertyChanged((Property)this);
                }
            }
            finally {
                this.getRepositoryListenersLock().readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int index, Object rawValue) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("values can not be set in read only sessions");
        }
        if (!this.isMultiValued()) {
            throw new ModificationNotAllowedException("setValue with index can only be used on multivalued properties");
        }
        this.loadValues();
        if (this.values == null || this.values.isEmpty()) {
            this.values = new ArrayList<Value>(index + 1);
        } else if (this.values.size() <= index) {
            ArrayList<Value> copy = new ArrayList<Value>(index + 1);
            copy.addAll(this.values);
            this.values = copy;
        }
        Value valueItem = this.values.get(index);
        if (valueItem == null) {
            Record valueRecord = this.getRecordContext().create("Value");
            valueRecord.setAttributeValue("property", (Object)this.getRecord());
            valueRecord.setAttributeValue("parentIndex", (Object)index);
            valueItem = new Value(this, super.getRepositorySession(), valueRecord, this.getEngine(), this.getRecordContext());
            valueItem.setValue(rawValue);
        } else {
            valueItem.setValue(rawValue);
        }
        valueItem.createPersist(this);
        this.getRepositoryListenersLock().readLock().lock();
        try {
            for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                repositoryListener.onPropertyChanged((Property)this);
            }
        }
        finally {
            this.getRepositoryListenersLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Object ... rawValues) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("values can not be set in read only sessions");
        }
        this.loadValues();
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                this.values = new ArrayList<Value>(rawValues.length);
                for (int i = 0; i < rawValues.length; ++i) {
                    Object rawValue = rawValues[i];
                    Record valueRecord = this.getRecordContext().create("Value");
                    valueRecord.setAttributeValue("property", (Object)this.getRecord());
                    valueRecord.setAttributeValue("parentIndex", (Object)i);
                    Value v = new Value(this, super.getRepositorySession(), valueRecord, this.getEngine(), this.getRecordContext());
                    v.setValue(rawValue);
                    v.createPersist(this);
                    this.values.add(v);
                }
                this.getRepositoryListenersLock().readLock().lock();
                try {
                    for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                        repositoryListener.onPropertyChanged((Property)this);
                    }
                }
                finally {
                    this.getRepositoryListenersLock().readLock().unlock();
                }
            } else {
                int i = 0;
                Iterator<Value> it = this.values.iterator();
                while (it.hasNext()) {
                    Value next = it.next();
                    if (rawValues.length > i) {
                        next.setValue(rawValues[i]);
                        next.createPersist(this);
                    } else {
                        it.remove();
                        next.createRemovable(this);
                    }
                    ++i;
                }
                if (i < rawValues.length) {
                    for (int j = i; j < rawValues.length; ++j) {
                        Record valueRecord = this.getRecordContext().create("Value");
                        valueRecord.setAttributeValue("property", (Object)this.getRecord());
                        valueRecord.setAttributeValue("parentIndex", (Object)this.valueIndexManager.pullNextChildIndex());
                        Value v = new Value(this, super.getRepositorySession(), valueRecord, this.getEngine(), this.getRecordContext());
                        v.setValue(rawValues[j]);
                        v.createPersist(this);
                        this.values.add(v);
                    }
                }
                this.getRepositoryListenersLock().readLock().lock();
                try {
                    for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                        repositoryListener.onPropertyChanged((Property)this);
                    }
                }
                finally {
                    this.getRepositoryListenersLock().readLock().unlock();
                }
            }
        } else {
            if (rawValues.length > 1) {
                throw new IllegalArgumentException("setting more than one value for a single valued property");
            }
            this.setValue(rawValues[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(Object rawValue) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("values can not be added in read only sessions");
        }
        this.loadValues();
        if (this.isMultiValued()) {
            if (this.values == null || this.values.isEmpty()) {
                this.values = new ArrayList<Value>();
            }
            Record valueRecord = this.getRecordContext().create("Value");
            valueRecord.setAttributeValue("property", (Object)this.getRecord());
            valueRecord.setAttributeValue("parentIndex", (Object)this.valueIndexManager.pullNextChildIndex());
            Value v = new Value(this, super.getRepositorySession(), valueRecord, this.getEngine(), this.getRecordContext());
            v.setValue(rawValue);
            v.createPersist(this);
            this.values.add(v);
            this.getRepositoryListenersLock().readLock().lock();
            try {
                for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                    repositoryListener.onPropertyChanged((Property)this);
                }
            }
            finally {
                this.getRepositoryListenersLock().readLock().unlock();
            }
        } else {
            this.setValue(rawValue);
        }
    }

    @Override
    protected void afterRemove() {
        this.owner.dropProperty(this);
    }

    @Override
    public void remove() throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("properties can not be removed in read only sessions");
        }
        this.createRemovable(this.owner);
        this.getRepositoryListenersLock().readLock().lock();
        try {
            for (RepositoryListener repositoryListener : this.getRepositoryListeners()) {
                repositoryListener.onPropertyRemoved((Property)this);
            }
        }
        finally {
            this.getRepositoryListenersLock().readLock().unlock();
        }
    }

    public Object getValue() {
        if (this.getType() == Property.Type.STRING) {
            return this.getString();
        }
        if (this.getType() == Property.Type.DECIMAL) {
            return this.getDecimal();
        }
        if (this.getType() == Property.Type.LONG) {
            return this.getLong();
        }
        if (this.getType() == Property.Type.DOUBLE) {
            return this.getDouble();
        }
        if (this.getType() == Property.Type.DATE) {
            return this.getDate();
        }
        if (this.getType() == Property.Type.BOOLEAN) {
            return this.getBoolean();
        }
        if (this.getType() == Property.Type.BINARY) {
            return this.getBinary();
        }
        if (this.getType() == Property.Type.ENTITY) {
            return this.getEntity();
        }
        throw new IllegalStateException("unsupported property type");
    }

    public Object[] getValues() {
        if (this.getType() == Property.Type.STRING) {
            return this.getStrings();
        }
        if (this.getType() == Property.Type.DECIMAL) {
            return this.getDecimals();
        }
        if (this.getType() == Property.Type.LONG) {
            return this.getLongs();
        }
        if (this.getType() == Property.Type.DOUBLE) {
            return this.getDoubles();
        }
        if (this.getType() == Property.Type.DATE) {
            return this.getDates();
        }
        if (this.getType() == Property.Type.BOOLEAN) {
            return this.getBooleans();
        }
        if (this.getType() == Property.Type.BINARY) {
            return this.getBinaries();
        }
        if (this.getType() == Property.Type.ENTITY) {
            return this.getEntities();
        }
        throw new IllegalStateException("unsupported property type");
    }

    @Override
    public long countChildren() throws RepositoryException {
        if (this.isTransient() || this.didLoadValues) {
            if (this.isMultiValued()) {
                return this.values == null ? 0L : (long)this.values.size();
            }
            return this.value == null ? 0L : 1L;
        }
        Long count = this.getAccessor().count("COUNT Value v IF v.property.id=?", new Object[]{this.getRecord().getId()});
        if (count == null) {
            return 0L;
        }
        return count;
    }

    public void dropValue(Value value) {
        if (this.isMultiValued()) {
            if (this.values != null) {
                Iterator<Value> iterator = this.values.iterator();
                while (iterator.hasNext()) {
                    Value next = iterator.next();
                    if (next != value) continue;
                    iterator.remove();
                }
            }
        } else {
            this.value = null;
        }
    }

    public void moveValueToIndex(Value value, long index) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("values can not be moved in read only sessions");
        }
        if (value.getProperty() != this) {
            throw new RepositoryException("provided value is not owned by this property");
        }
        if (value.getIndex() == index) {
            return;
        }
        if (this.isMultiValued()) {
            if (!this.isTransient()) {
                this.loadValues();
            }
            if (this.values != null) {
                long upperBorder;
                long lowerBorder;
                boolean moveToRight;
                Iterator<Value> iterator = this.values.iterator();
                if (index > (long)(this.values.size() - 1)) {
                    index = this.values.size();
                }
                boolean bl = moveToRight = value.getIndex() < index;
                if (moveToRight) {
                    lowerBorder = value.getIndex();
                    upperBorder = index;
                } else {
                    lowerBorder = index;
                    upperBorder = value.getIndex();
                }
                long i = 0L;
                while (iterator.hasNext()) {
                    Value next = iterator.next();
                    if (i >= lowerBorder && i <= upperBorder) {
                        if (moveToRight) {
                            if (next == value) {
                                next.setIndex(index);
                                iterator.remove();
                            } else {
                                next.setIndex(next.getIndex() - 1L);
                            }
                        } else if (next == value) {
                            next.setIndex(index);
                            iterator.remove();
                        } else {
                            next.setIndex(next.getIndex() + 1L);
                        }
                    }
                    ++i;
                }
                this.values.add((int)index, value);
            }
        } else {
            value.setIndex(0L);
        }
    }

    public List<Value> getValuesInternal() {
        return this.values;
    }

    public long getIndex() {
        return this.index;
    }

    public void moveToIndex(long index) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("values can not be moved in read only sessions");
        }
        this.owner.movePropertyToIndex(this, index);
    }

    public void setIndex(long index) throws RepositoryException {
        if (this.isReadOnly()) {
            throw new ModificationNotAllowedException("properties can not be moved in read only sessions");
        }
        if (index != this.index) {
            this.index = index;
            this.getRecord().setAttributeValue("parentIndex", (Object)index);
            if (!this.isTransient()) {
                this.createPersist(this.owner);
            }
        }
    }
}

