/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bndly.schema.api.Record;
import org.bndly.schema.api.repository.IndexedItem;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.impl.repository.IndexedItemComparator;

public abstract class SortedKeyedIndex<KEY, ITEM extends IndexedItem> {
    private boolean didLoadItems;
    private boolean sortingItemsRequired;
    private List<ITEM> itemList;
    private Map<KEY, ITEM> itemsByKey;

    protected abstract boolean isTransient();

    protected abstract Iterator<Record> performItemsQuery();

    protected abstract Iterator<Record> performItemQueryByKey(KEY var1);

    protected abstract ITEM wrapItemRecord(Record var1);

    protected abstract KEY getKeyOfItem(ITEM var1);

    protected abstract ITEM setIndexOfItem(ITEM var1, long var2) throws RepositoryException;

    protected abstract boolean isRemovalOfItemScheduled(ITEM var1);

    protected abstract void testMovePreconditions(ITEM var1, long var2) throws RepositoryException;

    protected abstract void throwItemNotFoundException(KEY var1) throws RepositoryException;

    protected abstract Long countItemsInPersistenceLayer();

    public final void retain(ITEM item) {
        IndexedItem found;
        KEY key = this.getKeyOfItem(item);
        if (this.itemsByKey != null && this.itemList != null && (found = (IndexedItem)this.itemsByKey.get(key)) != null) {
            Iterator<ITEM> iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != found) continue;
                iterator.remove();
            }
        }
        if (this.itemList == null) {
            this.itemList = new ArrayList<ITEM>();
        }
        if (this.itemsByKey == null) {
            this.itemsByKey = new LinkedHashMap<KEY, ITEM>();
        }
        this.itemList.add(item);
        this.itemsByKey.put(key, item);
    }

    public final void drop(ITEM item) {
        KEY key;
        IndexedItem found;
        if (this.itemList != null) {
            Iterator<ITEM> iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != item) continue;
                iterator.remove();
                this.sortingItemsRequired = true;
            }
        }
        if (this.itemsByKey != null && (found = (IndexedItem)this.itemsByKey.get(key = this.getKeyOfItem(item))) == item) {
            this.itemsByKey.remove(key);
            this.sortingItemsRequired = true;
        }
    }

    public final void moveItemToIndex(ITEM item, long index) throws RepositoryException {
        this.testMovePreconditions(item, index);
        if (item.getIndex() == index) {
            return;
        }
        if (!this.isTransient()) {
            this.loadItems();
        }
        this.sortItemsIfRequired();
        if (this.itemList != null) {
            long upperBorder;
            long lowerBorder;
            boolean moveToRight;
            Iterator<ITEM> iterator = this.itemList.iterator();
            if (index > (long)(this.itemList.size() - 1)) {
                index = this.itemList.size();
            }
            boolean bl = moveToRight = item.getIndex() < index;
            if (moveToRight) {
                lowerBorder = item.getIndex();
                upperBorder = index;
            } else {
                lowerBorder = index;
                upperBorder = item.getIndex();
            }
            long i = 0L;
            while (iterator.hasNext()) {
                IndexedItem next = (IndexedItem)iterator.next();
                if (i >= lowerBorder && i <= upperBorder) {
                    if (moveToRight) {
                        if (next == item) {
                            this.setIndexOfItem(next, index);
                            iterator.remove();
                        } else {
                            this.setIndexOfItem(next, next.getIndex() - 1L);
                        }
                    } else if (next == item) {
                        this.setIndexOfItem(next, index);
                        iterator.remove();
                    } else {
                        this.setIndexOfItem(next, next.getIndex() + 1L);
                    }
                }
                ++i;
            }
            this.itemList.add((int)index, item);
            this.sortItemsByKey();
        }
    }

    public final Iterator<ITEM> getItems() throws RepositoryException {
        if (!this.isTransient()) {
            this.loadItems();
        }
        this.sortItemsIfRequired();
        return this.itemList == null ? Collections.EMPTY_LIST.iterator() : this.itemList.iterator();
    }

    public final ITEM getItem(KEY key) throws RepositoryException {
        if (this.itemsByKey != null && this.itemsByKey.containsKey(key)) {
            return (ITEM)this.filterRemovedItem((IndexedItem)this.itemsByKey.get(key));
        }
        if (this.isTransient()) {
            this.throwItemNotFoundException(key);
            throw new RepositoryException("could not find item for key " + key + " because the owner is in a transient state");
        }
        Iterator<Record> r = this.performItemQueryByKey(key);
        if (r.hasNext()) {
            Record rec = r.next();
            ITEM item = this.wrapItemRecord(rec);
            this.retain(item);
            return item;
        }
        this.throwItemNotFoundException(key);
        throw new RepositoryException("could not find item for key " + key);
    }

    public final void testKeyUniqueness(KEY key) throws RepositoryException {
        if (this.itemsByKey != null && this.itemsByKey.containsKey(key)) {
            throw new RepositoryException("item with key " + key + " already exists.");
        }
    }

    public final void testNewItemInMemoryUniqueness(KEY key) throws RepositoryException {
        IndexedItem tmp;
        if (this.itemsByKey != null && this.itemsByKey.containsKey(key) && (tmp = (IndexedItem)this.itemsByKey.get(key)) != null && !this.isRemovalOfItemScheduled(tmp)) {
            throw new RepositoryException("item with key " + key + " already exists.");
        }
    }

    public final long getItemCount() {
        if (this.isTransient()) {
            return this.itemList == null ? 0L : (long)this.itemList.size();
        }
        if (this.didLoadItems) {
            return this.itemList == null ? 0L : (long)this.itemList.size();
        }
        Long count = this.countItemsInPersistenceLayer();
        if (count == null) {
            return 0L;
        }
        return count;
    }

    private ITEM filterRemovedItem(ITEM item) throws RepositoryException {
        if (this.isRemovalOfItemScheduled(item)) {
            this.throwItemNotFoundException(this.getKeyOfItem(item));
        }
        return item;
    }

    private void sortItemsIfRequired() {
        if (this.sortingItemsRequired) {
            if (this.itemList != null) {
                Collections.sort(this.itemList, IndexedItemComparator.INSTANCE);
                this.sortItemsByKey();
            }
            this.sortingItemsRequired = false;
        }
    }

    private void sortItemsByKey() {
        if (this.itemsByKey == null) {
            return;
        }
        this.itemsByKey.clear();
        for (IndexedItem item : this.itemList) {
            KEY key = this.getKeyOfItem(item);
            this.itemsByKey.put(key, item);
        }
    }

    private void loadItems() {
        if (this.didLoadItems) {
            return;
        }
        if (this.isTransient()) {
            return;
        }
        Iterator<Record> itemsIter = this.performItemsQuery();
        this.didLoadItems = true;
        while (itemsIter.hasNext()) {
            Record record = itemsIter.next();
            ITEM item = this.wrapItemRecord(record);
            KEY key = this.getKeyOfItem(item);
            if (this.itemsByKey == null || !this.itemsByKey.containsKey(key)) {
                this.retain(item);
                continue;
            }
            this.sortingItemsRequired = true;
        }
    }
}

