/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository.beans;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bndly.common.data.io.IOUtils;
import org.bndly.common.osgi.util.DictionaryAdapter;
import org.bndly.schema.api.repository.Node;
import org.bndly.schema.api.repository.NodeNotFoundException;
import org.bndly.schema.api.repository.PathBuilder;
import org.bndly.schema.api.repository.Property;
import org.bndly.schema.api.repository.PropertyNotFoundException;
import org.bndly.schema.api.repository.Repository;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositoryListener;
import org.bndly.schema.api.repository.RepositorySession;
import org.bndly.schema.api.repository.beans.BeanDefinition;
import org.bndly.schema.api.repository.beans.BeanDefinitionRegistry;
import org.bndly.schema.impl.repository.beans.BeanDefinitionRepositoryListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={BeanDefinitionRegistry.class})
@Designate(ocd=Configuration.class)
public class BeanDefinitionRegistryImpl
implements BeanDefinitionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(BeanDefinitionRegistryImpl.class);
    @Reference
    private Repository repository;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, BeanDefinitionImpl> beanDefinitionsByPath = new HashMap<String, BeanDefinitionImpl>();
    private final Map<String, BeanDefinitionImpl> beanDefinitions = new HashMap<String, BeanDefinitionImpl>();
    private Map<String, BeanDefinitionImpl> beanDefinitionsUnmodifieable = Collections.EMPTY_MAP;
    private static final BeanDefinition.PropertyDefinition BEAN_TYPE_PROPERTY_DEFINITION = new BeanDefinition.PropertyDefinition(){

        public String getName() {
            return "beanType";
        }

        public boolean isMulti() {
            return false;
        }

        public Property.Type getType() {
            return Property.Type.STRING;
        }

        public Object get(String metaDataName) {
            return null;
        }

        public Object getMetaData(String metaDataName) {
            return null;
        }

        public Map<String, Object> getMetaDataMap() {
            return Collections.EMPTY_MAP;
        }
    };
    private BeanDefinitionRepositoryListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(ComponentContext componentContext) {
        this.lock.writeLock().lock();
        DictionaryAdapter dictionaryAdapter = new DictionaryAdapter(componentContext.getProperties());
        try (RepositorySession session = this.repository.createReadOnlySession();){
            Collection locations = dictionaryAdapter.getStringCollection("locations", new String[]{"/apps", "/libs"});
            for (String location : locations) {
                Node apps = session.getNode(PathBuilder.newInstance((String)location).build());
                this.iterateNode(apps, new IterationCallback(){
                    private final Stack<BeanDefinitionImpl> definitionStack = new Stack();

                    @Override
                    public void onNode(Node node) throws RepositoryException {
                        PropertyDefinitionImpl propertyDefinition;
                        if (node.getType().equals("cy:beanDef")) {
                            BeanDefinitionImpl beanDefinitionImpl = BeanDefinitionRegistryImpl.this.createBeanDefinitionFromNode(node);
                            if (beanDefinitionImpl != null) {
                                this.definitionStack.push(beanDefinitionImpl);
                                BeanDefinitionRegistryImpl.this.beanDefinitions.put(beanDefinitionImpl.getName(), beanDefinitionImpl);
                                BeanDefinitionRegistryImpl.this.beanDefinitionsByPath.put(beanDefinitionImpl.path, beanDefinitionImpl);
                            }
                        } else if (node.getType().equals("cy:beanPropertyDef") && (propertyDefinition = BeanDefinitionRegistryImpl.this.createBeanPropertyDefinitionFromNode(node)) != null && !this.definitionStack.isEmpty()) {
                            BeanDefinitionImpl peek = this.definitionStack.peek();
                            peek.propertiesInternalByPath.put(propertyDefinition.path, propertyDefinition);
                        }
                    }

                    @Override
                    public void afterNode(Node node) throws RepositoryException {
                        if (node.getType().equals("cy:beanDef")) {
                            this.definitionStack.pop();
                        }
                    }
                });
                for (BeanDefinition beanDefinition : this.beanDefinitions.values()) {
                    ((BeanDefinitionImpl)beanDefinition).init();
                }
            }
            this.beanDefinitionsUnmodifieable = Collections.unmodifiableMap(this.beanDefinitions);
            LOG.info("found a total of {} bean definitions", (Object)this.beanDefinitions.size());
        }
        catch (NodeNotFoundException ex) {
            LOG.warn("no apps found");
        }
        catch (RepositoryException ex) {
            LOG.error("could not initially inspect repository: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.listener = new BeanDefinitionRepositoryListener(this);
        this.repository.addListener((RepositoryListener)this.listener);
    }

    @Deactivate
    public void deactivate() {
        this.repository.removeListener((RepositoryListener)this.listener);
        this.listener = null;
        this.lock.writeLock().lock();
        try {
            this.beanDefinitions.clear();
            this.beanDefinitionsUnmodifieable = Collections.EMPTY_MAP;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private BeanDefinitionImpl createDefinition(String path, String name, String superType, Map<String, Object> metaData) {
        return new BeanDefinitionImpl(path, name, superType, metaData);
    }

    private PropertyDefinitionImpl createPropertyDefinition(String path, String propertyName, Property.Type type, boolean multi, Map<String, Object> metaData) {
        return new PropertyDefinitionImpl(path, propertyName, multi, type, metaData);
    }

    private Map<String, Object> createMetaData(Node node) throws RepositoryException, IOException {
        LinkedHashMap<String, Object> metaData = new LinkedHashMap<String, Object>();
        Iterator properties = node.getProperties();
        while (properties.hasNext()) {
            Object value;
            Property property = (Property)properties.next();
            String name = property.getName();
            if (property.getType() == Property.Type.ENTITY) continue;
            if (property.isMultiValued()) {
                if (property.getType() == Property.Type.BINARY) {
                    InputStream[] binaries = property.getBinaries();
                    if (binaries != null) {
                        InputStream[] copy = new InputStream[binaries.length];
                        for (int i = 0; i < binaries.length; ++i) {
                            InputStream binary = binaries[i];
                            if (binary != null) {
                                byte[] bytes = IOUtils.read((InputStream)binary);
                                copy[i] = new ByteArrayInputStream(bytes);
                                continue;
                            }
                            copy[i] = null;
                        }
                        value = copy;
                    } else {
                        value = null;
                    }
                } else {
                    value = property.getValues();
                }
            } else if (property.getType() == Property.Type.BINARY) {
                InputStream binary = property.getBinary();
                if (binary != null) {
                    byte[] bytes = IOUtils.read((InputStream)binary);
                    value = new ByteArrayInputStream(bytes);
                } else {
                    value = null;
                }
            } else {
                value = property.getValue();
            }
            metaData.put(name, value);
        }
        return metaData;
    }

    private PropertyDefinitionImpl createBeanPropertyDefinitionFromNode(Node node) throws RepositoryException {
        Property.Type type;
        String propertyName;
        if (node == null) {
            return null;
        }
        try {
            propertyName = node.getProperty("name").getString();
            type = Property.Type.valueOf((String)node.getProperty("type").getString());
        }
        catch (PropertyNotFoundException e) {
            LOG.warn("incomplete bean property definition at {}", (Object)node.getPath());
            return null;
        }
        boolean multi = false;
        try {
            Boolean tmp = node.getProperty("multi").getBoolean();
            if (tmp != null) {
                multi = tmp;
            }
        }
        catch (PropertyNotFoundException e) {
            multi = false;
        }
        try {
            PropertyDefinitionImpl propertyDefinition = this.createPropertyDefinition(node.getPath().toString(), propertyName, type, multi, this.createMetaData(node));
            return propertyDefinition;
        }
        catch (IOException e) {
            LOG.error("could not build bean property definition: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private BeanDefinitionImpl createBeanDefinitionFromNode(Node node) throws RepositoryException {
        String superType;
        String name;
        if (node == null) {
            return null;
        }
        try {
            name = node.getProperty("name").getString();
        }
        catch (PropertyNotFoundException e) {
            LOG.warn("incomplete bean definition at {}", (Object)node.getPath());
            return null;
        }
        try {
            superType = node.getProperty("superType").getString();
        }
        catch (PropertyNotFoundException e) {
            superType = null;
        }
        if (name != null) {
            try {
                BeanDefinitionImpl def = this.createDefinition(node.getPath().toString(), name, superType, this.createMetaData(node));
                return def;
            }
            catch (IOException e) {
                LOG.error("could not build bean definition: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public BeanDefinition getBeanDefinition(String beanTypeName) {
        if (beanTypeName == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            BeanDefinition beanDefinition = this.beanDefinitions.get(beanTypeName);
            return beanDefinition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, BeanDefinition> getBeanDefinitions() {
        this.lock.readLock().lock();
        try {
            Map<String, BeanDefinition> map = this.beanDefinitionsUnmodifieable;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void getPropertiesOfBeanDefinition(BeanDefinition beanDefinition, List<BeanDefinition.PropertyDefinition> properties) {
        if (beanDefinition == null) {
            return;
        }
        this.getPropertiesOfBeanDefinition(beanDefinition.getParent(), properties);
        properties.addAll(beanDefinition.getProperties());
    }

    private void iterateNode(Node node, IterationCallback callback) throws RepositoryException {
        callback.onNode(node);
        Iterator iter = node.getChildren();
        while (iter.hasNext()) {
            this.iterateNode((Node)iter.next(), callback);
        }
    }

    Callable<BeanDefinition> createRunnableForNewBeanDefinition(final Node node) {
        return new Callable<BeanDefinition>(){

            @Override
            public BeanDefinition call() throws RepositoryException {
                BeanDefinitionRegistryImpl.this.lock.writeLock().lock();
                try {
                    BeanDefinitionImpl beanDefinitionImpl = BeanDefinitionRegistryImpl.this.createBeanDefinitionFromNode(node);
                    if (beanDefinitionImpl != null) {
                        BeanDefinitionRegistryImpl.this.beanDefinitions.put(beanDefinitionImpl.getName(), beanDefinitionImpl);
                        BeanDefinitionRegistryImpl.this.beanDefinitionsByPath.put(beanDefinitionImpl.path, beanDefinitionImpl);
                    }
                    BeanDefinitionImpl beanDefinitionImpl2 = beanDefinitionImpl;
                    return beanDefinitionImpl2;
                }
                finally {
                    BeanDefinitionRegistryImpl.this.lock.writeLock().unlock();
                }
            }
        };
    }

    Callable<BeanDefinition.PropertyDefinition> createRunnableForNewBeanPropertyDefinition(final Node node) {
        return new Callable<BeanDefinition.PropertyDefinition>(){

            @Override
            public BeanDefinition.PropertyDefinition call() throws Exception {
                BeanDefinitionRegistryImpl.this.lock.writeLock().lock();
                try {
                    BeanDefinitionImpl beanDefinitionImpl;
                    PropertyDefinitionImpl propertyDefinition = BeanDefinitionRegistryImpl.this.createBeanPropertyDefinitionFromNode(node);
                    if (propertyDefinition != null && (beanDefinitionImpl = BeanDefinitionRegistryImpl.this.getBeanDefinitionFromNode(node)) != null) {
                        beanDefinitionImpl.propertiesInternalByPath.put(propertyDefinition.path, propertyDefinition);
                    }
                    PropertyDefinitionImpl propertyDefinitionImpl = propertyDefinition;
                    return propertyDefinitionImpl;
                }
                finally {
                    BeanDefinitionRegistryImpl.this.lock.writeLock().unlock();
                }
            }
        };
    }

    Callable<BeanDefinition> createRunnableForRemovedBeanDefinition(final Node node) {
        return new Callable<BeanDefinition>(){

            @Override
            public BeanDefinition call() throws Exception {
                BeanDefinitionRegistryImpl.this.lock.writeLock().lock();
                try {
                    BeanDefinitionImpl beanDefinitionImpl = BeanDefinitionRegistryImpl.this.getBeanDefinitionFromNode(node);
                    if (beanDefinitionImpl != null) {
                        BeanDefinitionRegistryImpl.this.beanDefinitions.remove(beanDefinitionImpl.getName());
                        BeanDefinitionRegistryImpl.this.beanDefinitionsByPath.remove(beanDefinitionImpl.path);
                    }
                    BeanDefinitionImpl beanDefinitionImpl2 = beanDefinitionImpl;
                    return beanDefinitionImpl2;
                }
                finally {
                    BeanDefinitionRegistryImpl.this.lock.writeLock().unlock();
                }
            }
        };
    }

    Callable<BeanDefinition.PropertyDefinition> createRunnableForRemovedBeanPropertyDefinition(final Node node) {
        return new Callable<BeanDefinition.PropertyDefinition>(){

            /*
             * Exception decompiling
             */
            @Override
            public BeanDefinition.PropertyDefinition call() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    Callable<BeanDefinition> createRunnableForUpdatedBeanDefinition(final Node node, Property property) {
        return new Callable<BeanDefinition>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BeanDefinition call() throws Exception {
                BeanDefinitionRegistryImpl.this.lock.writeLock().lock();
                try {
                    BeanDefinitionImpl newBeanDefinitionImpl;
                    BeanDefinitionImpl oldBeanDefinitionImpl = BeanDefinitionRegistryImpl.this.getBeanDefinitionFromNode(node);
                    if (oldBeanDefinitionImpl != null) {
                        BeanDefinitionRegistryImpl.this.beanDefinitions.remove(oldBeanDefinitionImpl.getName());
                        BeanDefinitionRegistryImpl.this.beanDefinitionsByPath.remove(oldBeanDefinitionImpl.path);
                    }
                    if ((newBeanDefinitionImpl = BeanDefinitionRegistryImpl.this.createBeanDefinitionFromNode(BeanDefinitionRegistryImpl.this.getBeanDefinitionNode(node))) != null) {
                        if (oldBeanDefinitionImpl != null) {
                            newBeanDefinitionImpl.propertiesInternalByPath.putAll(oldBeanDefinitionImpl.propertiesInternalByPath);
                        }
                        BeanDefinitionRegistryImpl.this.beanDefinitions.put(newBeanDefinitionImpl.getName(), newBeanDefinitionImpl);
                        BeanDefinitionRegistryImpl.this.beanDefinitionsByPath.put(newBeanDefinitionImpl.path, newBeanDefinitionImpl);
                    }
                    BeanDefinitionImpl beanDefinitionImpl = newBeanDefinitionImpl;
                    return beanDefinitionImpl;
                }
                finally {
                    BeanDefinitionRegistryImpl.this.lock.writeLock().unlock();
                }
            }
        };
    }

    Callable<BeanDefinition.PropertyDefinition> createRunnableForUpdatedBeanPropertyDefinition(final Node node, Property property) {
        return new Callable<BeanDefinition.PropertyDefinition>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BeanDefinition.PropertyDefinition call() throws Exception {
                BeanDefinitionRegistryImpl.this.lock.writeLock().lock();
                try {
                    BeanDefinitionImpl beanDefinitionImpl = BeanDefinitionRegistryImpl.this.getBeanDefinitionFromNode(node);
                    if (beanDefinitionImpl != null) {
                        PropertyDefinitionImpl oldPropertyDefinition = (PropertyDefinitionImpl)beanDefinitionImpl.propertiesInternalByPath.remove(node.getPath().toString());
                        PropertyDefinitionImpl newPropertyDefinition = BeanDefinitionRegistryImpl.this.createBeanPropertyDefinitionFromNode(node);
                        if (newPropertyDefinition != null) {
                            beanDefinitionImpl.propertiesInternalByPath.put(newPropertyDefinition.path, newPropertyDefinition);
                        }
                        PropertyDefinitionImpl propertyDefinitionImpl = newPropertyDefinition;
                        return propertyDefinitionImpl;
                    }
                    BeanDefinition.PropertyDefinition propertyDefinition = null;
                    return propertyDefinition;
                }
                finally {
                    BeanDefinitionRegistryImpl.this.lock.writeLock().unlock();
                }
            }
        };
    }

    Callable<Map<String, BeanDefinition>> createCallableForBeanDefinitionInit() {
        return new Callable<Map<String, BeanDefinition>>(){

            @Override
            public Map<String, BeanDefinition> call() throws Exception {
                BeanDefinitionRegistryImpl.this.lock.writeLock().lock();
                try {
                    for (BeanDefinitionImpl value : BeanDefinitionRegistryImpl.this.beanDefinitions.values()) {
                        value.init();
                    }
                    BeanDefinitionRegistryImpl.this.beanDefinitionsUnmodifieable = Collections.unmodifiableMap(BeanDefinitionRegistryImpl.this.beanDefinitions);
                    Map<String, BeanDefinition> map = BeanDefinitionRegistryImpl.this.getBeanDefinitions();
                    return map;
                }
                finally {
                    BeanDefinitionRegistryImpl.this.lock.writeLock().unlock();
                }
            }
        };
    }

    BeanDefinitionImpl getBeanDefinitionFromNode(Node node) throws RepositoryException {
        if ((node = this.getBeanDefinitionNode(node)) == null) {
            return null;
        }
        try {
            String name = node.getProperty("name").getString();
            return this.beanDefinitions.get(name);
        }
        catch (PropertyNotFoundException e) {
            LOG.warn("incomplete bean definition at {}", (Object)node.getPath());
            return null;
        }
    }

    Node getBeanDefinitionNode(Node node) throws RepositoryException {
        if (node == null) {
            return null;
        }
        if (node.getType().equals("cy:beanDef")) {
            return node;
        }
        return this.getBeanDefinitionNode(node.getParent());
    }

    static /* synthetic */ Logger access$1200() {
        return LOG;
    }

    private static interface IterationCallback {
        public void onNode(Node var1) throws RepositoryException;

        public void afterNode(Node var1) throws RepositoryException;
    }

    private class BeanDefinitionImpl
    implements BeanDefinition {
        private final String path;
        private final String name;
        private final String superTypeName;
        private final Map<String, PropertyDefinitionImpl> propertiesInternalByPath = new LinkedHashMap<String, PropertyDefinitionImpl>();
        private List<BeanDefinition.PropertyDefinition> properties = new ArrayList<BeanDefinition.PropertyDefinition>();
        private Map<String, BeanDefinition.PropertyDefinition> propertiesByName = Collections.EMPTY_MAP;
        private List<BeanDefinition.PropertyDefinition> allProperties;
        private final Map<String, Object> metaData;

        public BeanDefinitionImpl(String path, String name, String superTypeName, Map<String, Object> metaData) {
            this.path = path;
            this.name = name;
            this.superTypeName = superTypeName;
            this.metaData = metaData == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(metaData);
        }

        public String getName() {
            return this.name;
        }

        public BeanDefinition getParent() {
            return BeanDefinitionRegistryImpl.this.getBeanDefinition(this.superTypeName);
        }

        public List<BeanDefinition.PropertyDefinition> getProperties() {
            return this.properties;
        }

        public List<BeanDefinition.PropertyDefinition> getAllProperties() {
            return this.allProperties;
        }

        public BeanDefinition.PropertyDefinition getProperty(String name) {
            return this.propertiesByName.get(name);
        }

        private PropertyDefinitionImpl getPropertyImpl(String name) {
            BeanDefinition.PropertyDefinition definition = this.propertiesByName.get(name);
            return (PropertyDefinitionImpl)(PropertyDefinitionImpl.class.isInstance(definition) ? definition : null);
        }

        private void init() {
            this.properties = Collections.unmodifiableList(new ArrayList<PropertyDefinitionImpl>(this.propertiesInternalByPath.values()));
            ArrayList<BeanDefinition.PropertyDefinition> propertiesCopy = new ArrayList<BeanDefinition.PropertyDefinition>();
            propertiesCopy.add(BEAN_TYPE_PROPERTY_DEFINITION);
            BeanDefinitionRegistryImpl.this.getPropertiesOfBeanDefinition(this, propertiesCopy);
            this.allProperties = Collections.unmodifiableList(propertiesCopy);
            LinkedHashMap<String, BeanDefinition.PropertyDefinition> definitionsByName = new LinkedHashMap<String, BeanDefinition.PropertyDefinition>();
            for (BeanDefinition.PropertyDefinition propertyDefinition : this.allProperties) {
                definitionsByName.put(propertyDefinition.getName(), propertyDefinition);
            }
            this.propertiesByName = Collections.unmodifiableMap(definitionsByName);
        }

        public Object get(String metaDataName) {
            return this.getMetaData(metaDataName);
        }

        public Object getMetaData(String metaDataName) {
            return this.metaData.get(metaDataName);
        }

        static /* synthetic */ PropertyDefinitionImpl access$1100(BeanDefinitionImpl x0, String x1) {
            return x0.getPropertyImpl(x1);
        }
    }

    private class PropertyDefinitionImpl
    implements BeanDefinition.PropertyDefinition {
        private final String path;
        private final String name;
        private final boolean multi;
        private final Property.Type type;
        private final Map<String, Object> metaData;

        public PropertyDefinitionImpl(String path, String name, boolean multi, Property.Type type, Map<String, Object> metaData) {
            this.path = path;
            this.name = name;
            this.multi = multi;
            this.type = type;
            this.metaData = metaData == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(metaData);
        }

        public String getName() {
            return this.name;
        }

        public boolean isMulti() {
            return this.multi;
        }

        public Property.Type getType() {
            return this.type;
        }

        public Object get(String metaDataName) {
            return this.getMetaData(metaDataName);
        }

        public Object getMetaData(String metaDataName) {
            return this.metaData.get(metaDataName);
        }

        public Map<String, Object> getMetaDataMap() {
            return this.metaData;
        }
    }

    @ObjectClassDefinition(name="Bean Definition Registry", description="This registry keeps track of the meta model for bean definitions")
    public static @interface Configuration {
        @AttributeDefinition(name="Locations", description="The locations in the repository to check for bean definitions")
        public String[] locations() default {"/apps", "/libs"};
    }
}

