/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.repository.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bndly.schema.api.repository.Node;
import org.bndly.schema.api.repository.Property;
import org.bndly.schema.api.repository.RepositoryException;
import org.bndly.schema.api.repository.RepositoryListener;
import org.bndly.schema.api.repository.RepositorySession;
import org.bndly.schema.impl.repository.beans.BeanDefinitionRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDefinitionRepositoryListener
implements RepositoryListener {
    private static final Logger LOG = LoggerFactory.getLogger(BeanDefinitionRepositoryListener.class);
    private final Map<Integer, List<Callable>> callablesPerSession = new HashMap<Integer, List<Callable>>();
    private final BeanDefinitionRegistryImpl beanDefinitionRegistryImpl;

    public BeanDefinitionRepositoryListener(BeanDefinitionRegistryImpl beanDefinitionRegistryImpl) {
        this.beanDefinitionRegistryImpl = beanDefinitionRegistryImpl;
    }

    public void onSessionStart(RepositorySession session) throws RepositoryException {
        if (session.isReadOnly()) {
            return;
        }
        this.callablesPerSession.put(System.identityHashCode(session), new ArrayList());
    }

    public void onSessionEnd(RepositorySession session) throws RepositoryException {
        if (session.isReadOnly()) {
            return;
        }
        this.callablesPerSession.remove(System.identityHashCode(session));
    }

    public void onBeforeFlush(RepositorySession session) throws RepositoryException {
    }

    public void onFlushSuccess(RepositorySession session) throws RepositoryException {
        if (session.isReadOnly()) {
            return;
        }
        List<Callable> callables = this.callablesPerSession.get(System.identityHashCode(session));
        if (callables != null && !callables.isEmpty()) {
            callables.add(this.beanDefinitionRegistryImpl.createCallableForBeanDefinitionInit());
            try {
                for (Callable callable : callables) {
                    callable.call();
                }
                LOG.info("applied {} changes to the bean definition registry", (Object)(callables.size() - 1));
            }
            catch (Exception e) {
                LOG.error("failed to apply changes to the bean definition registry", (Throwable)e);
                if (RepositoryException.class.isInstance(e)) {
                    throw (RepositoryException)((Object)e);
                }
                throw new RepositoryException("could not apply bean definition modifications", (Throwable)e);
            }
        }
    }

    public void onFlushFailure(RepositorySession session) throws RepositoryException {
    }

    public void onNodeCreated(Node node) throws RepositoryException {
        if (node.getType().equals("cy:beanDef")) {
            this.onNewBeanDefinition(node);
        } else if (node.getType().equals("cy:beanPropertyDef")) {
            this.onNewBeanPropertyDefinition(node);
        }
    }

    public void onNodeRemoved(Node node) throws RepositoryException {
        if (node.getType().equals("cy:beanDef")) {
            this.onRemovedBeanDefinition(node);
        } else if (node.getType().equals("cy:beanPropertyDef")) {
            this.onRemovedBeanPropertyDefinition(node);
        }
    }

    public void onNodeMoved(Node node, long index) throws RepositoryException {
    }

    public void onPropertyCreated(Property property) throws RepositoryException {
        Node node = property.getNode();
        if (node.getType().equals("cy:beanDef")) {
            this.onUpdatedBeanDefinition(node, property);
        } else if (node.getType().equals("cy:beanPropertyDef")) {
            this.onUpdatedBeanPropertyDefinition(node, property);
        }
    }

    public void onPropertyRemoved(Property property) throws RepositoryException {
    }

    public void onPropertyChanged(Property property) throws RepositoryException {
        Node node = property.getNode();
        if (node.getType().equals("cy:beanDef")) {
            this.onUpdatedBeanDefinition(node, property);
        } else if (node.getType().equals("cy:beanPropertyDef")) {
            this.onUpdatedBeanPropertyDefinition(node, property);
        }
    }

    private void onNewBeanDefinition(Node node) {
        LOG.info("detected a new bean definition at {}", (Object)node.getPath());
        this.addCallableForNodeSession(node, this.beanDefinitionRegistryImpl.createRunnableForNewBeanDefinition(node));
    }

    private void onNewBeanPropertyDefinition(Node node) {
        LOG.info("detected a new bean property definition at {}", (Object)node.getPath());
        this.addCallableForNodeSession(node, this.beanDefinitionRegistryImpl.createRunnableForNewBeanPropertyDefinition(node));
    }

    private void onRemovedBeanDefinition(Node node) {
        LOG.info("detected a removed bean definition at {}", (Object)node.getPath());
        this.addCallableForNodeSession(node, this.beanDefinitionRegistryImpl.createRunnableForRemovedBeanDefinition(node));
    }

    private void onRemovedBeanPropertyDefinition(Node node) {
        LOG.info("detected a removed bean property definition at {}", (Object)node.getPath());
        this.addCallableForNodeSession(node, this.beanDefinitionRegistryImpl.createRunnableForRemovedBeanPropertyDefinition(node));
    }

    private void addCallableForNodeSession(Node node, Callable callable) {
        List<Callable> callablesForNodeSession = this.getCallableForNodeSession(node);
        if (callablesForNodeSession != null) {
            callablesForNodeSession.add(callable);
        }
    }

    private List<Callable> getCallableForNodeSession(Node node) {
        return this.getCallableForSession(node.getRepositorySession());
    }

    private List<Callable> getCallableForSession(RepositorySession repositorySession) {
        return this.callablesPerSession.get(System.identityHashCode(repositorySession));
    }

    private void onUpdatedBeanDefinition(Node node, Property property) {
        LOG.info("detected a modification of bean definition at {}", (Object)node.getPath());
        this.addCallableForNodeSession(node, this.beanDefinitionRegistryImpl.createRunnableForUpdatedBeanDefinition(node, property));
    }

    private void onUpdatedBeanPropertyDefinition(Node node, Property property) {
        LOG.info("detected a modification of bean property definition at {}", (Object)node.getPath());
        this.addCallableForNodeSession(node, this.beanDefinitionRegistryImpl.createRunnableForUpdatedBeanPropertyDefinition(node, property));
    }
}

