/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.vendor.postgres;

import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSValue;
import org.bndly.common.json.parsing.JSONParser;
import org.bndly.schema.api.CryptoProvider;
import org.bndly.schema.api.RecordContext;
import org.bndly.schema.api.mapper.LobHandler;
import org.bndly.schema.api.services.Accessor;
import org.bndly.schema.json.RecordJsonConverter;
import org.bndly.schema.model.BinaryAttribute;
import org.bndly.schema.model.CryptoAttribute;
import org.bndly.schema.model.StringAttribute;
import org.bndly.schema.vendor.def.DefaultAttributeMediatorFactory;
import org.bndly.schema.vendor.mediator.BinaryAttributeMediator;
import org.bndly.schema.vendor.mediator.CryptoAttributeMediator;
import org.bndly.schema.vendor.mediator.JSONAttributeMediator;
import org.bndly.schema.vendor.mediator.StringAttributeMediator;

public class PostgresAttributeMediatorFactory
extends DefaultAttributeMediatorFactory {
    public BinaryAttributeMediator<BinaryAttribute> createBinaryAttributeMediator(Accessor accessor, RecordJsonConverter recordJsonConverter, LobHandler lobHandler, CryptoProvider cryptoProvider) {
        return new BinaryAttributeMediator<BinaryAttribute>(lobHandler){

            public String columnType(BinaryAttribute attribute) {
                return "BYTEA";
            }

            public int columnSqlType(BinaryAttribute attribute) {
                return -2;
            }
        };
    }

    public JSONAttributeMediator createJSONAttributeMediator(Accessor accessor, RecordJsonConverter recordJsonConverter, LobHandler lobHandler, CryptoProvider cryptoProvider) {
        return new JSONAttributeMediator(lobHandler, recordJsonConverter){

            public Object extractFromResultSet(ResultSet rs, String columnName, BinaryAttribute attribute, RecordContext recordContext) throws SQLException {
                InputStream stream = rs.getBinaryStream(columnName);
                if (stream == null) {
                    return null;
                }
                JSValue parsed = new JSONParser().parse(stream, "UTF-8");
                if (JSObject.class.isInstance(parsed)) {
                    return this.getRecordJsonConverter().convertJsonToRecord((JSObject)parsed, recordContext);
                }
                return null;
            }

            public String columnType(BinaryAttribute attribute) {
                return "BYTEA";
            }

            public int columnSqlType(BinaryAttribute attribute) {
                return -2;
            }
        };
    }

    public StringAttributeMediator createStringAttributeMediator(Accessor accessor, RecordJsonConverter recordJsonConverter, LobHandler lobHandler, CryptoProvider cryptoProvider) {
        return new StringAttributeMediator(){

            public String columnType(StringAttribute attribute) {
                String columnType;
                Integer length = attribute.getLength();
                if (length == null) {
                    length = 255;
                    attribute.setLength(length);
                }
                if (this.isLong(attribute)) {
                    columnType = "TEXT";
                } else {
                    columnType = "VARCHAR";
                    columnType = columnType + "(" + length + ")";
                    attribute.setIsLong(Boolean.FALSE);
                }
                return columnType;
            }

            public int columnSqlType(StringAttribute attribute) {
                return 12;
            }
        };
    }

    public CryptoAttributeMediator createCryptoAttributeMediator(Accessor accessor, RecordJsonConverter recordJsonConverter, LobHandler lobHandler, CryptoProvider cryptoProvider) {
        return new CryptoAttributeMediator(cryptoProvider, lobHandler){

            public String columnType(CryptoAttribute attribute) {
                return "BYTEA";
            }

            public int columnSqlType(CryptoAttribute attribute) {
                return -2;
            }
        };
    }
}

