/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.vendor.postgres;

import java.util.ArrayList;
import org.bndly.schema.api.db.Table;
import org.bndly.schema.api.mapper.RowMapper;
import org.bndly.schema.api.tx.Template;
import org.bndly.schema.api.tx.TransactionCallback;
import org.bndly.schema.api.tx.TransactionStatus;
import org.bndly.schema.api.tx.TransactionTemplate;
import org.bndly.schema.impl.vendor.postgres.PostgresColumnExistenceAdapter;
import org.bndly.schema.vendor.ConstraintExistenceAdapter;
import org.bndly.schema.vendor.def.CountGreaterZeroToBooleanMapper;

public class PostgresConstraintExistenceAdapter
implements ConstraintExistenceAdapter {
    public boolean isConstraintDefinedOnTable(String dbSchemaName, String constraintName, Table table, TransactionTemplate template) {
        String currentDataBase;
        ArrayList<String> a = new ArrayList<String>();
        StringBuffer sb = new StringBuffer("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS c WHERE");
        sb.append(" c.CONSTRAINT_NAME=? AND c.TABLE_NAME=?");
        a.add(constraintName);
        a.add(table.getTableName());
        if (dbSchemaName != null) {
            sb.append(" AND TABLE_SCHEMA=?");
            a.add(dbSchemaName);
        }
        if ((currentDataBase = PostgresColumnExistenceAdapter.getCurrentDatabase(template)) != null) {
            sb.append(" AND TABLE_CATALOG=?");
            a.add(currentDataBase);
        }
        final Object[] args = a.toArray();
        final String constraintSql = sb.toString();
        Boolean res = (Boolean)template.doInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus transactionStatus, Template template) {
                return (Boolean)template.queryForObject(constraintSql, args, (RowMapper)new CountGreaterZeroToBooleanMapper());
            }
        });
        return res;
    }
}

