/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.schema.impl.vendor.postgres;

import java.sql.SQLException;
import java.util.List;
import org.bndly.schema.api.exception.ConstraintViolationException;
import org.bndly.schema.api.exception.IntegrityException;
import org.bndly.schema.api.exception.SchemaException;
import org.bndly.schema.api.services.Deployer;
import org.bndly.schema.api.services.Engine;
import org.bndly.schema.impl.DefaultErrorCodeMapper;
import org.bndly.schema.model.UniqueConstraint;

public class PostgresErrorCodeMapper
extends DefaultErrorCodeMapper {
    @Override
    protected SchemaException map(String message, SQLException exception, int errorCode, Engine engine) {
        String sqlState;
        if (exception != null && (sqlState = exception.getSQLState()) != null) {
            String msg = message;
            Class<SchemaException> exceptionClass = SchemaException.class;
            if (sqlState.startsWith("23")) {
                exceptionClass = IntegrityException.class;
                if ("23000".equals(sqlState)) {
                    msg = "integrity_constraint_violation";
                } else if ("23001".equals(sqlState)) {
                    msg = "restrict_violation";
                } else if ("23502".equals(sqlState)) {
                    msg = "not_null_violation";
                } else if ("23503".equals(sqlState)) {
                    msg = "foreign_key_violation";
                } else if ("23505".equals(sqlState)) {
                    msg = "unique_violation";
                    exceptionClass = ConstraintViolationException.class;
                    String exceptionMessage = exception.getMessage();
                    if (engine != null) {
                        Deployer deployer = engine.getDeployer();
                        List constraintNames = deployer.getUniqueConstraintNames();
                        UniqueConstraint uq = null;
                        for (String constraintName : constraintNames) {
                            if (!exceptionMessage.contains("\"" + constraintName + "\"")) continue;
                            uq = deployer.getUniqueConstraintByName(constraintName);
                            break;
                        }
                        if (uq != null) {
                            return new ConstraintViolationException(uq, msg, (Throwable)exception);
                        }
                    }
                } else if ("23514".equals(sqlState)) {
                    msg = "check_violation";
                } else if ("23P01".equals(sqlState)) {
                    msg = "exclusion_violation";
                }
            }
            return this.createSchemaException(exceptionClass, exception, message, msg);
        }
        return super.map(message, exception, errorCode, engine);
    }
}

