/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.search.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.solr.client.solrj.SolrServer;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractSolrServerTracker
implements ServiceTrackerCustomizer<SolrServer, SolrServer> {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Map<String, SolrServer> updateServers = new HashMap<String, SolrServer>();
    protected final Map<String, SolrServer> queryServers = new HashMap<String, SolrServer>();
    private ServiceTracker<SolrServer, SolrServer> tracker;

    protected abstract ComponentContext getComponentContext();

    protected final void startTracking() {
        this.tracker = new ServiceTracker(this.getComponentContext().getBundleContext(), SolrServer.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    protected final void stopTracking() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SolrServer addingService(ServiceReference<SolrServer> sr) {
        this.lock.writeLock().lock();
        try {
            SolrServer service = (SolrServer)this.getComponentContext().getBundleContext().getService(sr);
            String serverName = (String)sr.getProperty("serverName");
            if (serverName != null) {
                if (sr.getProperty("update") == Boolean.TRUE) {
                    this.updateServers.put(serverName, service);
                } else if (sr.getProperty("query") == Boolean.TRUE) {
                    this.queryServers.put(serverName, service);
                }
            }
            SolrServer solrServer = service;
            return solrServer;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public final void modifiedService(ServiceReference<SolrServer> sr, SolrServer service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removedService(ServiceReference<SolrServer> sr, SolrServer service) {
        this.lock.writeLock().lock();
        try {
            String serverName = (String)sr.getProperty("serverName");
            if (serverName != null) {
                if (sr.getProperty("update") == Boolean.TRUE) {
                    this.updateServers.remove(serverName);
                } else if (sr.getProperty("query") == Boolean.TRUE) {
                    this.queryServers.remove(serverName);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

