/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.search.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.bndly.search.api.BoostedDocumentFieldValue;
import org.bndly.search.api.DocumentFieldValue;
import org.bndly.search.api.DocumentFieldValueProvider;
import org.bndly.search.api.DocumentMapper;
import org.bndly.search.api.Query;
import org.bndly.search.api.Result;
import org.bndly.search.api.SearchException;
import org.bndly.search.api.SearchIndexService;
import org.bndly.search.api.SearchService;
import org.bndly.search.impl.AbstractSolrServerTracker;
import org.bndly.search.impl.SolrRequestCommiter;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SearchService.class, SearchIndexService.class})
public class SearchServiceImpl
extends AbstractSolrServerTracker
implements SearchService,
SearchIndexService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchServiceImpl.class);
    @Reference
    private SolrRequestCommiter solrRequestCommiter;
    private ComponentContext componentContext;

    @Activate
    public void activate(ComponentContext componentContext) {
        LOG.info("activating search service");
        this.componentContext = componentContext;
        this.startTracking();
        LOG.info("activated search service. tracking solr servers now");
    }

    @Deactivate
    public void deactivate(ComponentContext componentContext) {
        LOG.info("deactivating search service");
        this.stopTracking();
        this.componentContext = null;
        LOG.info("deactivated search service");
    }

    @Override
    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    public String getDefaultSearchServerName() {
        return "default";
    }

    public <E> Result<E> search(Query query, DocumentMapper<E> documentMapper) {
        return this.search(this.getDefaultSearchServerName(), query, documentMapper);
    }

    public <E> Result<E> search(String searchServerName, final Query query, DocumentMapper<E> documentMapper) {
        SolrQuery solrQuery = this.mapQueryToSolrQuery(query);
        this.lock.readLock().lock();
        try {
            SolrServer querySolrServer = (SolrServer)this.queryServers.get(searchServerName);
            if (querySolrServer == null) {
                throw new SearchException("could not find query server for server name: " + searchServerName);
            }
            QueryResponse r = querySolrServer.query((SolrParams)solrQuery);
            final SolrDocumentList resultDocuments = r.getResults();
            final ArrayList<Object> entries = new ArrayList<Object>();
            for (SolrDocument solrDocument : resultDocuments) {
                Object instance = documentMapper.getInstance();
                if (instance == null) continue;
                entries.add(instance);
                for (String fieldName : solrDocument.getFieldNames()) {
                    Object value = solrDocument.getFieldValue(fieldName);
                    documentMapper.setValue(instance, fieldName, value);
                }
            }
            Result result = new Result<E>(){

                public List<E> getEntries() {
                    return entries;
                }

                public long getNumberOfHits() {
                    return resultDocuments.getNumFound();
                }

                public Query getQuery() {
                    return query;
                }

                public Iterator<E> iterator() {
                    return entries.iterator();
                }
            };
            return result;
        }
        catch (SolrServerException ex) {
            throw new SearchException("could not execute search query: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void removeFromIndex(DocumentFieldValueProvider documentFieldValueProvider) {
        this.removeFromIndex(documentFieldValueProvider, this.getDefaultSearchServerName());
    }

    public void removeFromIndex(DocumentFieldValueProvider documentFieldValueProvider, String searchServerName) {
        StringBuilder q = null;
        for (DocumentFieldValue documentFieldValue : documentFieldValueProvider.getDocumentFieldValues()) {
            if (q == null) {
                q = new StringBuilder();
            } else {
                q.append(" AND ");
            }
            q.append(documentFieldValue.getFieldName());
            q.append(':');
            q.append(documentFieldValue.getValue());
        }
        this.solrRequestCommiter.delete(q.toString(), searchServerName);
    }

    public void flush() {
        this.solrRequestCommiter.flush(this.getDefaultSearchServerName());
    }

    public void flush(String searchServerName) {
        this.solrRequestCommiter.flush(searchServerName);
    }

    public void addToIndex(DocumentFieldValueProvider documentFieldValueProvider) {
        this.addToIndex(documentFieldValueProvider, this.getDefaultSearchServerName());
    }

    public void addToIndex(DocumentFieldValueProvider documentFieldValueProvider, String searchServerName) {
        SolrInputDocument inputDocument = new SolrInputDocument();
        List values = documentFieldValueProvider.getDocumentFieldValues();
        if (values != null) {
            for (DocumentFieldValue documentFieldValue : values) {
                String fieldName = documentFieldValue.getFieldName();
                Object value = documentFieldValue.getValue();
                if (fieldName == null) continue;
                if (BoostedDocumentFieldValue.class.isInstance(documentFieldValue)) {
                    BoostedDocumentFieldValue b = (BoostedDocumentFieldValue)BoostedDocumentFieldValue.class.cast(documentFieldValue);
                    inputDocument.setField(fieldName, value, b.getBoost());
                    continue;
                }
                inputDocument.setField(fieldName, value);
            }
        }
        this.solrRequestCommiter.append(inputDocument, searchServerName);
    }

    private SolrQuery mapQueryToSolrQuery(Query query) {
        SolrQuery q = new SolrQuery();
        q.setStart(query.getStart());
        q.setRows(query.getRows());
        q.setRequestHandler(query.getRequestHandler());
        q.setQuery(query.getQ());
        q.setFields(query.getFields());
        if (query.getSortField() != null) {
            SolrQuery.ORDER order = SolrQuery.ORDER.desc;
            if (query.isAscending()) {
                order = SolrQuery.ORDER.asc;
            }
            q.setSort(query.getSortField(), order);
        }
        return q;
    }

    public void setSolrRequestCommiter(SolrRequestCommiter solrRequestCommiter) {
        this.solrRequestCommiter = solrRequestCommiter;
    }
}

