/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.search.impl;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={SolrConfiguration.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(factory=true, ocd=Configuration.class)
public class SolrConfiguration {
    private String name;
    private String baseUrl;

    @Activate
    public void activate(Configuration configuration) {
        this.name = configuration.name();
        this.baseUrl = configuration.baseUrl();
    }

    public String getName() {
        return this.name;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @ObjectClassDefinition(name="Solr Configuration", description="The Solr configuration defines a Solr instance that will be made accessible to clients in the OSGI container.")
    public static @interface Configuration {
        @AttributeDefinition(name="Name", description="The name will be used for the client service registration in the OSGI container.")
        public String name() default "default";

        @AttributeDefinition(name="URL", description="The URL of the Solr server, that shall be contacted via the client.")
        public String baseUrl() default "http://localhost:8081/solr";
    }
}

