/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.search.impl;

import java.util.concurrent.locks.Lock;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.bndly.common.osgi.util.ServiceRegistrationBuilder;
import org.bndly.search.api.SearchServiceListener;
import org.bndly.search.impl.SolrConfiguration;
import org.bndly.search.impl.SolrServerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SolrInstanceInitializer
implements Runnable {
    private final SolrServerFactory.SolrInstance solrInstance;
    private final BundleContext bundleContext;
    private final Lock listenerLock;
    private final Iterable<SearchServiceListener> listeners;
    private final HttpSolrServer queryServer;
    private final HttpSolrServer updateServer;
    private final SolrConfiguration configuration;
    private boolean didInit;
    private static final Logger LOG = LoggerFactory.getLogger(SolrInstanceInitializer.class);

    public SolrInstanceInitializer(SolrServerFactory.SolrInstance solrInstance, BundleContext bundleContext, Lock listenerLock, Iterable<SearchServiceListener> listeners) {
        if (solrInstance == null) {
            throw new IllegalArgumentException("solrInstance is not allowed to be null");
        }
        this.solrInstance = solrInstance;
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext is not allowed to be null");
        }
        this.bundleContext = bundleContext;
        if (listenerLock == null) {
            throw new IllegalArgumentException("listenerLock is not allowed to be null");
        }
        this.listenerLock = listenerLock;
        if (listeners == null) {
            throw new IllegalArgumentException("listeners is not allowed to be null");
        }
        this.listeners = listeners;
        this.queryServer = solrInstance.getQueryServer();
        this.updateServer = solrInstance.getUpdateServer();
        this.configuration = solrInstance.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            if (this.didInit) {
                return;
            }
            try {
                SolrPingResponse r = this.queryServer.ping();
                if (r == null) break block9;
                ServiceRegistration queryServerRegistration = ServiceRegistrationBuilder.newInstance(SolrServer.class, (Object)this.queryServer).pid(SolrServer.class.getName() + ".query." + this.configuration.getName()).property("serverName", (Object)this.configuration.getName()).property("query", (Object)Boolean.TRUE).register(this.bundleContext);
                this.solrInstance.addRegistration((ServiceRegistration<SolrServer>)queryServerRegistration);
                ServiceRegistration updateServerRegistration = ServiceRegistrationBuilder.newInstance(SolrServer.class, (Object)this.updateServer).pid(SolrServer.class.getName() + ".update." + this.configuration.getName()).property("serverName", (Object)this.configuration.getName()).property("update", (Object)Boolean.TRUE).register(this.bundleContext);
                this.solrInstance.addRegistration((ServiceRegistration<SolrServer>)updateServerRegistration);
                this.didInit = true;
                this.solrInstance.didInit();
                this.listenerLock.lock();
                try {
                    for (SearchServiceListener searchServiceListener : this.listeners) {
                        try {
                            searchServiceListener.searchServiceIsReady(this.configuration.getName());
                        }
                        catch (Exception ex) {
                            LOG.error("search service listener failed while handling ready event: " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                finally {
                    this.listenerLock.unlock();
                }
            }
            catch (Exception e) {
                LOG.error("could not initialize solr instance: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

