/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.search.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.bndly.search.impl.AbstractSolrServerTracker;
import org.bndly.search.impl.TransactionState;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SolrRequestCommiter.class}, immediate=true)
@Designate(ocd=Configuration.class)
public class SolrRequestCommiter
extends AbstractSolrServerTracker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SolrRequestCommiter.class);
    private ComponentContext componentContext;
    private final List<WorkItem> workItems = new ArrayList<WorkItem>();
    private final ReadWriteLock workItemsLock = new ReentrantReadWriteLock();
    private long sleepTime = 3000L;
    private ScheduledExecutorService service;

    @Activate
    public void activate(Configuration configuration, ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.sleepTime = configuration.sleepTime();
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.service.scheduleAtFixedRate(this, 0L, this.sleepTime, TimeUnit.MILLISECONDS);
        this.startTracking();
    }

    @Deactivate
    public void deactivate() {
        this.workItemsLock.writeLock().lock();
        try {
            this.stopTracking();
            if (this.service != null) {
                this.service.shutdown();
            }
            this.service = null;
            this.componentContext = null;
            LOG.info("deactivating solr request commiter, but {} work items had not been processes", (Object)this.workItems.size());
            this.workItems.clear();
        }
        finally {
            this.workItemsLock.writeLock().unlock();
        }
    }

    @Override
    protected ComponentContext getComponentContext() {
        return this.componentContext;
    }

    public void append(final SolrInputDocument inputDocument, final String targetServer) {
        this.workItemsLock.writeLock().lock();
        try {
            this.workItems.add(new WorkItem(){

                @Override
                public WorkMode getMode() {
                    return WorkMode.ADD;
                }

                @Override
                public String getTargetServer() {
                    return targetServer;
                }

                @Override
                public void attachTo(UpdateRequest updateRequest) {
                    updateRequest.add(inputDocument, Boolean.valueOf(true));
                }
            });
        }
        finally {
            this.workItemsLock.writeLock().unlock();
        }
    }

    public void delete(final String deleteQuery, final String targetServer) {
        this.workItemsLock.writeLock().lock();
        try {
            this.workItems.add(new WorkItem(){

                @Override
                public WorkMode getMode() {
                    return WorkMode.DELETE;
                }

                @Override
                public String getTargetServer() {
                    return targetServer;
                }

                @Override
                public void attachTo(UpdateRequest updateRequest) {
                    updateRequest.deleteByQuery(deleteQuery);
                }
            });
        }
        finally {
            this.workItemsLock.writeLock().unlock();
        }
    }

    public void flushAll() {
        this.run();
    }

    public void flush(String serverName) {
        this.flushWorkItems(serverName);
    }

    @Override
    public void run() {
        this.flushAllWorkItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAllWorkItems() {
        this.lock.readLock().lock();
        this.workItemsLock.writeLock().lock();
        try {
            Iterator<WorkItem> iterator = this.workItems.iterator();
            TransactionState transactionState = new TransactionState(this.updateServers);
            while (iterator.hasNext()) {
                WorkItem item = iterator.next();
                transactionState.append(item);
                iterator.remove();
            }
            transactionState.flush();
        }
        finally {
            this.workItemsLock.writeLock().unlock();
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushWorkItems(String serverName) {
        this.lock.readLock().lock();
        this.workItemsLock.writeLock().lock();
        try {
            Iterator<WorkItem> iterator = this.workItems.iterator();
            WorkMode currentMode = null;
            UpdateRequest currentUpdateRequest = null;
            while (iterator.hasNext()) {
                WorkItem item = iterator.next();
                if (!serverName.equals(item.getTargetServer())) continue;
                if (currentMode == null && currentUpdateRequest == null) {
                    currentMode = item.getMode();
                    currentUpdateRequest = new UpdateRequest();
                    item.attachTo(currentUpdateRequest);
                    iterator.remove();
                    continue;
                }
                if (currentMode != item.getMode()) {
                    if (currentUpdateRequest != null) {
                        SolrServer updateSolrServer = (SolrServer)this.updateServers.get(serverName);
                        if (updateSolrServer == null) {
                            LOG.warn("could not flush work items, because the target solr update server {} was not available", (Object)serverName);
                            continue;
                        }
                        try {
                            UpdateResponse updateResponse = currentUpdateRequest.process(updateSolrServer);
                            updateSolrServer.commit();
                        }
                        catch (IOException | SolrServerException e) {
                            LOG.error("failed to commit update request to solr update server " + serverName, e);
                        }
                    }
                    currentMode = null;
                    currentUpdateRequest = null;
                    continue;
                }
                if (currentUpdateRequest == null) continue;
                item.attachTo(currentUpdateRequest);
                iterator.remove();
            }
        }
        finally {
            this.workItemsLock.writeLock().unlock();
            this.lock.readLock().unlock();
        }
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    static interface WorkItem {
        public WorkMode getMode();

        public String getTargetServer();

        public void attachTo(UpdateRequest var1);
    }

    static enum WorkMode {
        ADD,
        DELETE;

    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition(name="Sleep time", description="The time in milliseconds to sleep between commits towards solr.")
        public long sleepTime() default 3000L;
    }
}

