/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.search.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.bndly.common.osgi.util.DictionaryAdapter;
import org.bndly.search.api.SearchServiceListener;
import org.bndly.search.impl.SolrConfiguration;
import org.bndly.search.impl.SolrInstanceInitializer;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SolrServerFactory.class}, immediate=true)
@Designate(ocd=Configuration.class)
public class SolrServerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SolrServerFactory.class);
    @Reference(name="httpClient")
    private HttpClient httpClient;
    private ComponentContext componentContext;
    private final List<Runnable> lazyInits = new ArrayList<Runnable>();
    private final List<SolrInstance> solrInstances = new ArrayList<SolrInstance>();
    private final ReadWriteLock solrInstancesLock = new ReentrantReadWriteLock();
    private final List<SearchServiceListener> listeners = new ArrayList<SearchServiceListener>();
    private final ReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private ScheduledExecutorService threadPoolExecutor;
    private int sleepTime = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(ComponentContext componentContext) {
        LOG.info("activating solr server factory");
        DictionaryAdapter adapter = new DictionaryAdapter(componentContext.getProperties()).emptyStringAsNull();
        int threadCount = adapter.getInteger("threadCount", Integer.valueOf(2));
        this.sleepTime = adapter.getInteger("sleepTime", Integer.valueOf(this.sleepTime));
        this.threadPoolExecutor = Executors.newScheduledThreadPool(threadCount);
        this.componentContext = componentContext;
        this.solrInstancesLock.writeLock().lock();
        try {
            for (Runnable lazyInit : this.lazyInits) {
                lazyInit.run();
            }
            this.lazyInits.clear();
        }
        finally {
            this.solrInstancesLock.writeLock().unlock();
        }
        LOG.info("activated solr server factory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate(ComponentContext componentContext) {
        this.solrInstancesLock.writeLock().lock();
        try {
            for (SolrInstance solrInstance : this.solrInstances) {
                solrInstance.destroy();
            }
            this.solrInstances.clear();
        }
        finally {
            this.solrInstancesLock.writeLock().unlock();
        }
        this.lazyInits.clear();
        this.threadPoolExecutor.shutdown();
        this.httpClient = null;
        componentContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, bind="addSearchServiceListener", unbind="removeSearchServiceListener", service=SearchServiceListener.class, policy=ReferencePolicy.DYNAMIC)
    public void addSearchServiceListener(SearchServiceListener listener) {
        if (listener != null) {
            this.listenersLock.writeLock().lock();
            try {
                this.listeners.add(listener);
                this.solrInstancesLock.readLock().lock();
                try {
                    for (SolrInstance solrInstance : this.solrInstances) {
                        if (!solrInstance.didInit) continue;
                        listener.searchServiceIsReady(solrInstance.configuration.getName());
                    }
                }
                finally {
                    this.solrInstancesLock.readLock().unlock();
                }
            }
            finally {
                this.listenersLock.writeLock().unlock();
            }
        }
    }

    public void removeSearchServiceListener(SearchServiceListener listener) {
        if (listener != null) {
            this.listenersLock.writeLock().lock();
            try {
                this.listeners.remove(listener);
            }
            finally {
                this.listenersLock.writeLock().unlock();
            }
        }
    }

    @Reference(bind="addSolrConfiguration", unbind="removeSolrConfiguration", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, service=SolrConfiguration.class)
    public void addSolrConfiguration(SolrConfiguration solrConfiguration) {
        if (solrConfiguration != null) {
            this.solrInstancesLock.writeLock().lock();
            try {
                SolrInstance solrInstance = new SolrInstance(solrConfiguration);
                this.solrInstances.add(solrInstance);
                solrInstance.init();
            }
            finally {
                this.solrInstancesLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSolrConfiguration(SolrConfiguration solrConfiguration) {
        if (solrConfiguration != null) {
            this.solrInstancesLock.writeLock().lock();
            try {
                Iterator<SolrInstance> iterator = this.solrInstances.iterator();
                while (iterator.hasNext()) {
                    SolrInstance next = iterator.next();
                    if (next.configuration != solrConfiguration) continue;
                    iterator.remove();
                    next.destroy();
                }
            }
            finally {
                this.solrInstancesLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrServer getUpdateServer(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is not allowed to be null");
        }
        this.solrInstancesLock.readLock().lock();
        try {
            for (SolrInstance solrInstance : this.solrInstances) {
                if (!name.equals(solrInstance.configuration.getName())) continue;
                HttpSolrServer httpSolrServer = solrInstance.updateServer;
                return httpSolrServer;
            }
            Iterator<SolrInstance> iterator = null;
            return iterator;
        }
        finally {
            this.solrInstancesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrServer getQueryServer(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is not allowed to be null");
        }
        this.solrInstancesLock.readLock().lock();
        try {
            for (SolrInstance solrInstance : this.solrInstances) {
                if (!name.equals(solrInstance.configuration.getName())) continue;
                HttpSolrServer httpSolrServer = solrInstance.queryServer;
                return httpSolrServer;
            }
            Iterator<SolrInstance> iterator = null;
            return iterator;
        }
        finally {
            this.solrInstancesLock.readLock().unlock();
        }
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    class SolrInstance {
        private final SolrConfiguration configuration;
        private HttpSolrServer queryServer;
        private HttpSolrServer updateServer;
        private final List<ServiceRegistration<SolrServer>> registrations = new ArrayList<ServiceRegistration<SolrServer>>();
        private ScheduledFuture<?> initFuture;
        private boolean didInit;
        private SolrInstanceInitializer initializer;

        public SolrInstance(SolrConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException("configuration is not allowed to be null");
            }
            this.configuration = configuration;
        }

        public HttpSolrServer getUpdateServer() {
            return this.updateServer;
        }

        public HttpSolrServer getQueryServer() {
            return this.queryServer;
        }

        public SolrConfiguration getConfiguration() {
            return this.configuration;
        }

        private void init() {
            if (SolrServerFactory.this.componentContext == null) {
                SolrServerFactory.this.lazyInits.add(new Runnable(){

                    @Override
                    public void run() {
                        SolrInstance.this.init();
                    }
                });
            } else {
                this.didInit = false;
                try {
                    LOG.info("creating query solr server");
                    this.queryServer = new HttpSolrServer(this.configuration.getBaseUrl(), SolrServerFactory.this.httpClient);
                    LOG.info("created query solr server");
                }
                catch (Exception e) {
                    LOG.info("creation of query solr server failed: " + e.getMessage(), (Throwable)e);
                }
                try {
                    LOG.info("creating update solr server");
                    this.updateServer = new HttpSolrServer(this.configuration.getBaseUrl(), SolrServerFactory.this.httpClient);
                    LOG.info("created update solr server");
                }
                catch (Exception e) {
                    LOG.info("creation of update solr server failed: " + e.getMessage(), (Throwable)e);
                }
                this.initializer = new SolrInstanceInitializer(this, SolrServerFactory.this.componentContext.getBundleContext(), SolrServerFactory.this.listenersLock.readLock(), SolrServerFactory.this.listeners);
                this.initFuture = SolrServerFactory.this.threadPoolExecutor.scheduleAtFixedRate(this.initializer, SolrServerFactory.this.sleepTime, SolrServerFactory.this.sleepTime, TimeUnit.MILLISECONDS);
            }
        }

        private void destroy() {
            if (this.initFuture != null) {
                this.initFuture.cancel(true);
            }
            for (ServiceRegistration<SolrServer> registration : this.registrations) {
                registration.unregister();
            }
            this.registrations.clear();
            if (this.queryServer != null) {
                this.queryServer.shutdown();
                this.queryServer = null;
            }
            if (this.updateServer != null) {
                this.updateServer.shutdown();
                this.updateServer = null;
            }
        }

        void addRegistration(ServiceRegistration<SolrServer> registration) {
            this.registrations.add(registration);
        }

        void didInit() {
            this.didInit = true;
        }
    }

    @ObjectClassDefinition(name="Solr Server Factory", description="This is a factory to create connections to Solr instances")
    public static @interface Configuration {
        @AttributeDefinition(name="Sleep time", description="The amount of milliseconds to wait between solr instance initialization retries.")
        public int sleepTime() default 5000;

        @AttributeDefinition(name="Thread Count", description="The count of threads to use for initializing Solr connections.")
        public int threadCount() default 2;

        @AttributeDefinition(name="HTTP Client", description="An OSGI filter expression to select the HTTP Client service to use for Solr connections.")
        public String httpClient_target() default "(service.pid=org.apache.http.client.HttpClient.solr)";
    }
}

