/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.search.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.bndly.search.impl.SolrRequestCommiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionState {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionState.class);
    private final Map<String, SolrServer> updateServers;
    private String currentTargetServer = null;
    private SolrRequestCommiter.WorkMode currentMode = null;
    private UpdateRequest currentUpdateRequest = null;

    public TransactionState(Map<String, SolrServer> updateServers) {
        this.updateServers = updateServers;
    }

    TransactionState append(SolrRequestCommiter.WorkItem item) {
        if (this.isNoWorkQueued()) {
            this.currentTargetServer = item.getTargetServer();
            this.currentMode = item.getMode();
            this.currentUpdateRequest = new UpdateRequest();
            item.attachTo(this.currentUpdateRequest);
        } else if (this.isSimilarWorkQueued(item)) {
            item.attachTo(this.currentUpdateRequest);
        } else {
            this.flush();
            return this.append(item);
        }
        return this;
    }

    private boolean isSimilarWorkQueued(SolrRequestCommiter.WorkItem item) {
        return item.getTargetServer().equals(this.currentTargetServer) && item.getMode().equals((Object)this.currentMode);
    }

    private boolean isNoWorkQueued() {
        return this.currentTargetServer == null && this.currentMode == null && this.currentUpdateRequest == null;
    }

    private boolean isWorkQueued() {
        return this.currentTargetServer != null && this.currentMode != null && this.currentUpdateRequest != null;
    }

    void flush() {
        if (this.isNoWorkQueued()) {
            return;
        }
        try {
            SolrServer updateSolrServer = this.updateServers.get(this.currentTargetServer);
            if (updateSolrServer == null) {
                LOG.warn("could not flush work items, because the target solr update server {} was not available", (Object)this.currentTargetServer);
                return;
            }
            try {
                UpdateResponse updateResponse = this.currentUpdateRequest.process(updateSolrServer);
                updateSolrServer.commit();
            }
            catch (IOException | SolrServerException e) {
                LOG.error("failed to commit update request to solr update server " + this.currentTargetServer, e);
            }
        }
        finally {
            this.currentTargetServer = null;
            this.currentMode = null;
            this.currentUpdateRequest = null;
        }
    }
}

