/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.service.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bndly.common.service.cache.api.Cache;
import org.bndly.common.service.cache.api.CacheKeyProvider;

public class ChainedCache
implements Cache {
    private final List<Cache> caches = new ArrayList<Cache>();

    public ChainedCache(Cache ... caches) {
        if (caches != null) {
            for (Cache cache : caches) {
                if (cache == null) continue;
                this.caches.add(cache);
            }
        }
        if (this.caches.isEmpty()) {
            throw new IllegalArgumentException("created a chained cache without providing any chaches");
        }
    }

    public ChainedCache(List<Cache> caches) {
        if (caches != null) {
            for (Cache cache : caches) {
                if (cache == null) continue;
                this.caches.add(cache);
            }
        }
        if (this.caches.isEmpty()) {
            throw new IllegalArgumentException("created a chained cache without providing any chaches");
        }
    }

    public boolean existsInCache(CacheKeyProvider key) {
        for (Cache cache : this.caches) {
            if (!cache.existsInCache(key)) continue;
            return true;
        }
        return false;
    }

    public Object getCachedValue(CacheKeyProvider key) {
        Cache cache;
        Object value = null;
        Iterator<Cache> iterator = this.caches.iterator();
        while (iterator.hasNext() && (value = (cache = iterator.next()).getCachedValue(key)) == null) {
        }
        return value;
    }

    public void storeValue(CacheKeyProvider key, Object value) {
        for (Cache cache : this.caches) {
            cache.storeValue(key, value);
        }
    }
}

